/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.xr;

import ch.ewv.taxstatement.pdf.TaxStatementPDFConstant;
import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.w3c.dom.Document;

public class TaxStatementXRLayout
extends TaxStatementSSKLayout {
    public static final boolean CODE128 = true;
    public static final boolean FOOTER = true;
    public static final boolean HEADER = true;
    public static final boolean SSK = false;
    public static final String HEADER_BOTTOM_LINE = "true";
    public static final float HEADER_BOTTOM_WIDTH = 1.0f;
    public static final int UNIT_PRICE_DECIMAL = 3;
    public static final int UNIT_PRICE_DECIMAL_MAX = 5;

    @Override
    protected boolean code128() {
        return System.getProperty("code128") != null ? TaxStatementPDFProperty.CODE128 : true;
    }

    @Override
    protected boolean footer() {
        return System.getProperty("footer") != null ? TaxStatementPDFProperty.FOOTER : true;
    }

    @Override
    protected boolean header() {
        return System.getProperty("header") != null ? TaxStatementPDFProperty.HEADER : true;
    }

    @Override
    protected String headerBottomLine() {
        return System.getProperty("headerBottomLine") != null ? TaxStatementPDFProperty.HEADER_BOTTOM_LINE : HEADER_BOTTOM_LINE;
    }

    @Override
    protected float headerBottomWidth() {
        return System.getProperty("headerBottomWidth") != null ? TaxStatementPDFProperty.HEADER_BOTTOM_WIDTH : 1.0f;
    }

    @Override
    protected boolean ssk() {
        return System.getProperty("ssk") != null ? TaxStatementPDFProperty.SSK : false;
    }

    @Override
    protected int unitPriceDecimal() {
        return System.getProperty("unitPriceDecimal") != null ? TaxStatementPDFProperty.UNIT_PRICE_DECIMAL : 3;
    }

    @Override
    protected int unitPriceDecimalMax() {
        return System.getProperty("unitPriceDecimalMax") != null ? TaxStatementPDFProperty.UNIT_PRICE_DECIMAL_MAX : 5;
    }

    @Override
    public void addClient(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs) throws IOException, ParseException, XPathExpressionException {
        if (this.header()) {
            int row = -1;
            int ya = this.ya(page, this.ya());
            int yb = this.ya(page, this.yb());
            int xe = this.xe(page, this.xe(), false);
            int col2 = this.xe(page, this.col2(), false);
            int col3 = this.xe(page, this.col3(), false);
            if (!this.landscape(page)) {
                col2 = col3 - (this.col3() - this.col2());
            }
            if (this.client()) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "CLIENT") + ":");
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row++, TaxStatementPDFUtil.getText(data, TaxStatementPDFConstant.CLIENT_NAME_1, ""));
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row++, TaxStatementPDFUtil.getText(data, TaxStatementPDFConstant.CLIENT_NAME_2, ""));
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "CLIENT_NR") + ":");
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row++, TaxStatementPDFUtil.getText(data, TaxStatementPDFConstant.ACCOUNT_ID, ""));
            } else {
                row += 3;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "PERIOD") + ":");
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row++, TaxStatementPDFSchemaData.getPeriodFrom(doc, "dd.MM.yyyy") + " - " + TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy"));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "CURRENCY") + ":");
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row++, "CHF");
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "COUNTRY") + ":");
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row++, TaxStatementPDFUtil.getText(lang, "COUNTRY_" + TaxStatementPDFSchemaData.getCountry(doc)));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "CANTON") + ":");
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row++, TaxStatementPDFUtil.getText(lang, "CANTON_" + TaxStatementPDFSchemaData.getCanton(doc)));
        }
    }

    @Override
    public void addTitle(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs, String key) throws IOException, ParseException, XPathExpressionException {
        int ya = this.ya(page, this.ya());
        int xa = this.xa(page, this.xa(), false);
        if (key != null) {
            TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 80, TaxStatementPDFUtil.getText(lang, "TAX_STATEMENT_EXTENDED") + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()) + " - " + TaxStatementPDFUtil.getText(lang, key));
        } else {
            TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 80, TaxStatementPDFUtil.getText(lang, "TAX_STATEMENT") + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()));
        }
    }
}

