/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.trwht;

import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKBankAccount;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOverview;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKSecurity;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTR;
import ch.ewv.taxstatement.pdf.trwht.TaxStatementTRWHTBankAccount;
import ch.ewv.taxstatement.pdf.trwht.TaxStatementTRWHTLayout;
import ch.ewv.taxstatement.pdf.trwht.TaxStatementTRWHTOverview;
import ch.ewv.taxstatement.pdf.trwht.TaxStatementTRWHTSecurity;

public class TaxStatementTRWHT
extends TaxStatementTR {
    public static final boolean BANK_ACCOUNT = true;
    public static final boolean CRYPTO = false;
    public static final boolean EXPENSE = false;
    public static final boolean LIABILITY = false;
    public static final boolean NON_RECOVERABLE = true;
    public static final boolean OTHER = false;
    public static final boolean SECURITY = true;
    public static final boolean SECURITY_WITH_WITHHOLDING_TAX = true;
    public static final boolean SECURITY_WITHOUT_WITHHOLDING_TAX = false;
    public static final boolean TAX_RECLAIM = true;

    @Override
    protected boolean isBankAccount() {
        return System.getProperty("bankAccount") != null ? TaxStatementPDFProperty.BANK_ACCOUNT : true;
    }

    @Override
    protected boolean isCrypto() {
        return System.getProperty("crypto") != null ? TaxStatementPDFProperty.CRYPTO : false;
    }

    @Override
    protected boolean isExpense() {
        return System.getProperty("expense") != null ? TaxStatementPDFProperty.EXPENSE : false;
    }

    @Override
    protected boolean isLiability() {
        return System.getProperty("liability") != null ? TaxStatementPDFProperty.LIABILITY : false;
    }

    @Override
    protected boolean isNonRecoverable() {
        return System.getProperty("nonRecoverable") != null ? TaxStatementPDFProperty.NON_RECOVERABLE : true;
    }

    @Override
    protected boolean isOther() {
        return System.getProperty("other") != null ? TaxStatementPDFProperty.OTHER : false;
    }

    @Override
    protected boolean isSecurity() {
        return System.getProperty("security") != null ? TaxStatementPDFProperty.SECURITY : true;
    }

    @Override
    protected boolean isSecurityWithHoldingTax() {
        return System.getProperty("securityWithHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITH_HOLDING_TAX : true;
    }

    @Override
    protected boolean isSecurityWithOutHoldingTax() {
        return System.getProperty("securityWithoutHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITHOUT_HOLDING_TAX : true;
    }

    @Override
    protected boolean isTaxReclaim() {
        return System.getProperty("taxReclaim") != null ? TaxStatementPDFProperty.TAX_RECLAIM : true;
    }

    @Override
    protected TaxStatementSSKBankAccount bankAccount() {
        return this.isBankAccount() ? new TaxStatementTRWHTBankAccount() : null;
    }

    @Override
    protected TaxStatementSSKLayout layout() {
        return this.isLayout() ? new TaxStatementTRWHTLayout() : null;
    }

    @Override
    protected TaxStatementSSKOverview overview() {
        return this.isOverview() ? new TaxStatementTRWHTOverview() : null;
    }

    @Override
    protected TaxStatementSSKSecurity security() {
        return this.isSecurity() ? new TaxStatementTRWHTSecurity() : null;
    }
}

