/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.tr;

import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.w3c.dom.Document;

public class TaxStatementTRLayout
extends TaxStatementSSKLayout {
    public static final boolean CLIENT = false;
    public static final boolean CODE128 = false;
    public static final boolean FOOTER = false;
    public static final boolean HEADER = false;
    public static final boolean SSK = false;
    public static final int UNIT_PRICE_DECIMAL = 3;
    public static final int UNIT_PRICE_DECIMAL_MAX = 5;

    @Override
    protected boolean client() {
        return System.getProperty("client") != null ? TaxStatementPDFProperty.CLIENT : false;
    }

    @Override
    protected boolean code128() {
        return System.getProperty("code128") != null ? TaxStatementPDFProperty.CODE128 : false;
    }

    @Override
    protected boolean footer() {
        return System.getProperty("footer") != null ? TaxStatementPDFProperty.FOOTER : false;
    }

    @Override
    protected boolean header() {
        return System.getProperty("header") != null ? TaxStatementPDFProperty.HEADER : false;
    }

    @Override
    protected boolean ssk() {
        return System.getProperty("ssk") != null ? TaxStatementPDFProperty.SSK : false;
    }

    @Override
    protected int unitPriceDecimal() {
        return System.getProperty("unitPriceDecimal") != null ? TaxStatementPDFProperty.UNIT_PRICE_DECIMAL : 3;
    }

    @Override
    protected int unitPriceDecimalMax() {
        return System.getProperty("unitPriceDecimalMax") != null ? TaxStatementPDFProperty.UNIT_PRICE_DECIMAL_MAX : 5;
    }

    @Override
    public void addTitle(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs, String key) throws IOException, ParseException, XPathExpressionException {
        int ya = this.ya();
        int xa = this.xa();
        if (key != null) {
            TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 80, TaxStatementPDFUtil.getText(lang, "TAX_STATEMENT") + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()) + " - " + TaxStatementPDFUtil.getText(lang, key));
        } else {
            TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 80, TaxStatementPDFUtil.getText(lang, "TAX_STATEMENT") + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()));
        }
    }
}

