/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.tr;

import ch.ewv.taxstatement.pdf.TaxStatementPDFFormula;
import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSK;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKBankAccount;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKBarCode;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKCrypto;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKDisclaimer;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKDocument;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKExpense;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLegend;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLiabilityAccount;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKNonRecoverable;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOther;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKOverview;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKSecurity;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKTaxReclaim;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRBankAccount;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRBarCode;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRCrypto;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRDisclaimer;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRDocument;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRExpense;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRLayout;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRLegend;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRLiabilityAccount;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRNonRecoverable;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTROther;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTROverview;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRSecurity;
import ch.ewv.taxstatement.pdf.tr.TaxStatementTRTaxReclaim;
import java.awt.Dimension;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementTR
extends TaxStatementSSK {
    public static String CONTENT = "csv";
    public static final String FONT = "frutiger45light.ttf";
    public static final String BOLD = "frutiger45lightb.ttf";
    public static final boolean CATEGORY = true;
    public static final boolean EXTENDED = true;
    public static final String IBAN = "strong";
    public static final int UNIT_PRICE_DECIMAL = 6;
    public static final String VNISIN = "true";
    public static final boolean BANK_ACCOUNT = true;
    public static final boolean BAR_CODE = false;
    public static final boolean DISCLAIMER = false;
    public static final boolean DOCUMENT = false;
    public static final boolean CRYPTO = true;
    public static final boolean EXPENSE = true;
    public static final boolean LAYOUT = true;
    public static final boolean LEGEND = true;
    public static final boolean LIABILITY = true;
    public static final boolean NON_RECOVERABLE = true;
    public static final boolean OTHER = true;
    public static final boolean OVERVIEW = true;
    public static final boolean SECURITY = true;
    public static final boolean SECURITY_WITH_HOLDING_TAX = true;
    public static final boolean SECURITY_WITHOUT_HOLDING_TAX = true;
    public static final boolean TAX_RECLAIM = false;
    public static final String MESSAGE = "tr-messages_";
    public static final int OFFSET_X = 0;
    public static final int OFFSET_Y = 35;
    public static final int ROWS = 33;

    @Override
    protected String content() {
        return System.getProperty("content") != null ? TaxStatementPDFProperty.CONTENT : CONTENT;
    }

    @Override
    protected PDFont bold(PDDocument pdd) throws IOException {
        return this.bold(pdd, TaxStatementPDFProperty.BOLD != null ? TaxStatementPDFProperty.BOLD : BOLD);
    }

    @Override
    protected PDFont font(PDDocument pdd) throws IOException {
        return this.font(pdd, TaxStatementPDFProperty.FONT != null ? TaxStatementPDFProperty.FONT : FONT);
    }

    @Override
    protected Properties language(String language) throws IOException {
        return this.language(language, MESSAGE);
    }

    protected int offsetX() {
        return TaxStatementPDFProperty.OFFSET_X != 0 ? TaxStatementPDFProperty.OFFSET_X : 0;
    }

    protected int offsetY() {
        return TaxStatementPDFProperty.OFFSET_Y != 0 ? TaxStatementPDFProperty.OFFSET_Y : 35;
    }

    protected int rows() {
        return System.getProperty("rows") != null ? TaxStatementPDFProperty.ROWS : 33;
    }

    @Override
    protected boolean isBankAccount() {
        return System.getProperty("bankAccount") != null ? TaxStatementPDFProperty.BANK_ACCOUNT : true;
    }

    @Override
    protected boolean isBarCode() {
        return System.getProperty("pdf417") != null ? TaxStatementPDFProperty.PDF417 : false;
    }

    @Override
    protected boolean isCrypto() {
        return System.getProperty("crypto") != null ? TaxStatementPDFProperty.CRYPTO : true;
    }

    @Override
    protected boolean isDisclaimer() {
        return System.getProperty("disclaimer") != null ? TaxStatementPDFProperty.DISCLAIMER != null && !TaxStatementPDFProperty.DISCLAIMER.equals("false") : false;
    }

    @Override
    protected boolean isDocument() {
        return System.getProperty("document") != null ? TaxStatementPDFProperty.DOCUMENT != null && !TaxStatementPDFProperty.DOCUMENT.equals("false") : false;
    }

    @Override
    protected boolean isExpense() {
        return System.getProperty("expense") != null ? TaxStatementPDFProperty.EXPENSE : true;
    }

    @Override
    protected boolean isLayout() {
        return System.getProperty("layout") != null ? TaxStatementPDFProperty.LAYOUT : true;
    }

    @Override
    protected boolean isLegend() {
        return System.getProperty("legend") != null ? TaxStatementPDFProperty.LEGEND : true;
    }

    @Override
    protected boolean isLiability() {
        return System.getProperty("liability") != null ? TaxStatementPDFProperty.LIABILITY : true;
    }

    @Override
    protected boolean isNonRecoverable() {
        return System.getProperty("nonRecoverable") != null ? TaxStatementPDFProperty.NON_RECOVERABLE : true;
    }

    @Override
    protected boolean isOther() {
        return System.getProperty("other") != null ? TaxStatementPDFProperty.OTHER : true;
    }

    @Override
    protected boolean isOverview() {
        return System.getProperty("overview") != null ? TaxStatementPDFProperty.OVERVIEW : true;
    }

    @Override
    protected boolean isSecurity() {
        return System.getProperty("security") != null ? TaxStatementPDFProperty.SECURITY : true;
    }

    @Override
    protected boolean isSecurityWithHoldingTax() {
        return System.getProperty("securityWithHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITH_HOLDING_TAX : true;
    }

    @Override
    protected boolean isSecurityWithOutHoldingTax() {
        return System.getProperty("securityWithoutHoldingTax") != null ? TaxStatementPDFProperty.SECURITY_WITHOUT_HOLDING_TAX : true;
    }

    @Override
    protected boolean isTaxReclaim() {
        return System.getProperty("taxReclaim") != null ? TaxStatementPDFProperty.TAX_RECLAIM : false;
    }

    @Override
    protected TaxStatementSSKBankAccount bankAccount() {
        return this.isBankAccount() ? new TaxStatementTRBankAccount() : null;
    }

    @Override
    protected TaxStatementSSKBarCode barCode() {
        return this.isBarCode() ? new TaxStatementTRBarCode() : null;
    }

    @Override
    protected TaxStatementSSKCrypto crypto() {
        return this.isCrypto() ? new TaxStatementTRCrypto() : null;
    }

    @Override
    protected TaxStatementSSKDisclaimer disclaimer() {
        return this.isDisclaimer() ? new TaxStatementTRDisclaimer() : null;
    }

    @Override
    protected TaxStatementSSKDocument document() {
        return this.isDocument() ? new TaxStatementTRDocument() : null;
    }

    @Override
    protected TaxStatementSSKExpense expense() {
        return this.isExpense() ? new TaxStatementTRExpense() : null;
    }

    @Override
    protected TaxStatementSSKLayout layout() {
        return this.isLayout() ? new TaxStatementTRLayout() : null;
    }

    @Override
    protected TaxStatementSSKLegend legend() {
        return this.isLegend() ? new TaxStatementTRLegend() : null;
    }

    protected TaxStatementSSKLiabilityAccount liabilityAccount() {
        return this.isLiability() ? new TaxStatementTRLiabilityAccount() : null;
    }

    @Override
    protected TaxStatementSSKNonRecoverable nonRecoverable() {
        return this.isNonRecoverable() ? new TaxStatementTRNonRecoverable() : null;
    }

    @Override
    protected TaxStatementSSKOther other() {
        return this.isOther() ? new TaxStatementTROther() : null;
    }

    @Override
    protected TaxStatementSSKOverview overview() {
        return this.isOverview() ? new TaxStatementTROverview() : null;
    }

    @Override
    protected TaxStatementSSKSecurity security() {
        return this.isSecurity() ? new TaxStatementTRSecurity() : null;
    }

    @Override
    protected TaxStatementSSKTaxReclaim taxReclaim() {
        return this.isTaxReclaim() ? new TaxStatementTRTaxReclaim() : null;
    }

    @Override
    protected PDDocument translate(byte[] xml, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementPDFFormula formula = this.formula(doc);
        PDDocument pdd = new PDDocument();
        PDFont font = this.font(pdd);
        PDFont bold = this.bold(pdd);
        PDImageXObject logo = this.logo(pdd);
        Dimension size = this.size();
        TaxStatementSSKLayout layout = this.layout();
        PDDocument document = this.documentPDF();
        PDDocument disclaimer = this.disclaimerPDF();
        this.addDocument(pdd, font, bold, layout, logo, size, doc, lang, data, content, document);
        this.addOverview(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addBankAccount(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addSecurity(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula, true);
        this.addSecurity(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula, false);
        this.addNonRecoverable(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addTaxReclaim(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addOther(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addCrypto(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addLiabilityAccount(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addExpense(pdd, font, bold, layout, logo, size, doc, lang, data, content, formula);
        this.addLegend(pdd, font, bold, layout, logo, size, doc, lang, data, content);
        this.addBarCode(pdd, font, bold, layout, logo, size, doc, xml, lang, data, content);
        this.addDisclaimer(pdd, font, bold, layout, logo, size, doc, lang, data, content, disclaimer);
        this.addPaging(pdd, font, bold, layout, doc, lang, data);
        return pdd;
    }
}

