/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDFContext;
import ch.ewv.taxstatement.pdf.TaxStatementPDFFormula;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSecurityData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;

public class TaxStatementSSKNonRecoverable
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_NON_RECOVERABLE";
    public static final String HEADER_EXTENDED = "HEADER_NON_RECOVERABLE_EXTENDED";
    public static final String TOTAL = "TOTAL";
    public static final String TOTAL_NON_RECOVERABLE = "TOTAL_NON_RECOVERABLE";
    public static final String COUNTRY_ = "COUNTRY_";
    public static final String CATEGORY_ = "CATEGORY_";
    public static final String BALANCE = "SECURITY_BALANCE";
    public static final String DISPOSITION = "SECURITY_DISPOSITION";
    public static final String PURCHASE = "SECURITY_PURCHASE";
    public static final String DEPOT = "SECURITY_DEPOT";
    public static final String STOCK = "SECURITY_STOCK";
    public static final String TAX_VALUE_NA = "SECURITY_TAX_VALUE_NA";
    public static final String ADDITIONAL_WITH_HOLDING_TAX_USA_LINE1 = "SECURITY_ADDITIONAL_WITH_HOLDING_TAX_USA_LINE1";
    public static final String ADDITIONAL_WITH_HOLDING_TAX_USA_LINE2 = "SECURITY_ADDITIONAL_WITH_HOLDING_TAX_USA_LINE2";
    public static final String ADDITIONAL_WITH_HOLDING_TAX_USA_LINE3 = "SECURITY_ADDITIONAL_WITH_HOLDING_TAX_USA_LINE3";
    public static final String CURRENCY_LINE1 = "SECURITY_CURRENCY_LINE1";
    public static final String CURRENCY_LINE2 = "SECURITY_CURRENCY_LINE2";
    public static final String CURRENCY_LINE3 = "SECURITY_CURRENCY_LINE3";
    public static final String DESCRIPTION_LINE1 = "SECURITY_DESCRIPTION_LINE1";
    public static final String DESCRIPTION_LINE2 = "SECURITY_DESCRIPTION_LINE2";
    public static final String DESCRIPTION_LINE3 = "SECURITY_DESCRIPTION_LINE3";
    public static final String EXCHANGE_RATE_LINE1 = "SECURITY_EXCHANGE_RATE_LINE1";
    public static final String EXCHANGE_RATE_LINE2 = "SECURITY_EXCHANGE_RATE_LINE2";
    public static final String EXCHANGE_RATE_LINE3 = "SECURITY_EXCHANGE_RATE_LINE3";
    public static final String EX_DATE_LINE1 = "SECURITY_EX_DATE_LINE1";
    public static final String EX_DATE_LINE2 = "SECURITY_EX_DATE_LINE2";
    public static final String EX_DATE_LINE3 = "SECURITY_EX_DATE_LINE3";
    public static final String GROSS_REVENUE_B_LINE1 = "SECURITY_GROSS_REVENUE_B_LINE1";
    public static final String GROSS_REVENUE_B_LINE2 = "SECURITY_GROSS_REVENUE_B_LINE2";
    public static final String GROSS_REVENUE_B_LINE3 = "SECURITY_GROSS_REVENUE_B_LINE3";
    public static final String NON_RECOVERABLE_TAX_LINE1 = "SECURITY_NON_RECOVERABLE_TAX_LINE1";
    public static final String NON_RECOVERABLE_TAX_LINE2 = "SECURITY_NON_RECOVERABLE_TAX_LINE2";
    public static final String NON_RECOVERABLE_TAX_LINE3 = "SECURITY_NON_RECOVERABLE_TAX_LINE3";
    public static final String NON_RECOVERABLE_TAX_BOLD1 = "SECURITY_NON_RECOVERABLE_TAX_BOLD1";
    public static final String NON_RECOVERABLE_TAX_BOLD2 = "SECURITY_NON_RECOVERABLE_TAX_BOLD2";
    public static final String NON_RECOVERABLE_TAX_BOLD3 = "SECURITY_NON_RECOVERABLE_TAX_BOLD3";
    public static final String NUMBER_LINE1 = "SECURITY_NUMBER_LINE1";
    public static final String NUMBER_LINE2 = "SECURITY_NUMBER_LINE2";
    public static final String NUMBER_LINE3 = "SECURITY_NUMBER_LINE3";
    public static final String QUANTITY_LINE1 = "SECURITY_QUANTITY_LINE1";
    public static final String QUANTITY_LINE2 = "SECURITY_QUANTITY_LINE2";
    public static final String QUANTITY_LINE3 = "SECURITY_QUANTITY_LINE3";
    public static final String TAX_VALUE_LINE1 = "SECURITY_TAX_VALUE_LINE1";
    public static final String TAX_VALUE_LINE2 = "SECURITY_TAX_VALUE_LINE2";
    public static final String TAX_VALUE_LINE3 = "SECURITY_TAX_VALUE_LINE3";
    public static final String VALUE_LINE1 = "SECURITY_VALUE_LINE1";
    public static final String VALUE_LINE2 = "SECURITY_VALUE_LINE2";
    public static final String VALUE_LINE3 = "SECURITY_VALUE_LINE3";
    public static final String WITH_HOLDING_TAX_CLAIM_LINE1 = "SECURITY_WITH_HOLDING_TAX_CLAIM_LINE1";
    public static final String WITH_HOLDING_TAX_CLAIM_LINE2 = "SECURITY_WITH_HOLDING_TAX_CLAIM_LINE2";
    public static final String WITH_HOLDING_TAX_CLAIM_LINE3 = "SECURITY_WITH_HOLDING_TAX_CLAIM_LINE3";
    public static final int COL1 = 71;
    public static final int COL2 = 130;
    public static final int COL3 = 370;
    public static final int COL4 = 375;
    public static final int COL5 = 460;
    public static final int COL6 = 470;
    public static final int COL7 = 535;
    public static final int COL8 = 594;
    public static final int COL9 = 664;
    public static final int COX9 = 614;
    public static final int COL10 = 734;
    public static final int COX10 = 684;
    public static final int COL11 = 804;
    public static final int NMAX = 45;

    protected int col1() {
        return 71 + this.offsetX();
    }

    protected int col2() {
        return 130 + this.offsetX();
    }

    protected int col3() {
        return 370 + this.offsetX();
    }

    protected int col4() {
        return 375 + this.offsetX();
    }

    protected int col5() {
        return 460 + this.offsetX();
    }

    protected int col6() {
        return 470 + this.offsetX();
    }

    protected int col7() {
        return 535 + this.offsetX();
    }

    protected int col8() {
        return 594 + this.offsetX();
    }

    protected int col9() {
        return 664 + this.offsetX();
    }

    protected int cox9() {
        return 614 + this.offsetX();
    }

    protected int col10() {
        return 734 + this.offsetX();
    }

    protected int cox10() {
        return 684 + this.offsetX();
    }

    protected int col11() {
        return 804 + this.offsetX();
    }

    protected int nmax() {
        return 45;
    }

    protected String hash(Document doc, int depot, int security, Properties lang) throws IOException, ParseException, XPathExpressionException {
        Double valorNumber = TaxStatementPDFSecurityData.getSecurityValorNumber(doc, depot, security);
        String category = TaxStatementPDFSecurityData.getSecurityCategory(doc, depot, security);
        String country = TaxStatementPDFSecurityData.getSecurityCountry(doc, depot, security);
        String name = this.securityName(doc, depot, security);
        String hx = "";
        if (country != null && !this.category()) {
            hx = hx + TaxStatementPDFUtil.normalize(TaxStatementPDFUtil.getText(lang, COUNTRY_ + country.toUpperCase()));
        }
        if (category != null && this.category()) {
            if (category.equals("SHARE")) {
                hx = hx + "1";
            }
            if (category.equals("FUND")) {
                hx = hx + "2";
            }
            if (category.equals("DEVT")) {
                hx = hx + "3";
            }
            if (category.equals("BOND")) {
                hx = hx + "4";
            }
            if (category.equals("COINBULL")) {
                hx = hx + "5";
            }
            if (category.equals("CURRNOTE")) {
                hx = hx + "6";
            }
            if (category.equals("LIBOSWAP")) {
                hx = hx + "7";
            }
            if (category.equals("OPTION")) {
                hx = hx + "8";
            }
            if (category.equals("OTHER")) {
                hx = hx + "9";
            }
            if (name != null && name.length() > 0) {
                hx = hx + TaxStatementPDFUtil.normalize(name);
            }
        }
        hx = valorNumber != null ? hx + new DecimalFormat("000000000").format(valorNumber) : hx + "000000000";
        if (name != null && name.length() > 0) {
            hx = hx + TaxStatementPDFUtil.normalize(name);
        }
        if (security > 0) {
            hx = hx + String.format("%04d", security);
        }
        return hx;
    }

    protected String securityName(Document doc, int depot, int security) throws IOException, ParseException, XPathExpressionException {
        String name = TaxStatementPDFSecurityData.getSecurityName(doc, depot, security);
        String ntax = TaxStatementPDFSecurityData.getTaxValueName(doc, depot, security);
        String country = TaxStatementPDFSecurityData.getSecurityCountry(doc, depot, security);
        String category = TaxStatementPDFSecurityData.getSecurityCategory(doc, depot, security);
        if (name != null && name.length() > 0 && ntax != null && ntax.length() > 0) {
            if (name.length() >= 40) {
                if (ntax.startsWith(name.substring(0, 40))) {
                    name = ntax;
                }
            } else if (ntax.startsWith(name)) {
                name = ntax;
            }
        }
        if (category != null && category.equals("BOND")) {
            Boolean variableInterest = TaxStatementPDFSecurityData.getSecurityVariableInterest(doc, depot, security);
            Double interestRate = TaxStatementPDFSecurityData.getSecurityInterestRate(doc, depot, security);
            if (variableInterest != null && variableInterest.booleanValue()) {
                if (name != null && name.length() > 0) {
                    if (!name.contains("VAR,")) {
                        name = "VAR, " + name;
                    }
                } else {
                    name = "VAR";
                }
            } else if (interestRate != null && interestRate >= 0.0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains("%")) {
                        name = Double.toString(interestRate) + "%, " + name;
                    }
                } else {
                    name = Double.toString(interestRate) + "%";
                }
            }
        }
        if (country != null && !country.equals("XX")) {
            if (name != null && name.length() > 0) {
                if (!name.contains(" " + country) || name.contains(" DEUTSCH")) {
                    name = name + ", " + country;
                }
            } else {
                name = country;
            }
        }
        if (category != null && category.equals("BOND")) {
            String issueYear = TaxStatementPDFSecurityData.getSecurityIssueDate(doc, depot, security, "yyyy");
            String redemptionYear = TaxStatementPDFSecurityData.getSecurityRedemptionDate(doc, depot, security, "yyyy");
            String redemptionDate = TaxStatementPDFSecurityData.getSecurityRedemptionDate(doc, depot, security, "dd.MM.yyyy");
            if (issueYear != null && issueYear.length() > 0 && redemptionYear != null && redemptionYear.length() > 0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains(issueYear) && !name.contains(redemptionYear)) {
                        name = name + ", " + issueYear + "-" + redemptionDate;
                    }
                } else {
                    name = issueYear + "-" + redemptionDate;
                }
            } else if (issueYear != null && issueYear.length() > 0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains(issueYear)) {
                        name = name + ", " + issueYear;
                    }
                } else {
                    name = issueYear;
                }
            } else if (redemptionYear != null && redemptionYear.length() > 0) {
                if (name != null && name.length() > 0) {
                    if (!name.contains(redemptionYear)) {
                        name = name + ", " + redemptionDate;
                    }
                } else {
                    name = redemptionDate;
                }
            }
        }
        return name;
    }

    protected PDPage addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        this.endPage(ct, pdd, font, bold, doc, lang, data);
        PDPage page = new PDPage();
        page.setMediaBox(PDRectangle.A4);
        page.setRotation(90);
        pdd.addPage(page);
        ct.setPage(page).setRow(0).setQuantityDecimal(null).setUnitPriceDecimal(null);
        if (layout != null) {
            layout.addLayout(pdd, font, bold, logo, size, doc, lang, data, content, page, this.extended() ? HEADER_EXTENDED : HEADER);
            layout.addPageBarCode(pdd, font, bold, doc, page, 197);
        }
        return page;
    }

    protected PDPageContentStream addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx) throws IOException, ParseException, XPathExpressionException {
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
        PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
        cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        cs.transform(mx);
        return cs;
    }

    protected void endPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data) throws IOException, ParseException, XPathExpressionException {
        if (ct.getPage() != null) {
            this.addHeader(ct, pdd, font, bold, doc, lang, data, ct.getPage());
        }
    }

    protected void addHeader(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page) throws IOException, ParseException, XPathExpressionException {
        PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
        Color grey = new Color(211, 211, 211);
        cs.transform(mx);
        int yh = this.yh();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col7 = this.col7();
        int col8 = this.col8();
        int col9 = this.col9();
        int col10 = this.col10();
        int col11 = this.col11();
        int row1 = yh + 2 - 10;
        int row2 = yh + 2 - 20;
        int row3 = yh + 2 - 30;
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, yh, xe, row3 - 4, grey);
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row1, TaxStatementPDFUtil.getText(lang, NUMBER_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row2, TaxStatementPDFUtil.getText(lang, NUMBER_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row3, TaxStatementPDFUtil.getText(lang, NUMBER_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row1, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row2, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row3, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE3));
        float cox3 = col3;
        if (ct.getQuantityDecimal() < this.quantityDecimalMax()) {
            cox3 = (float)col3 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.quantityDecimalMax() - ct.getQuantityDecimal()) + "d", 0));
        }
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, row1, TaxStatementPDFUtil.getText(lang, QUANTITY_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, row2, TaxStatementPDFUtil.getText(lang, QUANTITY_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, row3, TaxStatementPDFUtil.getText(lang, QUANTITY_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, row1, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, row2, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, row3, TaxStatementPDFUtil.getText(lang, CURRENCY_LINE3));
        float cox5 = col5;
        if (ct.getUnitPriceDecimal() < this.unitPriceDecimalMax()) {
            cox5 = (float)col5 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.unitPriceDecimalMax() - ct.getUnitPriceDecimal()) + "d", 0));
        }
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, row1, TaxStatementPDFUtil.getText(lang, VALUE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, row2, TaxStatementPDFUtil.getText(lang, VALUE_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, row3, TaxStatementPDFUtil.getText(lang, VALUE_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col6, row1, TaxStatementPDFUtil.getText(lang, EX_DATE_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col6, row2, TaxStatementPDFUtil.getText(lang, EX_DATE_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col6, row3, TaxStatementPDFUtil.getText(lang, EX_DATE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row1, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row2, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, row3, TaxStatementPDFUtil.getText(lang, EXCHANGE_RATE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, row1, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col8, row2, String.format(TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE2), TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy")));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col8, row3, TaxStatementPDFUtil.getText(lang, TAX_VALUE_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, row1, TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col9, row2, String.format(TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE2), this.headerYear() ? TaxStatementPDFSchemaData.getPeriodTo(doc, "yyyy") : ""));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col9, row3, TaxStatementPDFUtil.getText(lang, GROSS_REVENUE_B_LINE3));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col10, row1, TaxStatementPDFUtil.getText(lang, NON_RECOVERABLE_TAX_LINE1), bold, TaxStatementPDFUtil.getText(lang, NON_RECOVERABLE_TAX_BOLD1));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col10, row2, TaxStatementPDFUtil.getText(lang, NON_RECOVERABLE_TAX_LINE2), bold, TaxStatementPDFUtil.getText(lang, NON_RECOVERABLE_TAX_BOLD2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col10, row3, TaxStatementPDFUtil.getText(lang, NON_RECOVERABLE_TAX_LINE3), bold, TaxStatementPDFUtil.getText(lang, NON_RECOVERABLE_TAX_BOLD3));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col11, row1, TaxStatementPDFUtil.getText(lang, ADDITIONAL_WITH_HOLDING_TAX_USA_LINE1));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col11, row2, TaxStatementPDFUtil.getText(lang, ADDITIONAL_WITH_HOLDING_TAX_USA_LINE2));
        TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col11, row3, TaxStatementPDFUtil.getText(lang, ADDITIONAL_WITH_HOLDING_TAX_USA_LINE3));
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
    }

    protected PDPageContentStream addDepot(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot) throws IOException, ParseException, XPathExpressionException {
        int row = ct.getRow();
        String depotNumber = TaxStatementPDFSecurityData.getDepotDepotNumber(doc, depot);
        int ya = this.ya();
        int col2 = this.col2();
        if (row > 0 && ++row > this.rows() - 2) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, DEPOT) + " " + depotNumber);
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addCategory(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String category) throws IOException, ParseException, XPathExpressionException {
        Color grain = new Color(242, 242, 242);
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        if (row > 0 && ++row > this.rows() - 2) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grain, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grain);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, CATEGORY_ + category));
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addCountry(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String country) throws IOException, ParseException, XPathExpressionException {
        Color grain = new Color(242, 242, 242);
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        if (row > 0 && ++row > this.rows() - 2) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grain, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grain);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, COUNTRY_ + country));
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addSecurity(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot, Integer security) throws IOException, ParseException, XPathExpressionException {
        DecimalFormat dfn = new DecimalFormat("########0");
        int row = ct.getRow();
        Double valorNumber = TaxStatementPDFSecurityData.getSecurityValorNumber(doc, depot, security);
        String isin = TaxStatementPDFSecurityData.getSecurityISIN(doc, depot, security);
        String name = this.securityName(doc, depot, security);
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        if (row > 0 && ++row > this.rows()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        if (isin != null && isin.length() > 0 && this.vnisin().equals("true")) {
            name = isin + " - " + name;
        }
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        if (valorNumber != null) {
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col1, ya - row * 10, dfn.format(valorNumber));
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (isin != null && isin.length() > 0 && (valorNumber == null && !this.vnisin().equals("true") || this.vnisin().equals("strong"))) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, isin);
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addPayment(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot, Integer security, Integer payment) throws IOException, ParseException, XPathExpressionException {
        int digits;
        DecimalFormat dfn = new DecimalFormat("########0");
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        DecimalFormat dfx = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.exchangeRateDecimal() + "d", 0));
        DecimalFormat dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.quantityDecimalMax() + "d", 0));
        DecimalFormat dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.unitPriceDecimalMax() + "d", 0));
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat sdx = new SimpleDateFormat("dd.MM.");
        int row = ct.getRow();
        String country = TaxStatementPDFSecurityData.getSecurityCountry(doc, depot, security);
        Date exDate = TaxStatementPDFSecurityData.getPaymentExDate(doc, depot, security, payment);
        Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, payment);
        String quotationType = TaxStatementPDFSecurityData.getPaymentQuotationType(doc, depot, security, payment);
        Double quantity = TaxStatementPDFSecurityData.getPaymentQuantity(doc, depot, security, payment);
        String amountCurrency = TaxStatementPDFSecurityData.getPaymentAmountCurrency(doc, depot, security, payment);
        Double amountPerUnit = TaxStatementPDFSecurityData.getPaymentAmountPerUnit(doc, depot, security, payment);
        Double amount = TaxStatementPDFSecurityData.getPaymentAmount(doc, depot, security, payment);
        Double exchangeRate = TaxStatementPDFSecurityData.getPaymentExchangeRate(doc, depot, security, payment);
        Double grossRevenueDA1AndUSA = TaxStatementPDFSecurityData.getPaymentGrossRevenueB(doc, depot, security, payment);
        Double nonRecoverableTax = TaxStatementPDFSecurityData.getPaymentNonRecoverableTaxAmount(doc, depot, security, payment);
        Double additionalWithHolding = TaxStatementPDFSecurityData.getPaymentAdditionalWithHoldingTaxUSA(doc, depot, security, payment);
        String sign = TaxStatementPDFSecurityData.getPaymentSign(doc, depot, security, payment);
        String name = TaxStatementPDFSecurityData.getPaymentName(doc, depot, security, payment);
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        String name4 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 4));
        String name5 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 5));
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col6 = this.col6();
        int col7 = this.col7();
        int col9 = this.col9();
        int col10 = this.col10();
        int col11 = this.col11();
        if (row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - row * 10, sdf.format(paymentDate));
        if (quantity != null) {
            float cox3 = col3;
            digits = TaxStatementPDFUtil.digits(quantity, this.quantityDecimal(), this.quantityDecimalMax());
            if (digits < this.quantityDecimalMax()) {
                dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox3 = (float)col3 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.quantityDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, ya - row * 10, dfq.format(quantity));
            ct.setQuantityDecimal(digits);
        }
        if (amountCurrency != null && amountCurrency.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, ya - row * 10, amountCurrency);
        }
        if (amountPerUnit != null) {
            float cox5 = col5;
            digits = TaxStatementPDFUtil.digits(amountPerUnit, this.unitPriceDecimal(), this.unitPriceDecimalMax());
            if (digits < this.unitPriceDecimalMax()) {
                dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox5 = (float)col5 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.unitPriceDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, ya - row * 10, dfu.format(amountPerUnit));
            if (quotationType != null && quotationType.equals("PERCENT")) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, cox5 + 1.0f, ya - row * 10, "%");
            }
            ct.setUnitPriceDecimal(digits);
        }
        if (exDate != null) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col6, ya - row * 10, sdx.format(exDate));
        }
        if (exchangeRate != null && amountCurrency != null && !amountCurrency.equals("CHF")) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, ya - row * 10, dfx.format(exchangeRate));
        }
        if (grossRevenueDA1AndUSA != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col9, ya - row * 10, dfd.format(grossRevenueDA1AndUSA));
            if (sign != null && sign.length() > 0) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col9 + 2, ya - row * 10, sign);
            }
        }
        if (nonRecoverableTax != null && nonRecoverableTax > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col10, ya - row * 10, dfd.format(nonRecoverableTax));
        }
        if (additionalWithHolding != null && additionalWithHolding > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col11, ya - row * 10, dfd.format(additionalWithHolding));
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (name4 != null && name4.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name4);
        }
        if (name5 != null && name5.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name5);
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addStock(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot, Integer security, Integer stock) throws IOException, ParseException, XPathExpressionException {
        int digits;
        Date yearBegin = TaxStatementPDFSchemaData.getPeriodFrom(doc);
        DecimalFormat dfn = new DecimalFormat("########0");
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        DecimalFormat dfx = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.exchangeRateDecimal() + "d", 0));
        DecimalFormat dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.quantityDecimalMax() + "d", 0));
        DecimalFormat dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.unitPriceDecimalMax() + "d", 0));
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        int row = ct.getRow();
        Date referenceDate = TaxStatementPDFSecurityData.getStockReferenceDate(doc, depot, security, stock);
        String quotationType = TaxStatementPDFSecurityData.getStockQuotationType(doc, depot, security, stock);
        Double quantity = TaxStatementPDFSecurityData.getStockQuantity(doc, depot, security, stock);
        String balanceCurrency = TaxStatementPDFSecurityData.getStockBalanceCurrency(doc, depot, security, stock);
        Double unitPrice = TaxStatementPDFSecurityData.getStockUnitPrice(doc, depot, security, stock);
        Double balance = TaxStatementPDFSecurityData.getStockBalance(doc, depot, security, stock);
        Double exchangeRate = TaxStatementPDFSecurityData.getStockExchangeRate(doc, depot, security, stock);
        Double value = TaxStatementPDFSecurityData.getStockValue(doc, depot, security, stock);
        Boolean mutation = TaxStatementPDFSecurityData.getStockMutation(doc, depot, security, stock);
        String name = TaxStatementPDFSecurityData.getStockName(doc, depot, security, stock);
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col7 = this.col7();
        if (row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        if (name != null && name.length() > 0 && referenceDate.equals(yearBegin)) {
            name = null;
        }
        if (name == null || name.length() == 0 && mutation != null && !mutation.booleanValue()) {
            name = TaxStatementPDFUtil.nvl(quantity, 0.0) < 0.0 ? TaxStatementPDFUtil.getText(lang, DISPOSITION) : (TaxStatementPDFUtil.nvl(quantity, 0.0) > 0.0 ? TaxStatementPDFUtil.getText(lang, referenceDate.after(yearBegin) ? PURCHASE : BALANCE) : TaxStatementPDFUtil.getText(lang, BALANCE));
        }
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        String name4 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 4));
        String name5 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 5));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - row * 10, sdf.format(referenceDate.before(yearBegin) ? yearBegin : referenceDate));
        if (quantity != null) {
            float cox3 = col3;
            digits = TaxStatementPDFUtil.digits(quantity, this.quantityDecimal(), this.quantityDecimalMax());
            if (digits < this.quantityDecimalMax()) {
                dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox3 = (float)col3 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.quantityDecimalMax() - digits) + "d", 0));
            }
            if (quantity < 0.0) {
                TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, ya - row * 10, "- " + dfq.format(TaxStatementPDFUtil.abs(quantity)));
            } else if (quantity > 0.0 && mutation != null && mutation.booleanValue() && !referenceDate.before(yearBegin)) {
                TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, ya - row * 10, "+ " + dfq.format(quantity));
            } else {
                TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, ya - row * 10, dfq.format(quantity));
            }
            ct.setQuantityDecimal(digits);
        }
        if (balanceCurrency != null && balanceCurrency.length() > 0 && unitPrice != null) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, ya - row * 10, balanceCurrency);
        }
        if (unitPrice != null) {
            float cox5 = col5;
            digits = TaxStatementPDFUtil.digits(unitPrice, this.unitPriceDecimal(), this.unitPriceDecimalMax());
            if (digits < this.unitPriceDecimalMax()) {
                dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox5 = (float)col5 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.unitPriceDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, ya - row * 10, dfu.format(unitPrice));
            if (quotationType != null && quotationType.equals("PERCENT")) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, cox5 + 1.0f, ya - row * 10, "%");
            }
            ct.setUnitPriceDecimal(digits);
        }
        if (exchangeRate != null && balanceCurrency != null && !balanceCurrency.equals("CHF") && unitPrice != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, ya - row * 10, dfx.format(exchangeRate));
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (name4 != null && name4.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name4);
        }
        if (name5 != null && name5.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, name5);
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTaxValue(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Integer depot, Integer security, Double totalTaxValueDA1AndUSA, Double totalGrossRevenueDA1AndUSA, Double totalNonRecoverableTax, Double totalAdditionalWithHoldingUSA) throws IOException, ParseException, XPathExpressionException {
        float cox5;
        int digits;
        Color grain = new Color(242, 242, 242);
        DecimalFormat dfn = new DecimalFormat("########0");
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        DecimalFormat dfx = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.exchangeRateDecimal() + "d", 0));
        DecimalFormat dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.quantityDecimalMax() + "d", 0));
        DecimalFormat dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + this.unitPriceDecimalMax() + "d", 0));
        int row = ct.getRow();
        String currency = TaxStatementPDFSecurityData.getSecurityCurrency(doc, depot, security);
        String quotationType = TaxStatementPDFSecurityData.getTaxValueQuotationType(doc, depot, security);
        Double quantity = TaxStatementPDFSecurityData.getTaxValueQuantity(doc, depot, security);
        String balanceCurrency = TaxStatementPDFSecurityData.getTaxValueBalanceCurrency(doc, depot, security);
        Double balance = TaxStatementPDFSecurityData.getTaxValueBalance(doc, depot, security);
        Double unitPrice = TaxStatementPDFSecurityData.getTaxValueUnitPrice(doc, depot, security);
        Double exchangeRate = TaxStatementPDFSecurityData.getTaxValueExchangeRate(doc, depot, security);
        Boolean undefined = TaxStatementPDFSecurityData.getTaxValueUndefined(doc, depot, security);
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int col4 = this.col4();
        int col5 = this.col5();
        int col7 = this.col7();
        int col8 = this.col8();
        int col9 = this.col9();
        int col10 = this.col10();
        int col11 = this.col11();
        if (row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grain, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grain);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col1, ya - row * 10, TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy"));
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, STOCK));
        if (quantity == null) {
            quantity = 0.0;
        }
        if (quantity != null) {
            float cox3 = col3;
            digits = TaxStatementPDFUtil.digits(quantity, this.quantityDecimal(), this.quantityDecimalMax());
            if (digits < this.quantityDecimalMax()) {
                dfq = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox3 = (float)col3 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.quantityDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox3, ya - row * 10, dfq.format(quantity));
            ct.setQuantityDecimal(digits);
        }
        if (balanceCurrency != null && balanceCurrency.length() > 0 && unitPrice != null) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, ya - row * 10, balanceCurrency);
        } else if (currency != null && currency.length() > 0 && unitPrice != null) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col4, ya - row * 10, currency);
        }
        if (unitPrice != null) {
            cox5 = col5;
            digits = TaxStatementPDFUtil.digits(unitPrice, this.unitPriceDecimal(), this.unitPriceDecimalMax());
            if (digits < this.unitPriceDecimalMax()) {
                dfu = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0));
                cox5 = (float)col5 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.unitPriceDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, ya - row * 10, dfu.format(unitPrice));
            if (quotationType != null && quotationType.equals("PERCENT")) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, cox5 + 1.0f, ya - row * 10, "%");
            }
            ct.setUnitPriceDecimal(digits);
        } else if (undefined != null && undefined.booleanValue() && quantity != null && quantity != 0.0) {
            cox5 = col5;
            digits = TaxStatementPDFUtil.digits(0.0, this.unitPriceDecimal(), this.unitPriceDecimalMax());
            if (digits < this.unitPriceDecimalMax()) {
                cox5 = (float)col5 - TaxStatementPDFUtil.width(font, 8, String.format("%0" + (this.unitPriceDecimalMax() - digits) + "d", 0));
            }
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, cox5, ya - row * 10, TaxStatementPDFUtil.getText(lang, TAX_VALUE_NA));
        }
        if (exchangeRate != null && balanceCurrency != null && !balanceCurrency.equals("CHF") && unitPrice != null) {
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col7, ya - row * 10, dfx.format(exchangeRate));
        }
        if (totalTaxValueDA1AndUSA != null) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, dfd.format(totalTaxValueDA1AndUSA));
        } else if (undefined != null && undefined.booleanValue() && quantity != null && quantity != 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, TaxStatementPDFUtil.getText(lang, TAX_VALUE_NA));
        } else if (quantity != null && quantity == 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, dfd.format(0.0));
        }
        if (totalGrossRevenueDA1AndUSA != null) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, ya - row * 10, dfd.format(totalGrossRevenueDA1AndUSA));
        }
        if (totalNonRecoverableTax != null && totalNonRecoverableTax > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col10, ya - row * 10, dfd.format(totalNonRecoverableTax));
        }
        if (totalAdditionalWithHoldingUSA != null && totalAdditionalWithHoldingUSA > 0.0) {
            TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col11, ya - row * 10, dfd.format(totalAdditionalWithHoldingUSA));
        }
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTotalCategory(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String category, Double totalTaxValueDA1AndUSA, Double totalGrossRevenueDA1AndUSA, Double totalNonRecoverableTax, Double totalAdditionalWithHoldingUSA) throws IOException, ParseException, XPathExpressionException {
        Color grey = new Color(211, 211, 211);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        int col8 = this.col8();
        int col9 = this.col9();
        int col10 = this.col10();
        int col11 = this.col11();
        if (row > 0 && ++row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grey);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, TOTAL) + " " + TaxStatementPDFUtil.getText(lang, CATEGORY_ + category));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, dfd.format(totalTaxValueDA1AndUSA));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, ya - row * 10, dfd.format(totalGrossRevenueDA1AndUSA));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col10, ya - row * 10, dfd.format(totalNonRecoverableTax));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col11, ya - row * 10, dfd.format(totalAdditionalWithHoldingUSA));
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTotalCountry(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String country, Double totalTaxValueDA1AndUSA, Double totalGrossRevenueDA1AndUSA, Double totalNonRecoverableTax, Double totalAdditionalWithHoldingUSA) throws IOException, ParseException, XPathExpressionException {
        Color grey = new Color(211, 211, 211);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        int col8 = this.col8();
        int col9 = this.col9();
        int col10 = this.col10();
        int col11 = this.col11();
        if (row > 0 && ++row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grey);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, TOTAL) + " " + TaxStatementPDFUtil.getText(lang, COUNTRY_ + country));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, dfd.format(totalTaxValueDA1AndUSA));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, ya - row * 10, dfd.format(totalGrossRevenueDA1AndUSA));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col10, ya - row * 10, dfd.format(totalNonRecoverableTax));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col11, ya - row * 10, dfd.format(totalAdditionalWithHoldingUSA));
        ct.setRow(++row);
        return cs;
    }

    protected PDPageContentStream addTotal(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, Double totalTaxValueDA1AndUSA, Double totalGrossRevenueDA1AndUSA, Double totalNonRecoverableTax, Double totalAdditionalWithHoldingUSA) throws IOException, ParseException, XPathExpressionException {
        Color grey = new Color(211, 211, 211);
        DecimalFormat dfd = new DecimalFormat("#,###,###,##0.00");
        int row = ct.getRow();
        int ya = this.ya();
        int xa = this.xa();
        int xe = this.xe();
        int col2 = this.col2();
        int col8 = this.col8();
        int col9 = this.col9();
        int col10 = this.col10();
        int col11 = this.col11();
        if (row > 0 && ++row > this.rmax()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, ya + 8 - row * 10, xe, ya - 4 - row * 10, grey);
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, ya - row * 10, TaxStatementPDFUtil.getText(lang, TOTAL_NON_RECOVERABLE));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col8, ya - row * 10, dfd.format(totalTaxValueDA1AndUSA));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col9, ya - row * 10, dfd.format(totalGrossRevenueDA1AndUSA));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col10, ya - row * 10, dfd.format(totalNonRecoverableTax));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col11, ya - row * 10, dfd.format(totalAdditionalWithHoldingUSA));
        ct.setRow(++row);
        return cs;
    }

    protected void addNonRecoverable(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, TaxStatementPDFFormula formula) throws IOException, ParseException, XPathExpressionException {
        Date yearBegin = TaxStatementPDFSchemaData.getPeriodFrom(doc);
        if (formula.isLumpSumTaxCredit(doc) && TaxStatementPDFSecurityData.getSecurityCount(doc) > 0) {
            TaxStatementPDFContext ct = new TaxStatementPDFContext();
            PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
            PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
            Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
            cs.transform(mx);
            int depots = TaxStatementPDFSecurityData.getDepotCount(doc);
            Double totalTaxValueDA1AndUSA = 0.0;
            Double totalGrossRevenueDA1AndUSA = 0.0;
            Double totalNonRecoverableTax = 0.0;
            Double totalAdditionalWithHoldingUSA = 0.0;
            for (int depot = 1; depot <= depots; ++depot) {
                if (!formula.isLumpSumTaxCredit(doc, depot)) continue;
                if (ct.getRow() > 0) {
                    cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                }
                cs = this.addDepot(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot);
                ArrayList<String> entries = new ArrayList<String>();
                int securities = TaxStatementPDFSecurityData.getSecurityCount(doc, depot);
                for (int security = 1; security <= securities; ++security) {
                    if (!formula.isLumpSumTaxCredit(doc, depot, security)) continue;
                    String entry = this.hash(doc, depot, security, lang);
                    if (entries == null || entries.contains(entry)) continue;
                    entries.add(entry);
                }
                Collections.sort(entries);
                String before = null;
                String category = null;
                String country = null;
                Double subTaxValueDA1AndUSA = 0.0;
                Double subGrossRevenueDA1AndUSA = 0.0;
                Double subNonRecoverableTax = 0.0;
                Double subAdditionalWithHoldingUSA = 0.0;
                for (String entry : entries) {
                    int security = Integer.parseInt(entry.substring(entry.length() - 4));
                    if (!formula.isLumpSumTaxCredit(doc, depot, security)) continue;
                    category = TaxStatementPDFSecurityData.getSecurityCategory(doc, depot, security);
                    country = TaxStatementPDFSecurityData.getSecurityCountry(doc, depot, security);
                    if (before != null && category != null && !category.equals(before) && this.category()) {
                        cs = this.addTotalCategory(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, before, subTaxValueDA1AndUSA, subGrossRevenueDA1AndUSA, subNonRecoverableTax, subAdditionalWithHoldingUSA);
                        subTaxValueDA1AndUSA = 0.0;
                        subGrossRevenueDA1AndUSA = 0.0;
                        subNonRecoverableTax = 0.0;
                        subAdditionalWithHoldingUSA = 0.0;
                    } else if (before != null && country != null && !country.equals(before) && !this.category()) {
                        cs = this.addTotalCountry(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, before, subTaxValueDA1AndUSA, subGrossRevenueDA1AndUSA, subNonRecoverableTax, subAdditionalWithHoldingUSA);
                        subTaxValueDA1AndUSA = 0.0;
                        subGrossRevenueDA1AndUSA = 0.0;
                        subNonRecoverableTax = 0.0;
                        subAdditionalWithHoldingUSA = 0.0;
                    }
                    if ((before == null || category != null && !category.equals(before)) && this.category()) {
                        cs = this.addCategory(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, category);
                        before = category;
                    } else if ((before == null || country != null && !country.equals(before)) && !this.category()) {
                        if (before != null && ct.getRow() > 0) {
                            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                        }
                        cs = this.addCountry(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, country);
                        before = country;
                    }
                    int payments = TaxStatementPDFSecurityData.getPaymentCount(doc, depot, security);
                    int stocks = TaxStatementPDFSecurityData.getStockCount(doc, depot, security);
                    cs = this.addSecurity(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security);
                    Double securityGrossRevenueDA1AndUSA = null;
                    Double securityNonRecoverableTax = null;
                    Double securityAdditionalWithHoldingUSA = null;
                    ArrayList<Date> dates = new ArrayList<Date>();
                    ArrayList<Date> datex = new ArrayList<Date>();
                    for (int payment = 1; payment <= payments; ++payment) {
                        Date exDate = TaxStatementPDFSecurityData.getPaymentExDate(doc, depot, security, payment);
                        Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, payment);
                        if (exDate != null && !dates.contains(exDate) && !exDate.before(yearBegin)) {
                            dates.add(exDate);
                            datex.add(exDate);
                            continue;
                        }
                        if (paymentDate == null || dates.contains(paymentDate) || exDate != null && !exDate.before(yearBegin)) continue;
                        dates.add(paymentDate);
                    }
                    for (int stock = 1; stock <= stocks; ++stock) {
                        Date referenceDate = TaxStatementPDFSecurityData.getStockReferenceDate(doc, depot, security, stock);
                        if (referenceDate == null || dates.contains(referenceDate)) continue;
                        dates.add(referenceDate);
                    }
                    Collections.sort(dates);
                    Collections.sort(datex);
                    for (Date date : dates) {
                        Date referenceDate;
                        int stock;
                        for (stock = 1; stock <= stocks; ++stock) {
                            referenceDate = TaxStatementPDFSecurityData.getStockReferenceDate(doc, depot, security, stock);
                            if (referenceDate == null || !date.equals(referenceDate) || !date.equals(yearBegin)) continue;
                            cs = this.addStock(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security, stock);
                        }
                        for (stock = 1; stock <= stocks && datex.contains(date); ++stock) {
                            referenceDate = TaxStatementPDFSecurityData.getStockReferenceDate(doc, depot, security, stock);
                            if (referenceDate == null || !date.equals(referenceDate) || date.equals(yearBegin)) continue;
                            cs = this.addStock(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security, stock);
                        }
                        for (int payment = 1; payment <= payments; ++payment) {
                            Date exDate = TaxStatementPDFSecurityData.getPaymentExDate(doc, depot, security, payment);
                            Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, payment);
                            if ((exDate == null || !date.equals(exDate) || exDate.before(yearBegin)) && (paymentDate == null || !date.equals(paymentDate) || exDate != null && !exDate.before(yearBegin))) continue;
                            Double grossRevenueDA1AndUSA = TaxStatementPDFSecurityData.getPaymentGrossRevenueB(doc, depot, security, payment);
                            Double nonRecoverableTax = TaxStatementPDFSecurityData.getPaymentNonRecoverableTaxAmount(doc, depot, security, payment);
                            Double additionalWithHoldingUSA = TaxStatementPDFSecurityData.getPaymentAdditionalWithHoldingTaxUSA(doc, depot, security, payment);
                            cs = this.addPayment(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security, payment);
                            if (grossRevenueDA1AndUSA != null) {
                                securityGrossRevenueDA1AndUSA = securityGrossRevenueDA1AndUSA != null ? Double.valueOf(securityGrossRevenueDA1AndUSA + grossRevenueDA1AndUSA) : grossRevenueDA1AndUSA;
                            }
                            if (nonRecoverableTax != null && nonRecoverableTax > 0.0) {
                                securityNonRecoverableTax = securityNonRecoverableTax != null ? Double.valueOf(securityNonRecoverableTax + nonRecoverableTax) : nonRecoverableTax;
                            }
                            if (additionalWithHoldingUSA == null || !(additionalWithHoldingUSA > 0.0)) continue;
                            securityAdditionalWithHoldingUSA = securityAdditionalWithHoldingUSA != null ? Double.valueOf(securityAdditionalWithHoldingUSA + additionalWithHoldingUSA) : additionalWithHoldingUSA;
                        }
                        for (stock = 1; stock <= stocks && !datex.contains(date); ++stock) {
                            referenceDate = TaxStatementPDFSecurityData.getStockReferenceDate(doc, depot, security, stock);
                            if (referenceDate == null || !date.equals(referenceDate) || date.equals(yearBegin)) continue;
                            cs = this.addStock(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security, stock);
                        }
                    }
                    Double taxValue = TaxStatementPDFSecurityData.getTaxValueValue(doc, depot, security);
                    cs = this.addTaxValue(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, depot, security, taxValue, securityGrossRevenueDA1AndUSA, securityNonRecoverableTax, securityAdditionalWithHoldingUSA);
                    if (taxValue != null) {
                        subTaxValueDA1AndUSA = subTaxValueDA1AndUSA + taxValue;
                        totalTaxValueDA1AndUSA = totalTaxValueDA1AndUSA + taxValue;
                    }
                    if (securityGrossRevenueDA1AndUSA != null) {
                        subGrossRevenueDA1AndUSA = subGrossRevenueDA1AndUSA + securityGrossRevenueDA1AndUSA;
                        totalGrossRevenueDA1AndUSA = totalGrossRevenueDA1AndUSA + securityGrossRevenueDA1AndUSA;
                    }
                    if (securityNonRecoverableTax != null && securityNonRecoverableTax > 0.0) {
                        subNonRecoverableTax = subNonRecoverableTax + securityNonRecoverableTax;
                        totalNonRecoverableTax = totalNonRecoverableTax + securityNonRecoverableTax;
                    }
                    if (securityAdditionalWithHoldingUSA == null || !(securityAdditionalWithHoldingUSA > 0.0)) continue;
                    subAdditionalWithHoldingUSA = subAdditionalWithHoldingUSA + securityAdditionalWithHoldingUSA;
                    totalAdditionalWithHoldingUSA = totalAdditionalWithHoldingUSA + securityAdditionalWithHoldingUSA;
                }
                if (category != null && this.category()) {
                    cs = this.addTotalCategory(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, category, subTaxValueDA1AndUSA, subGrossRevenueDA1AndUSA, subNonRecoverableTax, subAdditionalWithHoldingUSA);
                    continue;
                }
                if (country == null || this.category()) continue;
                cs = this.addTotalCountry(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, country, subTaxValueDA1AndUSA, subGrossRevenueDA1AndUSA, subNonRecoverableTax, subAdditionalWithHoldingUSA);
            }
            cs = this.addTotal(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, totalTaxValueDA1AndUSA, totalGrossRevenueDA1AndUSA, totalNonRecoverableTax, totalAdditionalWithHoldingUSA);
            cs.transform(mx);
            cs.transform(mx);
            cs.transform(mx);
            cs.close();
            this.endPage(ct, pdd, font, bold, doc, lang, data);
        }
    }
}

