/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.TaxStatement;
import ch.ewv.taxstatement.pdf.TaxStatementPDFClientData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFInstitutionData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSecurityData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;

public class TaxStatementSSKLayout
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_TAX_STATEMENT";
    public static final String TAX_STATEMENT = "TAX_STATEMENT";
    public static final String TAX_STATEMENT_EXTENDED = "TAX_STATEMENT_EXTENDED";
    public static final String TAX_STATEMENT_ACCOUNT = "TAX_STATEMENT_ACCOUNT";
    public static final String TAX_STATEMENT_ACCOUNT_EXTENDED = "TAX_STATEMENT_ACCOUNT_EXTENDED";
    public static final String CANTON = "CANTON";
    public static final String CANTON_ = "CANTON_";
    public static final String CLIENT = "CLIENT";
    public static final String CLIENT_NR = "CLIENT_NR";
    public static final String COUNTRY = "COUNTRY";
    public static final String COUNTRY_ = "COUNTRY_";
    public static final String CREATED_AT = "CREATED_AT";
    public static final String CURRENCY = "CURRENCY";
    public static final String FOR_TAX_PURPOSE_GENERATED = "FOR_TAX_PURPOSE_GENERATED";
    public static final String OF = "OF";
    public static final String PAGE = "PAGE";
    public static final String PERIOD = "PERIOD";
    public static final String SALUTATION_MR = "SALUTATION_MR";
    public static final String SALUTATION_MRS = "SALUTATION_MRS";
    public static final String SSK = "SSK";
    public static final int YA = 550;
    public static final int YB = 490;
    public static final int YE = 25;
    public static final int XA = 70;
    public static final int XE = 805;
    public static final int XC = 435;
    public static final int SIZE = 90;
    public static final int SPACE = 10;
    public static final int COL1 = 70;
    public static final int COL2 = 580;
    public static final int COL3 = 640;
    public static final float SCALING = 0.80412364f;
    public static final int PY = 14;
    public static final int PX = 29;

    protected boolean isHeaderBottomLine() {
        return this.headerBottomLine() != null && !this.headerBottomLine().equals("false");
    }

    @Override
    protected int ya() {
        return 550 + this.offsetY();
    }

    protected int yb() {
        return 490 + this.offsetY();
    }

    protected int ye() {
        return 25 + this.offsetY();
    }

    @Override
    protected int xa() {
        return 70 + this.offsetX();
    }

    @Override
    protected int xe() {
        return 805 + this.offsetX();
    }

    protected int xc() {
        return 435 + this.offsetX();
    }

    protected int col1() {
        return 70 + this.offsetX();
    }

    protected int col2() {
        return 580 + this.offsetX();
    }

    protected int col3() {
        return 640 + this.offsetX();
    }

    public void addContent(PDDocument pdd, Properties lang, Properties data, Properties content, String key) {
        if (pdd != null && lang != null && content != null && key != null) {
            if (this.isHeaderBottomLine() && !key.endsWith("_EXTENDED")) {
                key = key + "_EXTENDED";
            }
            String k = TaxStatementPDFUtil.getText(lang, key);
            String v = String.valueOf(pdd.getNumberOfPages() + this.pageFrom());
            if (!content.containsKey(k)) {
                content.setProperty(k, v);
            }
        }
    }

    public void addSSK(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs) throws IOException, ParseException, XPathExpressionException {
        if (this.ssk()) {
            int ya = this.ya(page, this.ya());
            int xa = this.xa(page, this.xa(), false);
            int xc = this.xc(page, this.xc());
            int xe = this.xe(page, this.xe());
            TaxStatementPDFUtil.showText(cs, font, 8, Color.RED, xa, ya + 20, TaxStatementPDFUtil.getText(lang, SSK));
            TaxStatementPDFUtil.showTextCenter(cs, font, 8, Color.RED, xc, ya + 20, TaxStatementPDFUtil.getText(lang, HEADER));
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.RED, xe, ya + 20, TaxStatementPDFUtil.getText(lang, FOR_TAX_PURPOSE_GENERATED));
        }
    }

    public void addLogo(PDDocument pdd, PDFont font, PDFont bold, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs) throws IOException, ParseException, XPathExpressionException {
        if (this.header()) {
            int ya = this.ya(page, this.ya());
            int xa = this.xa(page, this.xa(), false);
            if (logo == null) {
                String name = TaxStatementPDFInstitutionData.getInstitutionName(doc);
                if (name != null && name.length() > 40 && this.client()) {
                    String name1 = name.substring(0, 40);
                    String name2 = name.substring(40);
                    if (name.charAt(40) == ' ') {
                        name2 = name.substring(41);
                    } else if (name1.lastIndexOf(" ") > 0) {
                        name1 = name1.substring(0, name1.lastIndexOf(" "));
                        name2 = name.substring(name1.length() + 1);
                    }
                    TaxStatementPDFUtil.showText(cs, bold, 24, Color.BLACK, xa, ya - 10, name1);
                    TaxStatementPDFUtil.showText(cs, bold, 24, Color.BLACK, xa, ya - 30 - 5, name2);
                } else {
                    TaxStatementPDFUtil.showText(cs, bold, 24, Color.BLACK, xa, ya - 10, name);
                }
            } else {
                TaxStatementPDFUtil.drawImage(pdd, cs, xa, ya - 20 + 36 - size.height, (float)size.width, (float)size.height, logo);
            }
        }
    }

    public void addClient(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs) throws IOException, ParseException, XPathExpressionException {
        if (this.header()) {
            int row = 0;
            int clients = TaxStatementPDFClientData.getClientCount(doc);
            if (clients > 2) {
                clients = 2;
            }
            int ya = this.ya(page, this.ya());
            int yb = this.ya(page, this.yb());
            int xe = this.xe(page, this.xe(), false);
            int col2 = this.xe(page, this.col2(), false);
            int col3 = this.xe(page, this.col3(), false);
            if (!this.landscape(page)) {
                col2 = col3 - (this.col3() - this.col2());
            }
            if (this.client()) {
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya, TaxStatementPDFUtil.getText(lang, CLIENT));
                int i = 1;
                while (i <= clients && i <= 2) {
                    String salutation = TaxStatementPDFClientData.getClientSalutation(doc, i);
                    String firstName = TaxStatementPDFClientData.getClientFirstName(doc, i);
                    String lastName = TaxStatementPDFClientData.getClientLastName(doc, i);
                    String mrMrs = salutation != null ? (salutation.equals("1") ? TaxStatementPDFUtil.getText(lang, SALUTATION_MRS) : (salutation.equals("2") ? TaxStatementPDFUtil.getText(lang, SALUTATION_MR) : "")) : "";
                    String name = firstName != null && firstName.length() > 0 ? TaxStatementPDFUtil.concat(firstName, lastName) : TaxStatementPDFUtil.concat(mrMrs, lastName);
                    TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, name);
                    ++i;
                    ++row;
                }
                String clientNumber = "";
                for (int i2 = 1; i2 <= clients && i2 <= 2; ++i2) {
                    String cn = TaxStatementPDFClientData.getClientNumber(doc, i2);
                    if (clientNumber != null && clientNumber.length() > 0) {
                        if (clientNumber.contains(cn)) continue;
                        clientNumber = clientNumber + " / " + cn;
                        continue;
                    }
                    clientNumber = cn;
                }
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, CLIENT_NR));
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, clientNumber);
                ++row;
            } else {
                row = 3;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, PERIOD));
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col3, ya - 10 * row, TaxStatementPDFSchemaData.getPeriodFrom(doc, "dd.MM.yyyy") + " - " + TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy"));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * ++row, TaxStatementPDFUtil.getText(lang, CREATED_AT));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, TaxStatementPDFSchemaData.getCreationDate(doc, "dd.MM.yyyy"));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * ++row, TaxStatementPDFUtil.getText(lang, CANTON));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, TaxStatementPDFUtil.getText(lang, CANTON_ + TaxStatementPDFSchemaData.getCanton(doc)));
            ++row;
            if (this.lines() && !this.isHeaderBottomLine()) {
                if (this.client()) {
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, ya + 10, xe, ya + 10, this.headerBottomWidth());
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, yb + 5, xe, yb + 5, this.headerBottomWidth());
                } else {
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, ya - 30, xe, ya - 30, this.headerBottomWidth());
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, yb + 5, xe, yb + 5, this.headerBottomWidth());
                }
            }
        }
    }

    public void addHeaderBottomLine(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs) throws IOException, ParseException, XPathExpressionException {
        if (this.isHeaderBottomLine()) {
            Color color = Color.BLACK;
            if (this.headerBottomLine() != null && !this.headerBottomLine().equals("true")) {
                color = Color.decode("#" + this.headerBottomLine());
            }
            int yb = this.ya(page, this.yb());
            int xa = this.xa(page, this.xa(), false);
            int xe = this.xe(page, this.xe());
            TaxStatementPDFUtil.drawLine(cs, color, xa, yb, xe, yb, this.headerBottomWidth());
        }
    }

    public void addTitle(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs, String key) throws IOException, ParseException, XPathExpressionException {
        if (this.title() != null && !this.title().equals("false")) {
            int ya = this.ya(page, this.ya());
            int xa = this.xa(page, this.xa(), false);
            if (!this.isHeaderBottomLine()) {
                if (TaxStatementPDFSecurityData.getSecurityCount(doc) > 0) {
                    TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 60, TaxStatementPDFUtil.getText(lang, TAX_STATEMENT) + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()));
                } else {
                    TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 60, TaxStatementPDFUtil.getText(lang, TAX_STATEMENT_ACCOUNT) + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()));
                }
                if (key != null) {
                    TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 80 - 2, TaxStatementPDFUtil.getText(lang, key));
                }
            } else {
                if (key != null && !key.endsWith("_EXTENDED")) {
                    key = key + "_EXTENDED";
                }
                if (TaxStatementPDFSecurityData.getSecurityCount(doc) > 0) {
                    TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 80 - 2, TaxStatementPDFUtil.getText(lang, TAX_STATEMENT_EXTENDED) + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()) + (key != null ? " - " + TaxStatementPDFUtil.getText(lang, key) : ""));
                } else {
                    TaxStatementPDFUtil.showText(cs, bold, 16, Color.BLACK, xa, ya - 80 - 2, TaxStatementPDFUtil.getText(lang, TAX_STATEMENT_ACCOUNT_EXTENDED) + " " + TaxStatementPDFSchemaData.getPeriodTo(doc, this.titleDateFormat()) + (key != null ? " - " + TaxStatementPDFUtil.getText(lang, key) : ""));
                }
            }
        }
    }

    public void addFooter(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs) throws IOException, ParseException, XPathExpressionException {
        if (this.footer()) {
            int ye = this.ye(page, this.ye());
            int xa = this.xa(page, this.xa(), false);
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, xa, ye, TaxStatementPDFUtil.concat(TaxStatementPDFInstitutionData.getInstitutionName(doc), TaxStatementPDFUtil.concat(TaxStatementPDFInstitutionData.getInstitutionUIDOrganisationIdCategory(doc), TaxStatementPDFUtil.replace(TaxStatementPDFInstitutionData.getInstitutionUIDOrganisationId(doc, "000,000,000"), "'", "."), "-"), ", ") + " MWST");
        }
    }

    public void addPageBarCode(PDDocument pdd, PDFont font, PDFont bold, Document doc, PDPage page, int fno) throws IOException, XPathExpressionException {
        this.addPageBarCode(pdd, font, bold, doc, page, fno, true);
    }

    public void addPageBarCode(PDDocument pdd, PDFont font, PDFont bold, Document doc, PDPage page, int fno, boolean text) throws IOException, XPathExpressionException {
        String version = TaxStatement.getVersion(doc);
        if (this.code128()) {
            DecimalFormat df = new DecimalFormat("000");
            String id = null;
            id = version.compareTo("2.2") >= 0 ? "196" + version.replace(".", "") + TaxStatementPDFSchemaData.getId(doc).substring(2, 7) + df.format(pdd.getNumberOfPages() + this.pageFrom()) + (fno == 196 ? "1" : "0") + (this.landscape(page) ? "0" : "1") + ("BOTTOM".equals(this.pageBarCodeBorder()) ? "1" : ("RIGHT".equals(this.pageBarCodeBorder()) ? "4" : ("TOP".equals(this.pageBarCodeBorder()) ? "3" : "2"))) : (version.equals("2.1") ? df.format(fno) + version.replace(".", "") + TaxStatementPDFSchemaData.getId(doc).substring(2, 7) + df.format(pdd.getNumberOfPages() + this.pageFrom()) + "00" + ("BOTTOM".equals(this.pageBarCodeBorder()) ? "1" : ("RIGHT".equals(this.pageBarCodeBorder()) ? "4" : ("TOP".equals(this.pageBarCodeBorder()) ? "3" : "2"))) : df.format(fno) + version.replace(".", "") + TaxStatementPDFSchemaData.getId(doc).substring(2, 7) + df.format(pdd.getNumberOfPages() + this.pageFrom()));
            BufferedImage imx = TaxStatement.pageBarCode(id, this.pageBarCodeText() && text);
            Float x = null;
            Float y = null;
            int rotate = 0;
            if ("BOTTOM".equals(this.pageBarCodeBorder())) {
                rotate = 1;
            } else if ("RIGHT".equals(this.pageBarCodeBorder())) {
                rotate = 2;
            } else if ("TOP".equals(this.pageBarCodeBorder())) {
                rotate = 3;
            }
            if (!this.landscape(page)) {
                rotate = (rotate + 3) % 4;
            }
            for (int r = 0; r < rotate; ++r) {
                imx = TaxStatement.rotate(imx);
            }
            if ("TOP".equals(this.pageBarCodeBorder()) || "BOTTOM".equals(this.pageBarCodeBorder())) {
                if ("BOTTOM".equals(this.pageBarCodeBorder())) {
                    if (!this.landscape(page)) {
                        y = Float.valueOf(14.0f);
                    } else {
                        x = page.getMediaBox().getWidth() < page.getMediaBox().getHeight() ? Float.valueOf(page.getMediaBox().getWidth() - (float)imx.getWidth() * 0.80412364f - 14.0f) : Float.valueOf(page.getMediaBox().getWidth() - (float)imx.getWidth() * 2.0f - 46.63917f);
                    }
                } else if (!this.landscape(page)) {
                    y = Float.valueOf(page.getMediaBox().getHeight() - (float)imx.getHeight() * 0.80412364f - 14.0f);
                } else {
                    x = page.getMediaBox().getWidth() < page.getMediaBox().getHeight() ? Float.valueOf(14.0f) : Float.valueOf(page.getMediaBox().getWidth() - page.getMediaBox().getHeight() - (float)imx.getWidth() * 2.0f + 23.319586f);
                }
                if ("CENTER".equals(this.pageBarCodeAlign())) {
                    if (!this.landscape(page)) {
                        x = Float.valueOf((page.getMediaBox().getWidth() - (float)imx.getWidth() * 0.80412364f) / 2.0f);
                    } else {
                        y = page.getMediaBox().getWidth() < page.getMediaBox().getHeight() ? Float.valueOf((page.getMediaBox().getHeight() - (float)imx.getHeight() * 0.80412364f) / 2.0f) : Float.valueOf((page.getMediaBox().getWidth() - (float)imx.getHeight() * 0.80412364f) / 2.0f);
                    }
                } else if ("RIGHT".equals(this.pageBarCodeAlign())) {
                    if (!this.landscape(page)) {
                        x = Float.valueOf(this.xe(page, page.getMediaBox().getHeight() - 29.0f, false) - (float)imx.getWidth() * 0.80412364f);
                    } else {
                        y = page.getMediaBox().getWidth() < page.getMediaBox().getHeight() ? Float.valueOf(page.getMediaBox().getHeight() - (float)imx.getHeight() * 0.80412364f - 29.0f) : Float.valueOf(page.getMediaBox().getWidth() - (float)imx.getHeight() * 0.80412364f - 29.0f);
                    }
                } else if (!this.landscape(page)) {
                    x = Float.valueOf(this.xa(page, 29.0f, false));
                } else {
                    y = Float.valueOf(29.0f);
                }
            } else if ("LEFT".equals(this.pageBarCodeBorder()) || "RIGHT".equals(this.pageBarCodeBorder())) {
                if ("RIGHT".equals(this.pageBarCodeBorder())) {
                    if (!this.landscape(page)) {
                        x = Float.valueOf(this.xe(page, page.getMediaBox().getHeight() - 14.0f, false) - (float)imx.getWidth() * 0.80412364f);
                    } else {
                        y = page.getMediaBox().getWidth() < page.getMediaBox().getHeight() ? Float.valueOf(page.getMediaBox().getHeight() - (float)imx.getHeight() * 0.80412364f - 14.0f) : Float.valueOf(page.getMediaBox().getWidth() - (float)imx.getHeight() * 0.80412364f - 14.0f);
                    }
                } else if (!this.landscape(page)) {
                    x = Float.valueOf(this.xa(page, 14.0f, false));
                } else {
                    y = Float.valueOf(14.0f);
                }
                if ("CENTER".equals(this.pageBarCodeAlign())) {
                    if (!this.landscape(page)) {
                        y = Float.valueOf((page.getMediaBox().getHeight() - (float)imx.getHeight() * 0.80412364f) / 2.0f);
                    } else {
                        x = page.getMediaBox().getWidth() < page.getMediaBox().getHeight() ? Float.valueOf((page.getMediaBox().getWidth() - (float)imx.getWidth() * 0.80412364f) / 2.0f) : Float.valueOf((page.getMediaBox().getHeight() - (float)imx.getWidth() * 0.80412364f) / 2.0f);
                    }
                } else if ("BOTTOM".equals(this.pageBarCodeAlign())) {
                    if (!this.landscape(page)) {
                        y = Float.valueOf(this.ye(page, (float)this.ye()) + 29.0f - 10.0f);
                    } else {
                        x = page.getMediaBox().getWidth() < page.getMediaBox().getHeight() ? Float.valueOf(page.getMediaBox().getWidth() - (float)imx.getWidth() * 0.80412364f * 2.0f + 29.0f) : Float.valueOf(page.getMediaBox().getHeight() - (float)imx.getWidth() * 0.80412364f * 2.0f + 29.0f);
                    }
                } else if (!this.landscape(page)) {
                    y = Float.valueOf(this.ya(page, (float)this.ya()) - (float)imx.getHeight() * 0.80412364f);
                } else {
                    x = Float.valueOf(29.0f);
                }
            }
            if (x != null && y != null) {
                TaxStatement.addPageBarCode(pdd, page, imx, x.floatValue(), y.floatValue(), 0.8041236400604248);
            }
        }
    }

    public void addPaging(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs, int index) throws IOException, ParseException, XPathExpressionException {
        if (this.footer()) {
            int ye = this.ye(page, this.ye());
            int xe = this.xe(page, this.xe());
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, xe, ye, TaxStatementPDFUtil.getText(lang, PAGE) + " " + (index + this.pageFrom()) + " " + TaxStatementPDFUtil.getText(lang, OF) + " " + (pdd.getNumberOfPages() + this.pageAdd()));
        }
    }

    public void addLayout(PDDocument pdd, PDFont font, PDFont bold, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPage page, String key) throws IOException, ParseException, XPathExpressionException {
        PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
        this.addContent(pdd, lang, data, content, key);
        cs.transform(mx);
        this.addSSK(pdd, font, bold, doc, lang, data, page, cs);
        this.addLogo(pdd, font, bold, logo, size, doc, lang, data, page, cs);
        this.addClient(pdd, font, bold, doc, lang, data, page, cs);
        this.addTitle(pdd, font, bold, doc, lang, data, page, cs, key);
        this.addHeaderBottomLine(pdd, font, bold, doc, lang, data, page, cs);
        this.addFooter(pdd, font, bold, doc, lang, data, page, cs);
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
        this.addDot();
    }
}

