/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.cache.DocumentCache;
import ch.ewv.taxstatement.pdf.TaxStatementPDFConstant;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.w3c.dom.Document;

public class TaxStatementPDFUtil {
    public static Double NaN(Double value) {
        return value != null && !value.isNaN() ? value : null;
    }

    public static Double abs(Double a) {
        return a != null && !a.isNaN() && a < 0.0 ? -a.doubleValue() : a;
    }

    public static Integer abs(Integer a) {
        return a != null && a < 0 ? -a.intValue() : a;
    }

    public static Double add(Double a, Double b) {
        if (a != null && !a.isNaN() && b != null && !b.isNaN()) {
            return a + b;
        }
        if (a != null && !a.isNaN()) {
            return a;
        }
        if (b != null && !b.isNaN()) {
            return b;
        }
        return null;
    }

    public static Integer add(Integer a, Integer b) {
        if (a != null && b != null) {
            return a + b;
        }
        if (a != null) {
            return a;
        }
        if (b != null) {
            return b;
        }
        return null;
    }

    public static String concat(String a, String b) {
        return TaxStatementPDFUtil.concat(a, b, " ");
    }

    public static String concat(String a, String b, String c) {
        if (a != null && a.length() > 0 && b != null && b.length() > 0) {
            return a + c + b;
        }
        if (a != null && a.length() > 0) {
            return a;
        }
        return b;
    }

    public static int digits(Double a, int min, int max) {
        int digits = min;
        if (a != null && !a.isNaN()) {
            boolean equal = false;
            for (int d = min; d <= max && !equal; ++d) {
                String vf;
                if (!TaxStatementPDFUtil.trunc(a, max).equals(TaxStatementPDFUtil.trunc(a, d))) continue;
                digits = d;
                equal = true;
                if (digits <= min) continue;
                do {
                    if (!(vf = new DecimalFormat("#,###,###,##0." + String.format("%0" + digits + "d", 0)).format(a)).endsWith("0")) continue;
                    --digits;
                } while (digits > min && vf.endsWith("0"));
            }
        }
        return digits;
    }

    public static boolean equal(Double a, Double b) {
        return TaxStatementPDFUtil.nvl(a, 0.0).equals(TaxStatementPDFUtil.nvl(b, 0.0));
    }

    public static boolean equal(Double a, Double b, Double t) {
        return TaxStatementPDFUtil.nvl(a, 0.0) >= TaxStatementPDFUtil.nvl(b, 0.0) - t && TaxStatementPDFUtil.nvl(a, 0.0) <= TaxStatementPDFUtil.nvl(b, 0.0) + t || TaxStatementPDFUtil.nvl(b, 0.0) >= TaxStatementPDFUtil.nvl(a, 0.0) - t && TaxStatementPDFUtil.nvl(b, 0.0) <= TaxStatementPDFUtil.nvl(a, 0.0) + t;
    }

    public static boolean equal(Integer a, Integer b) {
        return TaxStatementPDFUtil.nvl(a, 0).equals(TaxStatementPDFUtil.nvl(b, 0));
    }

    public static boolean equal(Integer a, Integer b, Integer t) {
        return TaxStatementPDFUtil.nvl(a, 0) >= TaxStatementPDFUtil.nvl(b, 0) - t && TaxStatementPDFUtil.nvl(a, 0) <= TaxStatementPDFUtil.nvl(b, 0) + t || TaxStatementPDFUtil.nvl(b, 0) >= TaxStatementPDFUtil.nvl(a, 0) - t && TaxStatementPDFUtil.nvl(b, 0) <= TaxStatementPDFUtil.nvl(a, 0) + t;
    }

    public static String normalize(String text) {
        return text != null && text.length() > 0 ? Normalizer.normalize(text, Normalizer.Form.NFD) : text;
    }

    public static String nvl(String a, String b) {
        return a != null && a.length() > 0 ? a : b;
    }

    public static Boolean nvl(Boolean a, Boolean b) {
        return a != null ? a : b;
    }

    public static Boolean nvl(Boolean a, boolean b) {
        return TaxStatementPDFUtil.nvl(a, (Boolean)b);
    }

    public static Double nvl(Double a, Double b) {
        return a != null && !a.isNaN() ? a : b;
    }

    public static Double nvl(Double a, double b) {
        return TaxStatementPDFUtil.nvl(a, (Double)b);
    }

    public static Integer nvl(Integer a, Integer b) {
        return a != null ? a : b;
    }

    public static Integer nvl(Integer a, int b) {
        return TaxStatementPDFUtil.nvl(a, (Integer)b);
    }

    public static String replace(String a, String b, String c) {
        String value = "";
        if (a != null && a.length() > 0) {
            value = a.replace(b, c);
        }
        return value != null && value.length() > 0 ? value : null;
    }

    public static String roman(Integer a) {
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] letters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        String v = "";
        if (a != null && a > 0 && a < 4000) {
            for (int i = 0; i < values.length; ++i) {
                while (a >= values[i]) {
                    a = a - values[i];
                    v = v + letters[i];
                }
            }
        }
        return v != null && v.length() > 0 ? v : null;
    }

    public static Double round(Double a) {
        return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 20.0)) / 20.0) : null;
    }

    public static Double round(Double a, int digits) {
        try {
            if (digits <= 0) {
                return a != null && !a.isNaN() ? Double.valueOf(Math.round(a)) : null;
            }
            if (digits == 1) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 10.0)) / 10.0) : null;
            }
            if (digits == 2) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 100.0)) / 100.0) : null;
            }
            if (digits == 3) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 1000.0)) / 1000.0) : null;
            }
            if (digits == 4) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 10000.0)) / 10000.0) : null;
            }
            return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 100000.0)) / 100000.0) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double trunc(Double a) {
        return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 100.0)) / 100.0) : null;
    }

    public static Double trunc(Double a, int digits) {
        try {
            if (digits <= 0) {
                return a != null && !a.isNaN() ? Double.valueOf((long)(a * 1.0)) : null;
            }
            if (digits == 1) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 10.0)) / 10.0) : null;
            }
            if (digits == 2) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 100.0)) / 100.0) : null;
            }
            if (digits == 3) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 1000.0)) / 1000.0) : null;
            }
            if (digits == 4) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 10000.0)) / 10000.0) : null;
            }
            if (digits == 5) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 100000.0)) / 100000.0) : null;
            }
            if (digits == 6) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 1000000.0)) / 1000000.0) : null;
            }
            if (digits == 7) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 1.0E7)) / 1.0E7) : null;
            }
            return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf((long)(a * 1.0E8)) / 1.0E8) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] split(String v) {
        return v != null && v.length() > 0 ? v.split("\\s+") : null;
    }

    public static String split(String v, int max) {
        String value = v;
        if (value != null && value.length() > max) {
            for (value = value.substring(0, max); value != null && value.length() > 0 && value.charAt(value.length() - 1) != ' ' && value.charAt(value.length() - 1) != '-'; value = value.substring(0, value.length() - 1)) {
            }
            if (value != null && value.length() > 0 && (value.endsWith("CHE-") || value.endsWith("ADM-"))) {
                value = value.substring(0, value.length() - 4);
            }
        }
        return value;
    }

    public static String split(String v, int max, int part) {
        String value = v;
        for (int p = 1; p <= part; ++p) {
            String first = TaxStatementPDFUtil.split(value, max);
            if (first != null && first.length() > 0) {
                if (p < part) {
                    value = value.substring(first.length());
                    continue;
                }
                value = first;
                continue;
            }
            value = null;
        }
        return value;
    }

    public static Double subtract(Double a, Double b) {
        if (a != null && !a.isNaN() && b != null && !b.isNaN()) {
            return a - b;
        }
        if (a != null && !a.isNaN()) {
            return a;
        }
        if (b != null && !b.isNaN()) {
            return -b.doubleValue();
        }
        return null;
    }

    public static Integer subtract(Integer a, Integer b) {
        if (a != null && b != null) {
            return a - b;
        }
        if (a != null) {
            return a;
        }
        if (b != null) {
            return -b.intValue();
        }
        return null;
    }

    public static String trim(String v) {
        return TaxStatementPDFUtil.trim(v, ' ');
    }

    public static String trim(String v, char c) {
        return TaxStatementPDFUtil.ltrim(TaxStatementPDFUtil.rtrim(v, c), c);
    }

    public static String ltrim(String v) {
        return TaxStatementPDFUtil.ltrim(v, ' ');
    }

    public static String ltrim(String v, char c) {
        String value;
        for (value = v; value != null && value.indexOf(c) == 0; value = value.substring(1)) {
        }
        return value != null && value.length() > 0 ? value : null;
    }

    public static String rtrim(String v) {
        return TaxStatementPDFUtil.rtrim(v, ' ');
    }

    public static String rtrim(String v, char c) {
        String value;
        for (value = v; value != null && value.indexOf(c) == value.length() - 1; value = value.substring(0, value.length() - 1)) {
        }
        return value != null && value.length() > 0 ? value : null;
    }

    public static int getCount(Document doc, String exp) throws XPathExpressionException {
        return DocumentCache.count(doc, exp);
    }

    public static String getValue(Document doc, String exp) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, exp, false);
    }

    public static String getValue(Document doc, String exp, boolean empty) throws XPathExpressionException {
        String value = DocumentCache.get(doc, exp, empty);
        return value != null && (value.length() > 0 || empty) ? value : null;
    }

    public static Boolean getValueBoolean(Document doc, String exp) throws ParseException, XPathExpressionException {
        String value = TaxStatementPDFUtil.getValue(doc, exp);
        Boolean b = null;
        if (value != null) {
            if (value.toLowerCase().equals("true") || value.equals("1")) {
                b = Boolean.TRUE;
            } else if (value.toLowerCase().equals("false") || value.equals("0")) {
                b = Boolean.FALSE;
            }
        }
        return b;
    }

    public static Boolean getValueBoolean(Document doc, String exp, boolean d) throws ParseException, XPathExpressionException {
        Boolean b = TaxStatementPDFUtil.getValueBoolean(doc, exp);
        return b != null ? b : Boolean.valueOf(d);
    }

    public static Date getValueDate(Document doc, String exp) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String value = TaxStatementPDFUtil.getValue(doc, exp);
        return value != null && value.length() > 0 ? sdf.parse(value) : null;
    }

    public static String getValueDate(Document doc, String exp, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date value = TaxStatementPDFUtil.getValueDate(doc, exp);
        return value != null ? sdf.format(value) : null;
    }

    public static Date getValueDateTime(Document doc, String exp) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String value = TaxStatementPDFUtil.getValue(doc, exp);
        return value != null && value.length() > 0 ? sdf.parse(value) : null;
    }

    public static String getValueDateTime(Document doc, String exp, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date value = TaxStatementPDFUtil.getValueDateTime(doc, exp);
        return value != null ? sdf.format(value) : null;
    }

    public static Integer getValueInteger(Document doc, String exp) throws XPathExpressionException {
        String value = TaxStatementPDFUtil.getValue(doc, exp);
        return value != null && value.length() > 0 ? Integer.valueOf(value) : null;
    }

    public static Integer getValueInteger(Document doc, String exp, int i) throws XPathExpressionException {
        Integer value = TaxStatementPDFUtil.getValueInteger(doc, exp);
        return value != null ? value : Integer.valueOf(i);
    }

    public static String getValueInteger(Document doc, String exp, String format) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Integer value = TaxStatementPDFUtil.getValueInteger(doc, exp);
        return value != null ? df.format(value) : null;
    }

    public static String getValueInteger(Document doc, String exp, String format, int i) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Integer value = TaxStatementPDFUtil.getValueInteger(doc, exp);
        return value != null ? df.format(value) : df.format((Object)i);
    }

    public static Double getValueNumber(Document doc, String exp) throws XPathExpressionException {
        String value = TaxStatementPDFUtil.getValue(doc, exp);
        return TaxStatementPDFUtil.NaN(value != null && value.length() > 0 ? Double.valueOf(value) : null);
    }

    public static Double getValueNumber(Document doc, String exp, double d) throws XPathExpressionException {
        Double value = TaxStatementPDFUtil.getValueNumber(doc, exp);
        return TaxStatementPDFUtil.NaN(value != null ? value : Double.valueOf(d));
    }

    public static String getValueNumber(Document doc, String exp, String format) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Double value = TaxStatementPDFUtil.getValueNumber(doc, exp);
        return value != null ? df.format(value) : null;
    }

    public static String getValueNumber(Document doc, String exp, String format, double d) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Double value = TaxStatementPDFUtil.getValueNumber(doc, exp);
        return value != null ? df.format(value) : df.format((Object)d);
    }

    public static Properties getLanguage(String language) throws IOException {
        Properties lang = new Properties();
        lang.load(TaxStatementPDFUtil.class.getResourceAsStream("/resources/pdf-messages_" + language + ".properties"));
        return lang;
    }

    public static String getText(Properties lang, String key) {
        return TaxStatementPDFUtil.getText(lang, key, "[" + key + "]");
    }

    public static String getText(Properties lang, String[] keys) {
        String text = null;
        for (String key : keys) {
            text = text != null ? TaxStatementPDFUtil.concat(text, TaxStatementPDFUtil.getText(lang, key, "[" + key + "]")) : TaxStatementPDFUtil.getText(lang, key, "[" + key + "]");
        }
        return text;
    }

    public static String getText(Properties lang, String key, String d) {
        String text = d;
        try {
            text = lang.getProperty(key, d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    protected static int fontSize(PDFont font, int fsize) {
        return fsize + (font.toString().indexOf("Calibri") >= 0 ? 1 : 0);
    }

    public static float width(PDFont font, int fsize, String text) throws IOException {
        return font != null && text != null && text.length() > 0 ? font.getStringWidth(text) * (float)TaxStatementPDFUtil.fontSize(font, fsize) / 1000.0f : 0.0f;
    }

    public static float width(PDFont font, int fsize, String text, PDFont bold, String ... part) throws IOException {
        float width = 0.0f;
        if (text != null && text.length() > 0) {
            if (part != null && part.length > 0) {
                int offset = 0;
                for (int i = 0; i < part.length; ++i) {
                    int index;
                    if (part[i] == null || part[i].length() <= 0 || (index = text.indexOf(part[i])) < 0) continue;
                    if (offset < index) {
                        String before = text.substring(offset, index);
                        width += TaxStatementPDFUtil.width(font, fsize, before);
                    }
                    width += TaxStatementPDFUtil.width(bold, fsize, part[i]);
                    offset = index + part[i].length();
                }
                if (offset < text.length()) {
                    width += TaxStatementPDFUtil.width(font, fsize, text.substring(offset));
                }
            } else {
                width = TaxStatementPDFUtil.width(font, fsize, text);
            }
        }
        return width;
    }

    public static PDImageXObject load(PDDocument pdd, String name) throws IOException {
        BufferedImage image = null;
        if (name != null) {
            try {
                image = ImageIO.read(new File(name));
            }
            catch (Exception e) {
                image = ImageIO.read(TaxStatementPDFUtil.class.getResourceAsStream("/resources/" + name));
            }
        }
        return LosslessFactory.createFromImage((PDDocument)pdd, image);
    }

    public static void drawLine(PDPageContentStream cs, Color color, int xa, int ya, int xe, int ye) throws IOException {
        TaxStatementPDFUtil.drawLine(cs, color, xa, ya, xe, ye, 1.0f);
    }

    public static void drawLine(PDPageContentStream cs, Color color, int xa, int ya, int xe, int ye, float width) throws IOException {
        if (cs != null) {
            cs.setStrokingColor(color);
            cs.setLineWidth(width);
            cs.moveTo((float)xa, (float)ya);
            cs.lineTo((float)xe, (float)ye);
            cs.stroke();
        }
    }

    public static void drawRectangle(PDPageContentStream cs, Color color, int xa, int ya, int xe, int ye) throws IOException {
        TaxStatementPDFUtil.drawRectangle(cs, color, xa, ya, xe, ye, 1.0f);
    }

    public static void drawRectangle(PDPageContentStream cs, Color color, int xa, int ya, int xe, int ye, float width) throws IOException {
        TaxStatementPDFUtil.drawLine(cs, color, xa, ya, xe, ya, width);
        TaxStatementPDFUtil.drawLine(cs, color, xe, ya, xe, ye, width);
        TaxStatementPDFUtil.drawLine(cs, color, xe, ye, xa, ye, width);
        TaxStatementPDFUtil.drawLine(cs, color, xa, ye, xa, ya, width);
    }

    public static void drawRectangle(PDPageContentStream cs, Color color, int xa, int ya, int xe, int ye, Color fill) throws IOException {
        TaxStatementPDFUtil.drawRectangle(cs, color, xa, ya, xe, ye, 1.0f, fill);
    }

    public static void drawRectangle(PDPageContentStream cs, Color color, int xa, int ya, int xe, int ye, float width, Color fill) throws IOException {
        if (cs != null && fill != null) {
            cs.setNonStrokingColor(fill);
            cs.addRect((float)xa, (float)ya, (float)(xe - xa + 1), (float)(ye - ya + 1));
            cs.fill();
        }
        if (cs != null && fill != color) {
            TaxStatementPDFUtil.drawRectangle(cs, color, xa, ya, xe, ye, width);
        }
    }

    public static void drawImage(PDDocument pdd, PDPageContentStream cs, int x, int y, float width, float height, String name) throws IOException {
        cs.drawImage(TaxStatementPDFUtil.load(pdd, name), (float)x, (float)y, width, height);
    }

    public static void drawImage(PDDocument pdd, PDPageContentStream cs, int x, int y, float width, float height, PDImageXObject image) throws IOException {
        if (cs != null && image != null) {
            cs.drawImage(image, (float)x, (float)y, width, height);
        }
    }

    public static void showText(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, String text) throws IOException {
        if (cs != null && font != null && text != null && text.length() > 0) {
            cs.setFont(font, (float)TaxStatementPDFUtil.fontSize(font, fsize));
            cs.setNonStrokingColor(color);
            cs.beginText();
            cs.newLineAtOffset(x, y);
            cs.showText(text);
            cs.endText();
        }
    }

    public static void showText(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, String text, PDFont bold, String ... part) throws IOException {
        if (text != null && text.length() > 0) {
            if (part != null && part.length > 0) {
                float width = 0.0f;
                int offset = 0;
                for (int i = 0; i < part.length; ++i) {
                    int index;
                    if (part[i] == null || part[i].length() <= 0 || (index = text.indexOf(part[i])) < 0) continue;
                    if (offset < index) {
                        String before = text.substring(offset, index);
                        TaxStatementPDFUtil.showText(cs, font, fsize, color, x + width, y, before);
                        width += TaxStatementPDFUtil.width(font, fsize, before);
                    }
                    TaxStatementPDFUtil.showText(cs, bold, fsize, color, x + width, y, part[i]);
                    width += TaxStatementPDFUtil.width(bold, fsize, part[i]);
                    offset = index + part[i].length();
                }
                if (offset < text.length()) {
                    TaxStatementPDFUtil.showText(cs, font, fsize, color, x + width, y, text.substring(offset));
                }
            } else {
                TaxStatementPDFUtil.showText(cs, font, fsize, color, x, y, text);
            }
        }
    }

    public static void showText(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, float xsize, String text) throws IOException {
        if (text != null && text.length() > 0) {
            String[] split = TaxStatementPDFUtil.split(text);
            if (split != null && split.length > 1) {
                float total = 0.0f;
                for (String s : split) {
                    total += TaxStatementPDFUtil.width(font, fsize, s);
                }
                float space = (xsize - total) / (float)(split.length - 1);
                float width = 0.0f;
                for (String s : split) {
                    if (s != null && s.length() > 0) {
                        TaxStatementPDFUtil.showText(cs, font, fsize, color, x + width, y, s);
                    }
                    width += TaxStatementPDFUtil.width(font, fsize, s) + space;
                }
            } else {
                TaxStatementPDFUtil.showText(cs, font, fsize, color, x, y, text);
            }
        }
    }

    public static void showText(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, float xsize, String text, PDFont bold, String ... part) throws IOException {
        if (text != null && text.length() > 0) {
            if (part != null && part.length > 0) {
                String[] split;
                int offset = 0;
                ArrayList<PDFont> lf = new ArrayList<PDFont>();
                ArrayList<String> lt = new ArrayList<String>();
                for (int i = 0; i < part.length; ++i) {
                    String[] split2;
                    int index;
                    if (part[i] == null || part[i].length() <= 0 || (index = text.indexOf(part[i])) < 0) continue;
                    if (offset < index && (split2 = TaxStatementPDFUtil.split(text.substring(offset, index))) != null && split2.length > 0) {
                        for (String s : split2) {
                            lf.add(font);
                            lt.add(s);
                        }
                    }
                    if ((split2 = TaxStatementPDFUtil.split(part[i])) != null && split2.length > 0) {
                        for (String s : split2) {
                            lf.add(bold);
                            lt.add(s);
                        }
                    }
                    offset = index + part[i].length();
                }
                if (offset < text.length() && (split = TaxStatementPDFUtil.split(text.substring(offset))) != null && split.length > 0) {
                    for (String s : split) {
                        lf.add(font);
                        lt.add(s);
                    }
                }
                float total = 0.0f;
                for (int i = 0; i < lt.size() && i < lf.size(); ++i) {
                    total += TaxStatementPDFUtil.width((PDFont)lf.get(i), fsize, (String)lt.get(i));
                }
                float space = (xsize - total) / (float)(lt.size() - 1);
                float width = 0.0f;
                for (int i = 0; i < lt.size() && i < lf.size(); ++i) {
                    if (lt.get(i) != null && ((String)lt.get(i)).length() > 0) {
                        TaxStatementPDFUtil.showText(cs, (PDFont)lf.get(i), fsize, color, x + width, y, (String)lt.get(i));
                    }
                    width += TaxStatementPDFUtil.width((PDFont)lf.get(i), fsize, (String)lt.get(i)) + space;
                }
            } else {
                TaxStatementPDFUtil.showText(cs, font, fsize, color, x, y, xsize, text);
            }
        }
    }

    public static void showTextCenter(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, String text) throws IOException {
        TaxStatementPDFUtil.showText(cs, font, fsize, color, x - TaxStatementPDFUtil.width(font, fsize, text) / 2.0f, y, text);
    }

    public static void showTextCenter(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, String text, PDFont bold, String ... part) throws IOException {
        if (text != null && text.length() > 0) {
            float total = TaxStatementPDFUtil.width(font, fsize, text, bold, part);
            if (part != null && part.length > 0) {
                float width = 0.0f;
                int offset = 0;
                for (int i = 0; i < part.length; ++i) {
                    int index;
                    if (part[i] == null || part[i].length() <= 0 || (index = text.indexOf(part[i])) < 0) continue;
                    if (offset < index) {
                        String before = text.substring(offset, index);
                        TaxStatementPDFUtil.showText(cs, font, fsize, color, x + width - total / 2.0f, y, before);
                        width += TaxStatementPDFUtil.width(font, fsize, before);
                    }
                    TaxStatementPDFUtil.showText(cs, bold, fsize, color, x + width - total / 2.0f, y, part[i]);
                    width += TaxStatementPDFUtil.width(bold, fsize, part[i]);
                    offset = index + part[i].length();
                }
                if (offset < text.length()) {
                    TaxStatementPDFUtil.showText(cs, font, fsize, color, x + width - total / 2.0f, y, text.substring(offset));
                }
            } else {
                TaxStatementPDFUtil.showText(cs, font, fsize, color, x - total / 2.0f, y, text);
            }
        }
    }

    public static void showTextRight(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, String text) throws IOException {
        TaxStatementPDFUtil.showText(cs, font, fsize, color, x - TaxStatementPDFUtil.width(font, fsize, text), y, text);
    }

    public static void showTextRight(PDPageContentStream cs, PDFont font, int fsize, Color color, float x, float y, String text, PDFont bold, String ... part) throws IOException {
        if (text != null && text.length() > 0) {
            float total = TaxStatementPDFUtil.width(font, fsize, text, bold, part);
            if (part != null && part.length > 0) {
                float width = 0.0f;
                int offset = 0;
                for (int i = 0; i < part.length; ++i) {
                    int index;
                    if (part[i] == null || part[i].length() <= 0 || (index = text.indexOf(part[i])) < 0) continue;
                    if (offset < index) {
                        String before = text.substring(offset, index);
                        TaxStatementPDFUtil.showText(cs, font, fsize, color, x + width - total, y, before);
                        width += TaxStatementPDFUtil.width(font, fsize, before);
                    }
                    TaxStatementPDFUtil.showText(cs, bold, fsize, color, x + width - total, y, part[i]);
                    width += TaxStatementPDFUtil.width(bold, fsize, part[i]);
                    offset = index + part[i].length();
                }
                if (offset < text.length()) {
                    TaxStatementPDFUtil.showText(cs, font, fsize, color, x + width - total, y, text.substring(offset));
                }
            } else {
                TaxStatementPDFUtil.showText(cs, font, fsize, color, x - total, y, text);
            }
        }
    }

    public static byte[] extractComment(byte[] xml) {
        byte[] bytes = null;
        if (xml != null && xml.length > 0) {
            int i;
            boolean cmt = false;
            int b = 0;
            byte[] bb = new byte[xml.length];
            byte[] tag = new String("<!--").getBytes();
            byte[] end = new String("-->").getBytes();
            for (i = 0; i < xml.length; ++i) {
                int k;
                int j;
                boolean found;
                if (!cmt) {
                    found = true;
                    j = i;
                    for (k = 0; j < xml.length && k < tag.length && found; ++j, ++k) {
                        found = xml[j] == tag[k];
                    }
                    if (!found) continue;
                    cmt = true;
                    i += tag.length - 1;
                    continue;
                }
                found = true;
                j = i;
                for (k = 0; j < xml.length && k < end.length && found; ++j, ++k) {
                    found = xml[j] == end[k];
                }
                if (found) {
                    cmt = false;
                    i += end.length - 1;
                    continue;
                }
                bb[b] = xml[i];
                ++b;
            }
            if (b > 0 && b <= bb.length) {
                bytes = new byte[b];
                for (i = 0; i < b; ++i) {
                    bytes[i] = bb[i];
                }
            }
        }
        return bytes;
    }

    public static byte[] extractXML(byte[] xml) {
        byte[] bytes = null;
        if (xml != null && xml.length > 0) {
            int i;
            boolean cmt = false;
            int b = 0;
            byte[] bb = new byte[xml.length];
            byte[] tag = new String("<!--").getBytes();
            byte[] end = new String("-->").getBytes();
            for (i = 0; i < xml.length; ++i) {
                int k;
                int j;
                boolean found;
                if (!cmt) {
                    found = true;
                    j = i;
                    for (k = 0; j < xml.length && k < tag.length && found; ++j, ++k) {
                        found = xml[j] == tag[k];
                    }
                    if (!found) {
                        bb[b] = xml[i];
                        ++b;
                        continue;
                    }
                    cmt = true;
                    if (b > 0 && bb[b - 1] == 10) {
                        --b;
                    }
                    if (b <= 0 || bb[b - 1] != 13) continue;
                    --b;
                    continue;
                }
                found = true;
                j = i;
                for (k = 0; j < xml.length && k < end.length && found; ++j, ++k) {
                    found = xml[j] == end[k];
                }
                if (!found) continue;
                cmt = false;
                i += end.length - 1;
            }
            if (b > 0 && b <= bb.length) {
                bytes = new byte[b];
                for (i = 0; i < b; ++i) {
                    bytes[i] = bb[i];
                }
            }
        }
        return bytes;
    }

    public static Properties extractProperty(byte[] xml) throws IOException {
        Properties data = new Properties();
        byte[] bytes = TaxStatementPDFUtil.extractComment(xml);
        if (bytes != null && bytes.length > 0) {
            data.load(new ByteArrayInputStream(bytes));
        }
        return data;
    }

    public static Properties extractProperty(byte[] xml, Document doc) throws IOException, ParseException, XPathExpressionException {
        Properties data = TaxStatementPDFUtil.extractProperty(xml);
        if (data != null && doc != null) {
            String creationDate;
            String accountId;
            if (data.getProperty(TaxStatementPDFConstant.ACCOUNT_ID) == null && (accountId = TaxStatementPDFUtil.getValue(doc, "/taxStatement/client/@clientNumber")) != null) {
                data.setProperty(TaxStatementPDFConstant.ACCOUNT_ID, accountId);
            }
            if (data.getProperty(TaxStatementPDFConstant.CREATION_DATE) == null && (creationDate = TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/@creationDate", "dd.MM.yyyy")) != null) {
                data.setProperty(TaxStatementPDFConstant.CREATION_DATE, creationDate);
            }
        }
        return data;
    }
}

