/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFFont;
import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.TaxStatementPDFTextData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class TaxStatementPDFText
extends PDFTextStripper {
    private boolean extract = false;
    private List<TaxStatementPDFTextData> data = null;

    protected boolean getExtract() {
        return this.extract;
    }

    protected void setExtract(boolean extract) {
        this.extract = extract;
    }

    protected void startPage(PDPage page) throws IOException {
        this.setExtract(true);
        super.startPage(page);
    }

    protected void writeLineSeparator() throws IOException {
        this.setExtract(true);
        super.writeLineSeparator();
    }

    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        if (textPositions != null && textPositions.size() > 0) {
            if (text != null && text.length() > 0) {
                text = text.trim();
            }
            if (text != null && text.length() > 0 && this.getExtract()) {
                TextPosition tp = textPositions.get(0);
                PDColor color = this.getGraphicsState().getNonStrokingColor();
                if (this.getData() != null) {
                    this.getData().add(new TaxStatementPDFTextData().setText(text).setX(Float.valueOf(tp.getXDirAdj())).setY(Float.valueOf(tp.getYDirAdj())).setFont(tp.getFont()).setFontSize(Float.valueOf(tp.getFontSizeInPt())).setColor(color));
                }
                this.setExtract(false);
            }
        }
        super.writeString(text, textPositions);
    }

    public List<TaxStatementPDFTextData> getData() {
        return this.data;
    }

    protected void setData(List<TaxStatementPDFTextData> data) {
        this.data = data;
    }

    public String getText(PDDocument doc) throws IOException {
        this.setData(new ArrayList<TaxStatementPDFTextData>());
        return super.getText(doc);
    }

    public boolean containsPlaceholder() {
        return this.containsPlaceholder(TaxStatementPDFProperty.PLACEHOLDER_PREFIX, TaxStatementPDFProperty.PLACEHOLDER_SUFFIX);
    }

    public boolean containsPlaceholder(String prefix, String suffix) {
        boolean contains = false;
        if (this.getData() != null) {
            for (TaxStatementPDFTextData data : this.getData()) {
                String text;
                if (data == null || (text = data.getText()) == null || text.length() <= 0 || !text.contains(prefix) || !text.contains(suffix)) continue;
                contains = true;
            }
        }
        return contains;
    }

    public PDPage importPage(PDDocument pdd, PDPage page, PDFont font, PDFont bold, Properties data) throws IOException {
        return this.importPage(pdd, page, font, bold, data, TaxStatementPDFProperty.PLACEHOLDER_PREFIX, TaxStatementPDFProperty.PLACEHOLDER_SUFFIX);
    }

    public PDPage importPagX(PDDocument pdd, PDPage page, PDFont font, PDFont bold, Properties data, String prefix, String suffix) throws IOException {
        PDPage p = null;
        if (pdd != null && page != null) {
            p = pdd.importPage(page);
        }
        if (pdd != null && p != null) {
            List<Object> list = TaxStatementPDFText.tokensWithoutPlaceholder(p);
        }
        return p;
    }

    private static void processResources(PDPage page, PDResources resources) throws IOException {
        for (COSName name : resources.getXObjectNames()) {
            PDXObject xobject = resources.getXObject(name);
            if (!(xobject instanceof PDFormXObject)) continue;
            PDFormXObject formXObject = (PDFormXObject)xobject;
            TaxStatementPDFText.processResources(page, formXObject.getResources());
        }
        for (COSName name : resources.getPatternNames()) {
            PDAbstractPattern pattern = resources.getPattern(name);
            if (!(pattern instanceof PDTilingPattern)) continue;
            PDTilingPattern tilingPattern = (PDTilingPattern)pattern;
            TaxStatementPDFText.processResources(page, tilingPattern.getResources());
        }
    }

    private static void writeTokensToStream(PDStream contents, List<Object> tokens) throws IOException {
        try (OutputStream os = contents.createOutputStream(COSName.FLATE_DECODE);){
            ContentStreamWriter writer = new ContentStreamWriter(os);
            writer.writeTokens(tokens);
        }
    }

    private static List<Object> tokensWithoutPlaceholder(PDPage page) throws IOException {
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        ArrayList<Object> tokens = new ArrayList<Object>();
        ArrayList<COSBase> operands = new ArrayList<COSBase>();
        PDFont font = null;
        parser.parse();
        for (Object token : parser.getTokens()) {
            if (token instanceof Operator) {
                int i;
                System.out.println("Operator=" + ((Operator)token).getName());
                for (i = 0; i < operands.size(); ++i) {
                    System.out.println("Operand[" + i + "]=" + ((COSBase)operands.get(i)).toString());
                }
                if ("Tj".equals(((Operator)token).getName()) || "TJ".equals(((Operator)token).getName()) || "'".equals(((Operator)token).getName()) || "\"".equals(((Operator)token).getName())) {
                    if (operands.get(0) instanceof COSString) {
                        ByteArrayInputStream in = new ByteArrayInputStream(((COSString)operands.get(0)).getBytes());
                        while (((InputStream)in).available() > 0) {
                            int code = font.readCode((InputStream)in);
                            System.out.print(font.toUnicode(code));
                            if (font.toUnicode(code) != null) continue;
                            System.out.println("code: " + code);
                        }
                        System.out.println();
                    } else if (operands.get(0) instanceof COSArray) {
                        for (i = 0; i < ((COSArray)operands.get(0)).size(); ++i) {
                            COSBase o = ((COSArray)operands.get(0)).getObject(i);
                            if (!(o instanceof COSString)) continue;
                            ByteArrayInputStream in = new ByteArrayInputStream(((COSString)o).getBytes());
                            while (((InputStream)in).available() > 0) {
                                int code = font.readCode((InputStream)in);
                                System.out.print(font.toUnicode(code));
                            }
                        }
                        System.out.println();
                    } else {
                        System.out.println("else");
                    }
                } else if ("Tf".equals(((Operator)token).getName()) && operands.get(0) instanceof COSName) {
                    font = page.getResources().getFont((COSName)operands.get(0));
                }
                operands = new ArrayList();
                continue;
            }
            if (!(token instanceof COSBase)) continue;
            operands.add((COSBase)token);
        }
        return tokens;
    }

    public PDPage importPage(PDDocument pdd, PDPage page, PDFont font, PDFont bold, Properties data, String prefix, String suffix) throws IOException {
        PDPage p = null;
        if (pdd != null && page != null) {
            p = new PDPage();
            p.setCropBox(page.getCropBox());
            p.setMediaBox(page.getMediaBox());
            p.setRotation(page.getRotation());
            pdd.addPage(p);
            PDPageContentStream cs = new PDPageContentStream(pdd, p, PDPageContentStream.AppendMode.APPEND, true);
            if (this.getData() != null) {
                for (TaxStatementPDFTextData d : this.getData()) {
                    if (d == null) continue;
                    String text = d.getText();
                    Float y = d.getY();
                    if (text == null || text.length() <= 0) continue;
                    if (data != null && suffix != null && prefix != null) {
                        for (Map.Entry<Object, Object> entry : data.entrySet()) {
                            String key = (String)entry.getKey();
                            String search = prefix + key + suffix;
                            if (!text.contains(search)) continue;
                            String value = (String)entry.getValue();
                            if (value != null && value.length() > 0) {
                                value = new String(value.getBytes("iso-8859-1"), "utf-8");
                            }
                            if (value != null && value.length() > 0) {
                                text = text.replace(search, value);
                                continue;
                            }
                            text = text.replace(search, "");
                        }
                    }
                    if (y != null && !y.isNaN()) {
                        y = Float.valueOf(p.getMediaBox().getHeight() - y.floatValue());
                    }
                    TaxStatementPDFUtil.showText(cs, TaxStatementPDFFont.get(pdd, font, bold, d.getFont()), d.getFontSize(), d.getColor(), d.getX().floatValue(), y.floatValue(), text);
                }
            }
            cs.close();
        }
        return p;
    }

    public TaxStatementPDFText() throws IOException {
        this.setSortByPosition(true);
    }

    public TaxStatementPDFText(PDDocument pdd, int page) throws IOException {
        this.setSortByPosition(true);
        this.setStartPage(page);
        this.setEndPage(page);
        this.getText(pdd);
    }
}

