/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.TaxStatement;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementPDFSchemaData {
    public static String getCanton(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/@canton");
    }

    public static String getCountry(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/@country");
    }

    public static Date getCreationDate(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/@creationDate");
    }

    public static String getCreationDate(Document doc, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date creationDate = TaxStatementPDFSchemaData.getCreationDate(doc);
        return creationDate != null ? sdf.format(creationDate) : null;
    }

    public static String getId(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/@id");
    }

    public static String getMinorVersion(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/@minorVersion");
    }

    public static String getSchemaVersion(Document doc, String expr) throws XPathExpressionException {
        String ts = TaxStatement.getElementXML(doc, "taxStatement", false);
        String version = null;
        if (ts != null && ts.indexOf("xmlns") > 0) {
            int xmlns = ts.indexOf("xmlns");
            if (ts.indexOf(expr, xmlns) > 0) {
                version = ts.substring(ts.indexOf(expr, xmlns) + 1);
                if (version != null) {
                    version = version.substring(0, version.indexOf("\""));
                }
            } else {
                version = ts.substring(xmlns);
            }
        } else {
            version = ts;
        }
        return version;
    }

    public static String getTaxPeriod(Document doc) throws XPathExpressionException {
        String taxPeriod = TaxStatementPDFUtil.getValue(doc, "/taxStatement/@taxPeriod");
        return taxPeriod != null && taxPeriod.length() > 4 ? taxPeriod.substring(0, 4) : taxPeriod;
    }

    public static Date getPeriodFrom(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/@periodFrom");
    }

    public static String getPeriodFrom(Document doc, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date periodFrom = TaxStatementPDFSchemaData.getPeriodFrom(doc);
        return periodFrom != null ? sdf.format(periodFrom) : null;
    }

    public static Date getPeriodTo(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/@periodTo");
    }

    public static String getPeriodTo(Document doc, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date periodTo = TaxStatementPDFSchemaData.getPeriodTo(doc);
        return periodTo != null ? sdf.format(periodTo) : null;
    }
}

