/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import org.apache.pdfbox.pdmodel.PDPage;

public abstract class TaxStatementPDFRenderer {
    public static final int YH = 445;
    public static final int YA = 400;
    public static final int XA = 70;
    public static final int XE = 805;
    public static final int LINE = 10;

    protected int yh() {
        return 445 + this.offsetY();
    }

    protected int ya() {
        return 400 + this.offsetY();
    }

    protected int xa() {
        return 70 + this.offsetX();
    }

    protected int xe() {
        return 805 + this.offsetX();
    }

    protected int offsetX() {
        return TaxStatementPDFProperty.OFFSET_X;
    }

    protected int offsetY() {
        return TaxStatementPDFProperty.OFFSET_Y;
    }

    protected int rows() {
        return TaxStatementPDFProperty.ROWS;
    }

    protected int rmax() {
        return this.rows() + 2;
    }

    protected int fmax() {
        return this.rows() + 3;
    }

    protected boolean category() {
        return TaxStatementPDFProperty.CATEGORY;
    }

    protected boolean client() {
        return TaxStatementPDFProperty.CLIENT;
    }

    protected boolean code128() {
        return TaxStatementPDFProperty.CODE128;
    }

    protected boolean debug() {
        return TaxStatementPDFProperty.DEBUG;
    }

    protected boolean decimal() {
        return TaxStatementPDFProperty.DECIMAL;
    }

    protected boolean deductible() {
        return TaxStatementPDFProperty.DEDUCTIBLE;
    }

    protected boolean dot() {
        return TaxStatementPDFProperty.DOT;
    }

    protected boolean extended() {
        return TaxStatementPDFProperty.EXTENDED;
    }

    protected boolean footer() {
        return TaxStatementPDFProperty.FOOTER;
    }

    protected boolean header() {
        return TaxStatementPDFProperty.HEADER;
    }

    protected boolean headerYear() {
        return TaxStatementPDFProperty.HEADER_YEAR;
    }

    protected boolean lines() {
        return TaxStatementPDFProperty.LINES;
    }

    protected boolean overviewCrypto() {
        return TaxStatementPDFProperty.OVERVIEW_CRYPTO;
    }

    protected boolean overviewDA1USA() {
        return TaxStatementPDFProperty.OVERVIEW_DA1USA;
    }

    protected boolean overviewExpense() {
        return TaxStatementPDFProperty.OVERVIEW_EXPENSE;
    }

    protected boolean overviewLiability() {
        return TaxStatementPDFProperty.OVERVIEW_LIABILITY;
    }

    protected boolean overviewOther() {
        return TaxStatementPDFProperty.OVERVIEW_OTHER;
    }

    protected boolean overviewTotal() {
        return TaxStatementPDFProperty.OVERVIEW_TOTAL;
    }

    protected boolean overviewTotalDA1USAOnly() {
        return TaxStatementPDFProperty.OVERVIEW_TOTAL_DA1USA_ONLY;
    }

    protected boolean overviewUndefinedHeader() {
        return TaxStatementPDFProperty.OVERVIEW_UNDEFINED_HEADER;
    }

    protected boolean pageBarCodeText() {
        return TaxStatementPDFProperty.PAGE_BAR_CODE_TEXT;
    }

    protected boolean ssk() {
        return TaxStatementPDFProperty.SSK;
    }

    protected boolean totalAdditionalWithHoldingTaxUSA() {
        return TaxStatementPDFProperty.TOTAL_ADDITIONAL_WITH_HOLDING_TAX_USA;
    }

    protected boolean totalGrossRevenueA() {
        return TaxStatementPDFProperty.TOTAL_GROSS_REVENUE_A;
    }

    protected boolean totalGrossRevenueB() {
        return TaxStatementPDFProperty.TOTAL_GROSS_REVENUE_B;
    }

    protected boolean totalGrossRevenueDA1USA() {
        return TaxStatementPDFProperty.TOTAL_GROSS_REVENUE_DA1USA;
    }

    protected boolean totalLumpSumTaxCreditAmount() {
        return TaxStatementPDFProperty.TOTAL_LUMP_SUM_TAX_CREDIT_AMOUNT;
    }

    protected boolean totalNonRecoverableTaxAmount() {
        return TaxStatementPDFProperty.TOTAL_NON_RECOVERABLE_TAX_AMOUNT;
    }

    protected boolean totalRecoverableTaxAmount() {
        return TaxStatementPDFProperty.TOTAL_RECOVERABLE_TAX_AMOUNT;
    }

    protected boolean totalTaxValue() {
        return TaxStatementPDFProperty.TOTAL_TAX_VALUE;
    }

    protected boolean totalTaxValueAB() {
        return TaxStatementPDFProperty.TOTAL_TAX_VALUE_AB;
    }

    protected boolean totalTaxValueDA1USA() {
        return TaxStatementPDFProperty.TOTAL_TAX_VALUE_DA1USA;
    }

    protected boolean totalWithHolingTaxClaim() {
        return TaxStatementPDFProperty.TOTAL_WITH_HOLDING_TAX_CLAIM;
    }

    protected boolean withHoldingTaxClaim() {
        return TaxStatementPDFProperty.WITH_HOLDING_TAX_CLAIM;
    }

    protected int exchangeRateDecimal() {
        return TaxStatementPDFProperty.EXCHANGE_RATE_DECIMAL;
    }

    protected int pageAdd() {
        return TaxStatementPDFProperty.PAGE_ADD;
    }

    protected int pageFrom() {
        return TaxStatementPDFProperty.PAGE_FROM;
    }

    protected int quantityDecimal() {
        return TaxStatementPDFProperty.QUANTITY_DECIMAL;
    }

    protected int quantityDecimalMax() {
        return TaxStatementPDFProperty.QUANTITY_DECIMAL_MAX;
    }

    protected int unitPriceDecimal() {
        return TaxStatementPDFProperty.UNIT_PRICE_DECIMAL;
    }

    protected int unitPriceDecimalMax() {
        return TaxStatementPDFProperty.UNIT_PRICE_DECIMAL_MAX;
    }

    protected float headerBottomWidth() {
        return TaxStatementPDFProperty.HEADER_BOTTOM_WIDTH;
    }

    protected String content() {
        return TaxStatementPDFProperty.CONTENT;
    }

    protected String headerBottomLine() {
        return TaxStatementPDFProperty.HEADER_BOTTOM_LINE;
    }

    protected String iban() {
        return TaxStatementPDFProperty.IBAN;
    }

    protected String pageBarCodeAlign() {
        return TaxStatementPDFProperty.PAGE_BAR_CODE_ALIGN;
    }

    protected String pageBarCodeBorder() {
        return TaxStatementPDFProperty.PAGE_BAR_CODE_BORDER;
    }

    protected String title() {
        return TaxStatementPDFProperty.TITLE;
    }

    protected String titleDateFormat() {
        return TaxStatementPDFProperty.TITLE_DATE_FORMAT;
    }

    protected String vnisin() {
        return TaxStatementPDFProperty.VNISIN;
    }

    protected void addDot() {
        if (this.dot()) {
            System.out.print(".");
        }
    }

    protected boolean landscape(PDPage page) {
        return page == null || page.getRotation() != 0 || page.getMediaBox() == null || !(page.getMediaBox().getHeight() > page.getMediaBox().getWidth());
    }

    protected int xa(PDPage page, int x) {
        return x;
    }

    protected float xa(PDPage page, float x) {
        return this.xa(page, (int)x);
    }

    protected int xa(PDPage page, int x, boolean fix) {
        int xa = this.xa(page, x);
        if (!fix && !this.landscape(page)) {
            xa = (int)((float)xa * page.getMediaBox().getWidth() / page.getMediaBox().getHeight());
        }
        return xa;
    }

    protected float xa(PDPage page, float x, boolean fix) {
        return this.xa(page, (int)x, fix);
    }

    protected int xc(PDPage page, int x) {
        return this.landscape(page) ? x : (int)((page.getMediaBox().getWidth() - page.getMediaBox().getHeight()) / 2.0f + (float)x);
    }

    protected float xc(PDPage page, float x) {
        return this.xc(page, (int)x);
    }

    protected int xe(PDPage page, int x) {
        return this.landscape(page) ? x : (int)(page.getMediaBox().getWidth() - page.getMediaBox().getHeight() + (float)x);
    }

    protected float xe(PDPage page, float x) {
        return this.xe(page, (int)x);
    }

    protected int xe(PDPage page, int x, boolean fix) {
        int xe = this.xe(page, x);
        if (!fix && !this.landscape(page)) {
            xe = (int)(page.getMediaBox().getWidth() - (page.getMediaBox().getWidth() - (float)xe) * page.getMediaBox().getWidth() / page.getMediaBox().getHeight());
        }
        return xe;
    }

    protected float xe(PDPage page, float x, boolean fix) {
        return this.xe(page, (int)x, fix);
    }

    protected int ya(PDPage page, int y) {
        return this.landscape(page) ? y : (int)(page.getMediaBox().getHeight() - page.getMediaBox().getWidth() + (float)y);
    }

    protected float ya(PDPage page, float y) {
        return this.ya(page, (int)y);
    }

    protected int ya(PDPage page, int y, boolean fix) {
        int ya = this.ya(page, y);
        if (!fix && !this.landscape(page)) {
            ya = (int)(page.getMediaBox().getHeight() - (page.getMediaBox().getHeight() - (float)ya) * page.getMediaBox().getWidth() / page.getMediaBox().getHeight());
        }
        return ya;
    }

    protected float ya(PDPage page, float y, boolean fix) {
        return this.ya(page, (int)y, fix);
    }

    protected int yc(PDPage page, int y) {
        return this.landscape(page) ? y : (int)((page.getMediaBox().getHeight() - page.getMediaBox().getWidth()) / 2.0f + (float)y);
    }

    protected float yc(PDPage page, float y) {
        return this.yc(page, (int)y);
    }

    protected int ye(PDPage page, int y) {
        return y;
    }

    protected float ye(PDPage page, float y) {
        return this.ye(page, (int)y);
    }

    protected int ye(PDPage page, int y, boolean fix) {
        int ye = this.ye(page, y);
        if (!fix && !this.landscape(page)) {
            ye = (int)((float)ye * page.getMediaBox().getWidth() / page.getMediaBox().getHeight());
        }
        return ye;
    }

    protected float ye(PDPage page, float y, boolean fix) {
        return this.ye(page, (int)y, fix);
    }
}

