/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementPDFLiabilityAccountData {
    public static Double getTotalTaxValue(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/@totalTaxValue");
    }

    public static Double getTotalTaxValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@totalTaxValue");
    }

    public static Double getTotalGrossRevenueB(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/@totalGrossRevenueB");
    }

    public static Double getTotalGrossRevenueB(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@totalGrossRevenueB");
    }

    public static int getLiabilityAccountCount(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfLiabilities/liabilityAccount)");
    }

    public static Date getLiabilityAccountClosingDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@closingDate");
    }

    public static String getLiabilityAccountClosingDate(Document doc, int account, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date closingDate = TaxStatementPDFLiabilityAccountData.getLiabilityAccountClosingDate(doc, account);
        return closingDate != null ? sdf.format(closingDate) : null;
    }

    public static String getLiabilityAccountCountry(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountCountry");
    }

    public static String getLiabilityAccountCurrency(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountCurrency");
    }

    public static String getLiabilityAccountIBAN(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@iban");
    }

    public static String getLiabilityAccountName(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountName");
    }

    public static String getLiabilityAccountNumber(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountNumber");
    }

    public static Date getLiabilityAccountOpeningDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@openingDate");
    }

    public static String getLiabilityAccountOpeningDate(Document doc, int account, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date openingDate = TaxStatementPDFLiabilityAccountData.getLiabilityAccountOpeningDate(doc, account);
        return openingDate != null ? sdf.format(openingDate) : null;
    }

    public static int getTaxValueCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementPDFLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementPDFLiabilityAccountData.getTaxValueCount(doc, i);
        }
        return count;
    }

    public static int getTaxValueCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue)");
    }

    public static Double getTaxValueBalance(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFLiabilityAccountData.getTaxValueBalance(doc, account, 1);
    }

    public static Double getTaxValueBalance(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@balance");
    }

    public static String getTaxValueBalanceCurrency(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFLiabilityAccountData.getTaxValueBalanceCurrency(doc, account, 1);
    }

    public static String getTaxValueBalanceCurrency(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@balanceCurrency");
    }

    public static Double getTaxValueExchangeRate(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFLiabilityAccountData.getTaxValueExchangeRate(doc, account, 1);
    }

    public static Double getTaxValueExchangeRate(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@exchangeRate");
    }

    public static String getTaxValueName(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFLiabilityAccountData.getTaxValueName(doc, account, 1);
    }

    public static String getTaxValueName(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@name");
    }

    public static Date getTaxValueReferenceDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementPDFLiabilityAccountData.getTaxValueReferenceDate(doc, account, 1);
    }

    public static String getTaxValueReferenceDate(Document doc, int account, String format) throws ParseException, XPathExpressionException {
        return TaxStatementPDFLiabilityAccountData.getTaxValueReferenceDate(doc, account, 1, format);
    }

    public static Date getTaxValueReferenceDate(Document doc, int account, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@referenceDate");
    }

    public static String getTaxValueReferenceDate(Document doc, int account, int taxValue, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date referenceDate = TaxStatementPDFLiabilityAccountData.getTaxValueReferenceDate(doc, account, taxValue);
        return referenceDate != null ? sdf.format(referenceDate) : null;
    }

    public static Double getTaxValueValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFLiabilityAccountData.getTaxValueValue(doc, account, 1);
    }

    public static Double getTaxValueValue(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@value");
    }

    public static int getPaymentCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementPDFLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementPDFLiabilityAccountData.getPaymentCount(doc, i);
        }
        return count;
    }

    public static int getPaymentCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment)");
    }

    public static Double getPaymentAmount(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@amount");
    }

    public static String getPaymentAmountCurrency(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@amountCurrency");
    }

    public static Double getPaymentExchangeRate(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@exchangeRate");
    }

    public static Double getPaymentGrossRevenueB(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@grossRevenueB");
    }

    public static String getPaymentName(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@name");
    }

    public static Date getPaymentPaymentDate(Document doc, int account, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@paymentDate");
    }
}

