/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementPDFInstitutionData {
    public static int getInstitutionCount(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/institution)");
    }

    public static String getInstitutionLEI(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/institution/@lei");
    }

    public static String getInstitutionName(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/institution/@name");
    }

    public static String getInstitutionUID(Document doc) throws XPathExpressionException {
        String category = TaxStatementPDFInstitutionData.getInstitutionUIDOrganisationIdCategory(doc);
        String id = TaxStatementPDFInstitutionData.getInstitutionUIDOrganisationId(doc);
        if (category != null && category.length() > 0 && id != null && id.length() > 0) {
            return category + id;
        }
        if (category != null && category.length() > 0) {
            return category;
        }
        if (id != null && id.length() > 0) {
            return id;
        }
        return null;
    }

    public static String getInstitutionUIDOrganisationIdCategory(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/institution/uid/uidOrganisationIdCategorie");
    }

    public static String getInstitutionUIDOrganisationId(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/institution/uid/uidOrganisationId");
    }

    public static String getInstitutionUIDOrganisationId(Document doc, String format) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/institution/uid/uidOrganisationId", format);
    }
}

