/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementPDFExpenseData {
    public static Double getTotalExpenses(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpenses");
    }

    public static Double getTotalExpensesDeductible(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpensesDeductible");
    }

    public static Double getTotalExpensesDeductibleCanton(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpensesDeductibleCanton");
    }

    public static int getExpenseCount(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfExpenses/expense)");
    }

    public static String getExpenseAccountNumber(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@bankAccountNumber");
    }

    public static Double getExpenseAmount(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@amount");
    }

    public static String getExpenseAmountCurrency(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@amountCurrency");
    }

    public static String getExpenseDepotNumber(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@depotNumber");
    }

    public static Double getExpenseExchangeRate(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@exchangeRate");
    }

    public static Double getExpenseExpenses(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expenses");
    }

    public static Double getExpenseExpensesDeductible(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductible");
    }

    public static Double getExpenseExpensesDeductibleCanton(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductibleCanton");
    }

    public static String getExpenseIBAN(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@iban");
    }

    public static String getExpenseName(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@name");
    }

    public static Date getExpenseReferenceDate(Document doc, int expense) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@referenceDate");
    }

    public static String getExpenseReferenceDate(Document doc, int expense, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date referenceDate = TaxStatementPDFExpenseData.getExpenseReferenceDate(doc, expense);
        return referenceDate != null ? sdf.format(referenceDate) : null;
    }

    public static Integer getExpenseType(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueInteger(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expenseType");
    }

    public static String getExpenseType(Document doc, int expense, String format) throws XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Integer expenseType = TaxStatementPDFExpenseData.getExpenseType(doc, expense);
        return expenseType != null ? df.format(expenseType) : null;
    }
}

