/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementPDFBankAccountData {
    public static Double getTotalTaxValue(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalTaxValue");
    }

    public static Double getTotalTaxValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalTaxValue");
    }

    public static Double getTotalGrossRevenueA(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalGrossRevenueA");
    }

    public static Double getTotalGrossRevenueA(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueA");
    }

    public static Double getTotalGrossRevenueB(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalGrossRevenueB");
    }

    public static Double getTotalGrossRevenueB(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueB");
    }

    public static Double getTotalWithHoldingTaxClaim(Document doc) throws XPathExpressionException {
        Double totalGrossRevenueA = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalGrossRevenueA");
        Double totalWithHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalWithHoldingTaxClaim");
        return totalWithHoldingTaxClaim != null ? totalWithHoldingTaxClaim : (totalGrossRevenueA != null ? Double.valueOf(totalGrossRevenueA * 0.35) : null);
    }

    public static Double getTotalWithHoldingTaxClaim(Document doc, int account) throws XPathExpressionException {
        Double totalGrossRevenueA = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueA");
        Double totalWithHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalWithHoldingTaxClaim");
        return totalWithHoldingTaxClaim != null ? totalWithHoldingTaxClaim : (totalGrossRevenueA != null ? Double.valueOf(totalGrossRevenueA * 0.35) : null);
    }

    public static int getBankAccountCount(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
    }

    public static Date getBankAccountClosingDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@closingDate");
    }

    public static String getBankAccountClosingDate(Document doc, int account, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date closingDate = TaxStatementPDFBankAccountData.getBankAccountClosingDate(doc, account);
        return closingDate != null ? sdf.format(closingDate) : null;
    }

    public static String getBankAccountCountry(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCountry");
    }

    public static String getBankAccountCurrency(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCurrency");
    }

    public static String getBankAccountIBAN(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@iban");
    }

    public static String getBankAccountName(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountName");
    }

    public static String getBankAccountNumber(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountNumber");
    }

    public static Date getBankAccountOpeningDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@openingDate");
    }

    public static String getBankAccountOpeningDate(Document doc, int account, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date openingDate = TaxStatementPDFBankAccountData.getBankAccountOpeningDate(doc, account);
        return openingDate != null ? sdf.format(openingDate) : null;
    }

    public static int getTaxValueCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementPDFBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementPDFBankAccountData.getTaxValueCount(doc, i);
        }
        return count;
    }

    public static int getTaxValueCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue)");
    }

    public static Double getTaxValueBalance(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFBankAccountData.getTaxValueBalance(doc, account, 1);
    }

    public static Double getTaxValueBalance(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@balance");
    }

    public static String getTaxValueBalanceCurrency(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFBankAccountData.getTaxValueBalanceCurrency(doc, account, 1);
    }

    public static String getTaxValueBalanceCurrency(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@balanceCurrency");
    }

    public static Double getTaxValueExchangeRate(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFBankAccountData.getTaxValueExchangeRate(doc, account, 1);
    }

    public static Double getTaxValueExchangeRate(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@exchangeRate");
    }

    public static String getTaxValueName(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFBankAccountData.getTaxValueName(doc, account, 1);
    }

    public static String getTaxValueName(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@name");
    }

    public static Date getTaxValueReferenceDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementPDFBankAccountData.getTaxValueReferenceDate(doc, account, 1);
    }

    public static String getTaxValueReferenceDate(Document doc, int account, String format) throws ParseException, XPathExpressionException {
        return TaxStatementPDFBankAccountData.getTaxValueReferenceDate(doc, account, 1, format);
    }

    public static Date getTaxValueReferenceDate(Document doc, int account, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@referenceDate");
    }

    public static String getTaxValueReferenceDate(Document doc, int account, int taxValue, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date referenceDate = TaxStatementPDFBankAccountData.getTaxValueReferenceDate(doc, account, taxValue);
        return referenceDate != null ? sdf.format(referenceDate) : null;
    }

    public static Double getTaxValueValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFBankAccountData.getTaxValueValue(doc, account, 1);
    }

    public static Double getTaxValueValue(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@value");
    }

    public static int getPaymentCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementPDFBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementPDFBankAccountData.getPaymentCount(doc, i);
        }
        return count;
    }

    public static int getPaymentCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment)");
    }

    public static Double getPaymentAmount(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@amount");
    }

    public static String getPaymentAmountCurrency(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@amountCurrency");
    }

    public static Double getPaymentExchangeRate(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@exchangeRate");
    }

    public static Double getPaymentGrossRevenueA(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueA");
    }

    public static Double getPaymentGrossRevenueB(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueB");
    }

    public static String getPaymentName(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@name");
    }

    public static Date getPaymentPaymentDate(Document doc, int account, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@paymentDate");
    }

    public static String getPaymentPaymentDate(Document doc, int account, int payment, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date paymentDate = TaxStatementPDFBankAccountData.getPaymentPaymentDate(doc, account, payment);
        return paymentDate != null ? sdf.format(paymentDate) : null;
    }

    public static Double getPaymentWithHoldingTaxClaim(Document doc, int account, int payment) throws XPathExpressionException {
        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueA");
        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@withHoldingTaxClaim");
        return withHoldingTaxClaim != null ? withHoldingTaxClaim : (grossRevenueA != null ? Double.valueOf(grossRevenueA * 0.35) : null);
    }
}

