/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.examples;

import ch.ewv.taxstatement.examples.TaxStatementPDFToXML;
import ch.ewv.taxstatement.examples.TaxStatementXMLSignature;
import ch.ewv.taxstatement.pdf.TaxStatementPDF;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSK;
import ch.ewv.taxstatement.report.TaxStatementReport;
import ch.ewv.taxstatement.report.ssk.TaxStatementReportSSK;
import java.io.FileInputStream;
import java.util.Properties;

public class TaxStatementMain {
    protected static void properties() {
        String name = System.getProperty("properties");
        if (name != null && name.length() > 0) {
            Properties properties = new Properties();
            if (properties.isEmpty()) {
                try {
                    properties.load(TaxStatementMain.class.getResourceAsStream("/resources/" + name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (properties.isEmpty()) {
                try {
                    properties.load(new FileInputStream(name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!properties.isEmpty()) {
                for (String key : properties.stringPropertyNames()) {
                    if (System.getProperty(key) != null) continue;
                    System.setProperty(key, properties.getProperty(key));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int pdf(String[] args) {
        String name = System.getProperty("pdf", "false");
        int status = 0;
        if (name != null && !name.equals("false")) {
            try {
                if (name.equals("true")) {
                    TaxStatementSSK obj = new TaxStatementSSK();
                    status = obj.translate(args);
                } else {
                    Object obj;
                    if (!name.contains(".")) {
                        name = "ch.ewv.taxstatement.pdf." + name + ".TaxStatement" + name.toUpperCase();
                    }
                    if ((obj = Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0])) instanceof TaxStatementPDF) {
                        status = ((TaxStatementPDF)obj).translate(args);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                status = 1;
            }
            finally {
                System.out.println();
            }
        }
        return status;
    }

    protected static void xlsx(String[] args) {
        String name = System.getProperty("xlsx", "false");
        if (name != null && !name.equals("false")) {
            try {
                if (name.equals("true")) {
                    TaxStatementReportSSK obj = new TaxStatementReportSSK();
                    obj.translate(args);
                } else {
                    Object obj;
                    if (!name.contains(".")) {
                        name = "ch.ewv.taxstatement.report." + name + ".TaxStatementReport" + name.toUpperCase();
                    }
                    if ((obj = Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0])) instanceof TaxStatementReport) {
                        ((TaxStatementReport)obj).translate(args);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                System.out.println();
            }
        }
    }

    public static void main(String[] args) {
        TaxStatementMain.properties();
        System.out.println("Process file: " + args[0]);
        if (args[0].replace(".PDF", ".pdf").indexOf(".pdf") > 0) {
            TaxStatementPDFToXML.main(args);
            if (!System.getProperty("xlsx", "false").equals("false")) {
                TaxStatementMain.xlsx(args);
            }
        } else if (args[0].replace(".XML", ".xml").indexOf(".xml") > 0) {
            if (System.getProperty("sign", "false").equals("true")) {
                TaxStatementXMLSignature.main(args);
            } else if (!System.getProperty("xlsx", "false").equals("false")) {
                TaxStatementMain.xlsx(args);
            } else if (!System.getProperty("pdf", "false").equals("false")) {
                System.setProperty("EXIT", Integer.toString(TaxStatementMain.pdf(args)));
            }
        }
        if (System.getProperty("EXIT") != null) {
            System.exit(Integer.parseInt(System.getProperty("EXIT")));
        }
    }
}

