/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDDocumentCache {
    private static final Map<String, PDDocument> doc = new ConcurrentHashMap<String, PDDocument>();

    protected static synchronized PDDocument load(String name) throws IOException {
        PDDocument pdd = null;
        if (name != null && name.length() > 0) {
            try {
                pdd = PDDocument.load((File)new File(name));
            }
            catch (Exception e) {
                pdd = PDDocument.load((InputStream)PDDocumentCache.class.getResourceAsStream("/resources/" + name));
            }
        }
        return pdd;
    }

    public static PDDocument get(String name) throws IOException {
        PDDocument pdd = null;
        if (name != null && name.length() > 0 && (pdd = doc.get(name)) == null && (pdd = PDDocumentCache.load(name)) != null) {
            doc.put(name, pdd);
        }
        return pdd;
    }

    public static void remove(String name) {
        if (doc.containsKey(name)) {
            doc.remove(name);
        }
    }

    public static void clear() {
        doc.clear();
    }
}

