/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.oned.MultiFormatOneDReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TaxStatementZXing {
    public static String extractId(BufferedImage image) {
        String id = null;
        if (image != null) {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            HashMap<DecodeHintType, Serializable> hints = new HashMap<DecodeHintType, Serializable>();
            hints.put(DecodeHintType.TRY_HARDER, Boolean.valueOf(true));
            ArrayList<BarcodeFormat> formats = new ArrayList<BarcodeFormat>();
            formats.add(BarcodeFormat.CODE_39);
            formats.add(BarcodeFormat.CODE_128);
            hints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
            MultiFormatOneDReader reader = new MultiFormatOneDReader(hints);
            Result result = null;
            try {
                result = reader.decode(bitmap, hints);
            }
            catch (NotFoundException notFoundException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (result != null) {
                String bcValue = result.getText();
                if (System.getProperty("debug", "false").equals("true")) {
                    System.out.println("bcValue: " + bcValue);
                }
                if (bcValue != null && bcValue.startsWith("~d202")) {
                    bcValue = bcValue.substring(5);
                }
                if (bcValue != null && (bcValue.startsWith("196") || bcValue.startsWith("197")) && (bcValue.length() == 13 || bcValue.length() == 16)) {
                    id = bcValue;
                }
            }
        }
        return id;
    }

    public static byte[][] read(BufferedImage image) {
        Object bytes = null;
        if (image != null) {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            PDF417Reader reader = new PDF417Reader();
            HashMap<DecodeHintType, Boolean> hints = new HashMap<DecodeHintType, Boolean>();
            hints.put(DecodeHintType.TRY_HARDER, true);
            Result[] results = null;
            try {
                results = reader.decodeMultiple(bitmap, hints);
            }
            catch (NotFoundException notFoundException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (results != null) {
                for (Result result : results) {
                    PDF417ResultMetadata md = (PDF417ResultMetadata)result.getResultMetadata().get(ResultMetadataType.PDF417_EXTRA_METADATA);
                    int index = md.getSegmentIndex();
                    int count = md.getSegmentCount();
                    byte[] data = result.getText().getBytes(StandardCharsets.ISO_8859_1);
                    if (bytes == null && count > 0) {
                        bytes = new byte[count][];
                    }
                    if (data == null || index < 0 || index >= count) continue;
                    bytes[index] = data;
                }
            }
        }
        return bytes;
    }

    public static byte[][] read(List<BufferedImage> images) {
        Object bytes = null;
        if (images != null && images.size() > 0) {
            for (BufferedImage image : images) {
                byte[][] data;
                if (image == null || (data = TaxStatementZXing.read(image)) == null || data.length <= 0) continue;
                for (int i = 0; i < data.length; ++i) {
                    if (bytes == null) {
                        bytes = new byte[data.length][];
                    }
                    if (data[i] == null || data[i].length <= 0) continue;
                    bytes[i] = data[i];
                }
            }
        }
        return bytes;
    }
}

