/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.esteuerauszug;

import ch.dvbern.lib.esteuerauszug.ERFException;
import ch.ewv.taxstatement.TaxStatement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.text.ParseException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class ERFUtils {
    private ERFUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] extractEmbeddedXml(Path pdfPath) throws ERFException {
        try (PDDocument pdfDoc = PDDocument.load((File)pdfPath.toFile());){
            byte[] xml;
            byte[] byArray = xml = ERFUtils.getXml(pdfDoc);
            return byArray;
        }
        catch (IOException e) {
            throw new ERFException("Could not parse Xml from file: " + pdfPath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] extractEmbeddedXml(InputStream pdfStream) throws ERFException {
        try (PDDocument pdfDoc = PDDocument.load((InputStream)pdfStream);){
            byte[] byArray = ERFUtils.getXml(pdfDoc);
            return byArray;
        }
        catch (IOException e) {
            throw new ERFException("Could not parse Xml from pdf stream", e);
        }
    }

    private static byte[] getXml(PDDocument pdfDoc) throws ERFException {
        if (pdfDoc == null) {
            throw new IllegalArgumentException();
        }
        byte[] xml = TaxStatement.extractXML((PDDocument)pdfDoc);
        return xml;
    }

    public static String validateXMLMessage(Document document) throws ERFException {
        try {
            String errorMessage = TaxStatement.validateXMLMessage((Document)document);
            return errorMessage;
        }
        catch (UnsupportedEncodingException | XPathExpressionException e) {
            throw new ERFException(e);
        }
    }

    public static boolean validateXML(byte[] documentAsByte) throws ERFException {
        try {
            boolean isValid = TaxStatement.validateXML((byte[])documentAsByte);
            return isValid;
        }
        catch (IOException | ParseException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new ERFException(e);
        }
    }

    public static boolean verifySignature(byte[] documentAsByte) throws ERFException {
        try {
            boolean isSigned = TaxStatement.verifyXML((byte[])documentAsByte);
            return isSigned;
        }
        catch (IOException | MarshalException | XMLSignatureException | ParserConfigurationException | SAXException e) {
            throw new ERFException(e);
        }
    }
}

