/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.log4j;

import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListenerFactory;
import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.utils.DefaultGeneralizer;
import com.jamonapi.utils.Generalizer;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="JamonAppender", category="Core", elementType="appender", printObject=true)
public class JAMonAppender
extends AbstractAppender {
    private static final String PREFIX = "com.jamonapi.log4j.JAMonAppender.";
    private static final String TOTAL_KEY = "com.jamonapi.log4j.JAMonAppender.TOTAL";
    private int bufferSize = 100;
    private String units = "log4j";
    private boolean enableLevelMonitoring = true;
    private boolean generalize = false;
    private Generalizer generalizer = new DefaultGeneralizer();

    public JAMonAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, int bufferSize, boolean enableLevelMonitoring, boolean generalize, String levelListenerType) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.setListenerBufferSize(bufferSize);
        this.setEnableLevelMonitoring(enableLevelMonitoring);
        this.setGeneralize(generalize);
        this.setEnableListeners(levelListenerType);
    }

    @PluginFactory
    public static JAMonAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout layout, @PluginElement(value="Filters") Filter filter, @PluginAttribute(value="bufferSize", defaultInt=100) int bufferSize, @PluginAttribute(value="enableLevelMonitoring", defaultBoolean=true) boolean enableLevelMonitoring, @PluginAttribute(value="generalize", defaultBoolean=false) boolean generalize, @PluginAttribute(value="enableListeners", defaultString="NONE") String levelListenerType) {
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new JAMonAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, bufferSize, enableLevelMonitoring, generalize, levelListenerType);
    }

    public void append(LogEvent event) {
        if (MonitorFactory.isEnabled() && (this.getEnableLevelMonitoring() || this.getGeneralize())) {
            String message;
            String string = message = event.getMessage() == null ? "" : event.getMessage().getFormattedMessage();
            if (this.getEnableLevelMonitoring()) {
                String detailMessage = this.createDetailMessage(message, event);
                MonitorFactory.add(this.createKey(TOTAL_KEY, detailMessage), 1.0);
                MonitorFactory.add(this.createKey(this.getLevelKey(event), message), 1.0);
            }
            if (this.getGeneralize()) {
                MonKey key = this.createKey(this.standardizeAndGeneralizeSummaryLabel(message, event), message);
                MonitorFactory.add(key, 1.0);
            }
        }
    }

    private String createDetailMessage(String message, LogEvent event) {
        return event.getLevel().toString() + ": " + message;
    }

    private String standardizeAndGeneralizeSummaryLabel(String message, LogEvent event) {
        return PREFIX + "message." + event.getLevel().toString() + ": " + this.generalize(message);
    }

    private MonKey createKey(String summaryLabel, String detailLabel) {
        return new MonKeyImp(summaryLabel, detailLabel, this.units);
    }

    private String getLevelKey(LogEvent event) {
        return PREFIX + event.getLevel();
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setEnableLevelMonitoring(boolean enableLevelMonitoring) {
        this.enableLevelMonitoring = enableLevelMonitoring;
    }

    public boolean getEnableLevelMonitoring() {
        return this.enableLevelMonitoring;
    }

    public void setEnableListeners(String level) {
        if (Level.DEBUG.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.DEBUG, this.units));
        } else if (Level.TRACE.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.TRACE, this.units));
        } else if (Level.INFO.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.INFO, this.units));
        } else if (Level.WARN.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.WARN, this.units));
        } else if (Level.ERROR.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.ERROR, this.units));
        } else if (Level.FATAL.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.FATAL, this.units));
        } else if ("TOTAL".equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(TOTAL_KEY, this.units));
        } else if (Level.ALL.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.TRACE, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.DEBUG, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.INFO, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.WARN, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.ERROR, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.FATAL, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(TOTAL_KEY, this.units));
        } else if ("BASIC".equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor(TOTAL_KEY, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.ERROR, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor(PREFIX + Level.FATAL, this.units));
        }
    }

    private void addDefaultListener(Monitor mon) {
        if (!mon.hasListeners()) {
            JAMonBufferListener listener = (JAMonBufferListener)JAMonListenerFactory.get("FIFOBuffer");
            listener.getBufferList().setBufferSize(this.bufferSize);
            mon.addListener("value", listener);
        }
    }

    public void setListenerBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getListenerBufferSize() {
        return this.bufferSize;
    }

    public void setGeneralize(boolean generalize) {
        this.generalize = generalize;
        if (generalize && this.generalizer == null) {
            this.generalizer = new DefaultGeneralizer();
        }
    }

    public boolean getGeneralize() {
        return this.generalize;
    }

    protected String generalize(String detailedMessage) {
        return this.generalize && this.generalizer != null ? this.generalizer.generalize(detailedMessage) : detailedMessage;
    }

    public void setEnableDefaultGeneralizer(boolean enableDefaultGeneralizer) {
        if (enableDefaultGeneralizer) {
            this.setGeneralize(true);
        } else {
            this.generalizer = null;
            this.setGeneralize(false);
        }
    }

    public boolean hasGeneralizer() {
        return this.generalizer != null;
    }

    public void setGeneralizerClass(Generalizer generalizer) {
        this.generalizer = generalizer;
    }

    public void setGeneralizerDynamic(String generalizerClassStr) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.generalizer = (Generalizer)Class.forName(generalizerClassStr).newInstance();
    }
}

