/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.jamonapi.JamonPropertiesLoader;
import com.jamonapi.MonitorFactory;
import com.jamonapi.distributed.JamonDataPersister;
import com.jamonapi.distributed.JamonDataPersisterFactory;
import com.jamonapi.distributed.JamonDataPersisterTimerTask;
import com.jamonapi.jmx.JmxUtils;
import com.jamonapi.utils.LocaleContext;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class JamonServletContextListener
implements ServletContextListener {
    private static final int MINUTES = 60000;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        if (context != null) {
            this.addListeners();
            this.addJmxBeans();
            JamonDataPersisterTimerTask saveTask = this.getDistributedJamonTimerTask();
            int refreshRate = this.getRefreshRate();
            saveTask.schedule(refreshRate);
        }
    }

    private void addListeners() {
        JamonPropertiesLoader loader = new JamonPropertiesLoader();
        MonitorFactory.addListeners(loader.getListeners());
    }

    private void addJmxBeans() {
        JmxUtils.registerMbeans();
    }

    JamonDataPersisterTimerTask getDistributedJamonTimerTask() {
        return new JamonDataPersisterTimerTask(this.getJamonData());
    }

    JamonDataPersister getJamonData() {
        return JamonDataPersisterFactory.get();
    }

    int getRefreshRate() {
        Properties properties = new JamonPropertiesLoader().getJamonProperties();
        return 60000 * Integer.valueOf(properties.getProperty("distributedDataRefreshRateInMinutes"));
    }

    public void contextDestroyed(ServletContextEvent event) {
        LocaleContext.reset();
        JmxUtils.unregisterMbeans();
    }
}

