/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.jamonapi.CompositeListener;
import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonDetailValue;
import com.jamonapi.JAMonListener;
import com.jamonapi.JAMonListenerFactory;
import com.jamonapi.JamonPropertiesLoader;
import com.jamonapi.ListenerType;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorCompositeIterator;
import com.jamonapi.utils.FIFOBufferHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DistributedUtils {
    private static final String FIFO_BUFFER = "FIFOBuffer";
    static final String BUFFER_SUFFIX = "combined";
    static final int COMBINED_FIFO_BUFFER_SIZE = Integer.valueOf(JamonPropertiesLoader.PROPS.getProperty("monitorCompositeCombiner.combinedFifoBufferSize", "250"));
    private static final int INSTANCE_NAME_INDEX = 0;

    public static List<ListenerInfo> getAllListeners(Monitor monitor) {
        ArrayList<ListenerInfo> list = new ArrayList<ListenerInfo>();
        DistributedUtils.addAllListeners(list, monitor, "value");
        DistributedUtils.addAllListeners(list, monitor, "min");
        DistributedUtils.addAllListeners(list, monitor, "max");
        DistributedUtils.addAllListeners(list, monitor, "maxactive");
        return list;
    }

    public static void copyJamonBufferListenerData(Monitor from, Monitor to, int numInstances) {
        List<ListenerInfo> listeners = DistributedUtils.getAllListeners(from);
        for (ListenerInfo listenerInfo : listeners) {
            if (!(listenerInfo.getListener() instanceof JAMonBufferListener)) continue;
            String fifoName = DistributedUtils.getBufferName(listenerInfo.getListener().getName());
            JAMonBufferListener fromJamonBufferListener = (JAMonBufferListener)listenerInfo.getListener();
            JAMonBufferListener toJamonBufferListener = null;
            if (to.hasListener(listenerInfo.getListenerType(), fifoName)) {
                toJamonBufferListener = (JAMonBufferListener)to.getListenerType(listenerInfo.getListenerType()).getListener(fifoName);
            } else {
                toJamonBufferListener = DistributedUtils.createBufferListener(fifoName, fromJamonBufferListener);
                toJamonBufferListener.getBufferList().reset();
                to.addListener(listenerInfo.getListenerType(), toJamonBufferListener);
            }
            DistributedUtils.copyBufferListenerData(fromJamonBufferListener, toJamonBufferListener, numInstances);
        }
    }

    public static void copyJamonBufferListenerData(Monitor from, Monitor to) {
        DistributedUtils.copyJamonBufferListenerData(from, to, 1);
    }

    public static MonitorComposite changeInstanceName(String instanceName, MonitorComposite monitorComposite) {
        List<Monitor> list = new MonitorCompositeIterator(Arrays.asList(monitorComposite)).toList();
        list.stream().forEach(mon -> {
            mon.getMonKey().setInstanceName(instanceName);
            DistributedUtils.changeJamonBufferListenerDataInstanceName(instanceName, mon);
        });
        return new MonitorComposite(list.toArray(new Monitor[0])).setInstanceName(instanceName);
    }

    private static void changeJamonBufferListenerDataInstanceName(String instanceName, Monitor mon) {
        List<ListenerInfo> listeners = DistributedUtils.getAllListeners(mon);
        for (ListenerInfo listenerInfo : listeners) {
            if (!(listenerInfo.getListener() instanceof JAMonBufferListener)) continue;
            JAMonBufferListener jamonBufferListener = (JAMonBufferListener)listenerInfo.getListener();
            jamonBufferListener.getBufferList().getCollection().stream().forEach(bufferRow -> {
                if (bufferRow instanceof JAMonDetailValue) {
                    JAMonDetailValue jaMonDetailValue = (JAMonDetailValue)bufferRow;
                    jaMonDetailValue.getMonKey().setInstanceName(instanceName);
                } else if (bufferRow instanceof Object[]) {
                    Object[] row = (Object[])bufferRow;
                    row[0] = instanceName;
                }
            });
        }
    }

    private static void copyBufferListenerData(JAMonBufferListener from, JAMonBufferListener to, int numInstances) {
        if (from.hasData()) {
            int startIndex;
            Object[][] data = from.getBufferList().getDetailData().getData();
            int firstFifoIndexToBeAdded = DistributedUtils.getFifoFirstIndexToBeAdded(COMBINED_FIFO_BUFFER_SIZE, data.length, numInstances);
            for (int i = startIndex = DistributedUtils.isFifoBufferListener(from) ? firstFifoIndexToBeAdded : 0; i < data.length; ++i) {
                to.addRow(data[i]);
            }
        }
    }

    private static boolean isFifoBufferListener(JAMonBufferListener listener) {
        return listener.getBufferList().getBufferHolder() instanceof FIFOBufferHolder;
    }

    static int getFifoFirstIndexToBeAdded(int combinedFifoBufferSize, int sourceBufferSize, int numInstances) {
        int numFifoBufferRowsToAdd = combinedFifoBufferSize / numInstances;
        return numFifoBufferRowsToAdd >= sourceBufferSize ? 0 : sourceBufferSize - numFifoBufferRowsToAdd;
    }

    private static void addAllListeners(List<ListenerInfo> list, Monitor monitor, String listenerTypeName) {
        ListenerType listenerType = monitor.getListenerType(listenerTypeName);
        if (listenerType == null) {
            return;
        }
        JAMonListener listener = listenerType.getListener();
        if (listener == null) {
            return;
        }
        DistributedUtils.addAllListeners(list, listenerTypeName, listener);
    }

    private static void addAllListeners(List<ListenerInfo> list, String listenerTypeName, JAMonListener listener) {
        if (listener instanceof CompositeListener) {
            CompositeListener compositeListener = (CompositeListener)listener;
            Iterator iterator = compositeListener.iterator();
            while (iterator.hasNext()) {
                DistributedUtils.addAllListeners(list, listenerTypeName, (JAMonListener)iterator.next());
            }
        } else if (listener != null) {
            list.add(new ListenerInfo(listenerTypeName, listener));
        }
    }

    private static JAMonBufferListener createBufferListener(String name, JAMonBufferListener from) {
        JAMonBufferListener fifo = DistributedUtils.createBufferListener(from);
        fifo.getBufferList().setBufferSize(COMBINED_FIFO_BUFFER_SIZE);
        fifo.setName(name);
        return fifo;
    }

    private static JAMonBufferListener createBufferListener(JAMonBufferListener from) {
        try {
            return (JAMonBufferListener)from.copy();
        }
        catch (RuntimeException e) {
            return (JAMonBufferListener)JAMonListenerFactory.get(FIFO_BUFFER);
        }
    }

    static String getBufferName(String name) {
        return name + "_" + BUFFER_SUFFIX;
    }

    public static class ListenerInfo {
        private String listenerType;
        private JAMonListener listener;

        public ListenerInfo(String listenerType, JAMonListener listener) {
            this.listenerType = listenerType;
            this.listener = listener;
        }

        public String getListenerType() {
            return this.listenerType;
        }

        public JAMonListener getListener() {
            return this.listener;
        }
    }
}

