/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Mon
extends HttpServlet {
    private static final long serialVersionUID = 278L;
    private static final String DEFAULT_UNITS = "ms.";
    private static final String ERROR = "Error";
    private static final String OK = "OK";
    private static String help = "This servlet allows one to take advantage of JAMon by calling a servlet. This allows \ncalls to be made from operating system scripts for example.  Typically you would make \ncalls by using curl or wget to make http calls to the JAMon Mon Servlet. start/stop work like \na stopwatch. You pass in a label that will appear in the jamon report. You pass the same label to \nboth start and stop the monitor. For more information look at osmon/jamon_readme.txt as well as the\nscripts in the same directory.  These scripts allow you to access JAMon from the OS and can also be alteredto meet your needs if that is your requirement.  (http://www.jamonapi.com)";
    private Map map = new ConcurrentHashMap();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        if (this.hasValue(request.getParameter("start"))) {
            this.start(request, response);
        } else if (this.hasValue(request.getParameter("stop"))) {
            this.stop(request, response);
        } else if (this.hasValue(request.getParameter("add"))) {
            this.add(request, response);
        } else if (this.hasValue(request.getParameter("skip"))) {
            this.skip(request, response);
        } else if (this.hasValue(request.getParameter("get"))) {
            this.getValue(request, response);
        } else {
            this.displayHelp(response);
        }
    }

    private MonKey getMonKey(String label, String detail, String units) {
        if (detail == null) {
            detail = label;
        }
        return new MonKeyImp(label, detail, units);
    }

    private void start(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String label = request.getParameter("start");
        String detail = request.getParameter("detail");
        MonKey key = this.getMonKey(label, detail, DEFAULT_UNITS);
        this.startMon(key);
        PrintWriter out = response.getWriter();
        out.println("OK: start successfully called on - " + label);
    }

    private void startMon(MonKey key) {
        this.map.put(key, MonitorFactory.start(key));
    }

    private void stop(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        String label = request.getParameter("stop");
        Monitor mon = this.removeMon(label, null, DEFAULT_UNITS);
        if (mon == null) {
            out.println("Error: stop requires that an existing label is passed in.  For example: curl http://localhost:8080/jamon/Mon?stop=mylabel");
        } else {
            mon.stop();
            out.println("OK: stop successfully called on - " + mon);
        }
    }

    private void skip(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        String label = request.getParameter("skip");
        Monitor mon = this.removeMon(label, null, DEFAULT_UNITS);
        if (mon == null) {
            out.println("Error: skip requires that an existing label is passed in.  For example: curl http://localhost:8080/jamon/Mon?skip=mylabel");
        } else {
            mon.skip();
            out.println("OK: skip successfully called on - " + mon);
        }
    }

    private Monitor removeMon(String label, String detail, String units) {
        MonKey key = this.getMonKey(label, detail, units);
        Monitor mon = (Monitor)this.map.get(key);
        if (mon != null) {
            this.map.remove(mon);
        }
        return mon;
    }

    private void add(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        String label = request.getParameter("add");
        String units = request.getParameter("units");
        String value = request.getParameter("value");
        String detail = request.getParameter("detail");
        Double val = this.toDouble(value);
        if (this.isEmpty(label) || this.isEmpty(units) || this.isEmpty(val)) {
            out.println("Error: add requires that a label, units and numeric value are passed in.  For example: curl http://localhost:8080/jamon/Mon?add=mylabel&units=bytes&value=1234");
            out.println("  Optionally a detail may be passed in: curl http://localhost:8080/jamon/Mon?add=os.mylabel&units=bytes&value=1234&detail=Backup%20script%20from%20host%20backupserver\n");
        } else {
            MonKey key = this.getMonKey(label, detail, units);
            Monitor mon = MonitorFactory.add(key, val);
            out.println("OK: add successfully called on - " + label + " - " + mon);
        }
    }

    private void getValue(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        String label = request.getParameter("get");
        String type = request.getParameter("type");
        String units = request.getParameter("units");
        if (this.isEmpty(units)) {
            units = DEFAULT_UNITS;
        }
        if (this.isEmpty(label) || this.isEmpty(type)) {
            out.println("Error: get requires that a label, and type be passed in.  units is optional and will default to a time monitor if not provided (ms.). ");
            out.println("  Type is the type of value you want from the given monitor.  Examples are: hits, avg, min, max, total, firstaccess, lastaccess, active. ");
            out.println("   For example: curl http://localhost:8080/jamon/Mon?get=mylabel&type=avg");
            out.println("   For example: curl http://localhost:8080/jamon/Mon?get=mylabel&type=max&units=bytes");
        } else {
            MonKey key = this.getMonKey(label, null, units);
            Monitor mon = MonitorFactory.getMonitor(key);
            if (mon == null) {
                out.println("Error: Key didn't exist (" + label + "," + units + ")");
            } else {
                Object obj = null;
                obj = "mon".equalsIgnoreCase(type) ? mon.toString() : mon.getValue(type);
                if (obj == null) {
                    out.println("Error: type didn't exist (" + type + ")");
                } else {
                    out.println(obj);
                }
            }
        }
    }

    private Double toDouble(String numStr) {
        try {
            return new Double(numStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void displayHelp(HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.println(help);
    }

    private boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    private boolean hasValue(Object str) {
        return !this.isEmpty(str);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

