/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ParserAlreadyRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.lib.resource.construct.xml.VariableAlreadyDefinedException;
import ch.dvbern.lib.resource.construct.xml.VariableNotDefinedException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ScopeParserFactory
extends ParserFactory {
    @Nonnull
    private final ParserFactory factory;
    @Nonnull
    private final Map<String, ClassObjectPair> varScope;

    public ScopeParserFactory(@Nonnull ParserFactory factory) {
        this.factory = factory;
        this.varScope = new HashMap<String, ClassObjectPair>();
    }

    @Override
    @Nonnull
    public ElementParser getParser(@Nonnull String elementName) throws ParserNotRegisteredException {
        return this.factory.getParser(elementName);
    }

    @Override
    public void registerParser(@Nonnull String elementName, @Nonnull ElementParser parser) throws ParserAlreadyRegisteredException {
        this.factory.registerParser(elementName, parser);
    }

    @Nonnull
    public ClassObjectPair getVariableCOP(@Nonnull String varName) throws VariableNotDefinedException {
        ClassObjectPair value = this.varScope.get(varName);
        if (value == null && this.factory instanceof ScopeParserFactory) {
            value = ((ScopeParserFactory)this.factory).getVariableCOP(varName);
        }
        if (value == null) {
            throw new VariableNotDefinedException("variable with name=" + varName + " not defined");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariableCOP(@Nonnull String varName, @Nonnull ClassObjectPair cop) throws VariableAlreadyDefinedException {
        Map<String, ClassObjectPair> map = this.varScope;
        synchronized (map) {
            if (this.varScope.get(varName) != null) {
                throw new VariableAlreadyDefinedException("A variable with name=" + varName + " is already defined");
            }
            this.varScope.put(varName, cop);
        }
    }
}

