/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import javax.annotation.Nonnull;

public class NullParser
implements ElementParser {
    @Override
    @Nonnull
    public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!elementName.equals("null")) {
            throw new ElementParserException("null-parser can not handle elements with the name=" + elementName);
        }
        String className = element.getAttribute("class");
        if (className == null) {
            throw new ElementParserException("could not find attribute with name class");
        }
        try {
            Class clazz = ClassFactory.getKlass(className);
            return new ClassObjectPair(clazz, null);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("ArrayParser: ClassFactory could NOT create array-class for type=" + className, ex);
        }
    }
}

