/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;

public class GetFieldParser
implements ElementParser {
    @Override
    @Nonnull
    public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
        ClassObjectPair cop;
        Class myClass;
        Object myObject;
        String fieldName = element.getAttribute("name");
        List<Element> objectElChildren = element.getElementsByTagName("target");
        if (objectElChildren.size() != 1) {
            throw new ElementParserException("object must have exactly on child (construct or ref or cast...)");
        }
        Element objectElToParse = objectElChildren.get(0);
        try {
            ClassObjectPair tmp = factory.getParser(objectElToParse.getNodeName()).parse(objectElToParse, factory);
            myObject = tmp.getObject();
            myClass = tmp.getKlass();
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException(ex);
        }
        try {
            Field field = myClass.getField(fieldName);
            Object obj = field.get(myObject);
            cop = new ClassObjectPair(obj.getClass(), obj);
        }
        catch (NoSuchFieldException ex) {
            throw new ElementParserException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ElementParserException(ex);
        }
        return cop;
    }
}

