/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.ConstructionException;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;

public class Construct {
    @Nonnull
    private Class klass;
    @Nonnull
    private Class[] argClasses;
    @Nonnull
    private Object[] argValues;

    public Construct(@Nonnull Class<?> klass, @Nonnull Class<?>[] argClasses, @Nonnull Object[] argValues) {
        this.klass = klass;
        this.argClasses = (Class[])argClasses.clone();
        this.argValues = (Object[])argValues.clone();
    }

    @Nonnull
    public Class<?> getKlass() throws ConstructionException {
        return this.klass;
    }

    @Nonnull
    private Class<?>[] getArgClasses() throws ClassNotFoundException {
        return this.argClasses;
    }

    @Nonnull
    private Object[] getInitArgs() {
        return this.argValues;
    }

    public Object getObject() throws ConstructionException {
        try {
            Constructor<?> constructor = this.getKlass().getConstructor(this.getArgClasses());
            return constructor.newInstance(this.getInitArgs());
        }
        catch (ClassNotFoundException ex) {
            throw new ConstructionException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ConstructionException(ex);
        }
        catch (Exception ex) {
            throw new ConstructionException(ex);
        }
    }
}

