/*
 * Copyright © 2010 DV Bern AG, Switzerland
 *
 * Das vorliegende Dokument, einschliesslich aller seiner Teile, ist urheberrechtlich
 * geschuetzt. Jede Verwertung ist ohne Zustimmung der DV Bern AG unzulaessig. Dies gilt
 * insbesondere fuer Vervielfaeltigungen, die Einspeicherung und Verarbeitung in
 * elektronischer Form. Wird das Dokument einem Kunden im Rahmen der Projektarbeit zur
 * Ansicht uebergeben ist jede weitere Verteilung durch den Kunden an Dritte untersagt.
 *
 * $Id$
 */
package ch.dvbern.datatypes;

import java.text.NumberFormat;
import java.util.Locale;

/**
 * Stellt eine ZpvNummer dar.
 * 
 * @author beph
 */
public final class ZpvNummer extends AbstractPruefzifferNummer implements Comparable<ZpvNummer> {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7862409348622892480L;
	private static final long MIN_VALUE = 10000000L;
	private static final long MAX_VALUE = 999999999L;

	/**
	 * @param nummer
	 */
	public ZpvNummer(final long nummer) {

		super(nummer, MIN_VALUE, MAX_VALUE);
	}

	/**
	 * @param nummer
	 * @throws NumberFormatException
	 */
	public ZpvNummer(final String nummer) throws NumberFormatException {

		super(nummer, MIN_VALUE, MAX_VALUE);
	}

	/*
	 * (non-Javadoc)
	 * @see ch.dvbern.stvbe.neskovaqst.web.types.AbstractPruefzifferNummer#berechnePruefziffer(long)
	 */
	@Override
	protected int berechnePruefziffer(final long nummer) {

		long n = nummer / 10;
		int pruefziffer = 0;
		int z = 1;
		while (n > 0) {
			long ziffer = n % 10;
			long zifferTmp = ziffer * (z++ % 2 != 0 ? 2 : 1);
			if (zifferTmp >= 10) {
				zifferTmp = zifferTmp % 10 + (zifferTmp - zifferTmp % 10) / 10;
			}
			pruefziffer += zifferTmp;
			n /= 10;
		}
		// Sicherstellen, dass die Pruefziffer einstellig ist
		return (10 - pruefziffer % 10) % 10;
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(final ZpvNummer o) {

		if (this.getNummer() == o.getNummer()) {
			return 0;
		}
		return this.getNummer() - o.getNummer() > 0 ? -1 : 1;
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {

		return NumberFormat.getInstance(new Locale("DE", "ch")).format(getNummer());
	}

}
