/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.util.StyleRegistry;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.FormatHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DayMonthConverter
extends AbstractConverter<Date> {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private final @Nullable String yearAttr;
    private final @Nullable String yearAbsRef;
    private static final long serialVersionUID = 3257844376993477682L;
    private static final ThreadLocal<SimpleDateFormat> SDF_RENDER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM", Locale.GERMAN);
            sdf.setTimeZone(ApplicationConfig.TIMEZONE);
            return sdf;
        }
    };

    public DayMonthConverter(@Nullable String yearAttr, @Nullable String yearAbsRef) {
        super(Date.class);
        if (StringUtils.isNotBlank((CharSequence)yearAttr) && StringUtils.isNotBlank((CharSequence)yearAbsRef)) {
            throw new IllegalArgumentException("either yearAttr must be given or yearAbsRef, but not both! (" + yearAttr + "/" + yearAbsRef + ")");
        }
        this.yearAttr = yearAttr;
        this.yearAbsRef = yearAbsRef;
    }

    @Override
    public @Nullable Date getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        Long year;
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.yearAttr)) {
            year = Long.valueOf(this.yearAttr);
        } else if (StringUtils.isNotBlank((CharSequence)this.yearAbsRef)) {
            year = this.getYearFromAbsRef(this.yearAbsRef, ctx);
        } else {
            throw new IllegalArgumentException("One of attributes 'year' and 'year-abs-ref' must be set in day-month input type in " + ctx.getDmk());
        }
        return this.parse(s, year.intValue());
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return SDF_RENDER.get().format((Date)o);
        }
        return o.toString();
    }

    @Override
    public @NonNull String getUserInputRegExpPattern() {
        return "([0-9]{1,2})(\\.?)([0-9]{0,2})";
    }

    private @NonNull Long getYearFromAbsRef(@NonNull String lmkRef, @NonNull AbstractConverter.ConverterContext ctx) {
        ModelItemDTO item;
        String dmkRef = lmkRef;
        if (StringUtils.isNotBlank((CharSequence)ctx.getDmk())) {
            dmkRef = EngineUtil.mergeModelKey(lmkRef, ctx.getDmk());
        }
        if ((item = ctx.getModel().get(dmkRef)) == null || item.getValue() == null || !(item.getValue() instanceof Number)) {
            throw new IllegalArgumentException("No valid year could be found in the provided absolute reference in day-month field " + ctx.getDmk() + " for yearAbsRef: " + lmkRef + " => " + dmkRef);
        }
        return ((Number)item.getValue()).longValue();
    }

    private @NonNull Date parse(@NonNull String input, int year) throws AbstractConverter.ConvertException {
        StringBuilder sb = new StringBuilder(input);
        if (!input.endsWith(".")) {
            sb.append('.');
        }
        sb.append(year);
        String date = sb.toString();
        Calendar aCalendar = FormatHelper.getCalendar(date);
        if (aCalendar == null) {
            date = DOT_PATTERN.matcher(date).replaceAll("");
            aCalendar = FormatHelper.getCalendar(date);
        }
        if (aCalendar == null && (aCalendar = FormatHelper.getCalendar(input)) != null) {
            aCalendar.set(1, year);
        }
        if (aCalendar != null) {
            return aCalendar.getTime();
        }
        throw new AbstractConverter.ConvertException("error.format.daymonth");
    }

    @Override
    public @NonNull String getStyleClass() {
        return StyleRegistry.ITEM_TYPE_INPUT_DAYMONTH.getValue() + this.yearAttr;
    }

    @Override
    public int getMaxLength() {
        return 7;
    }
}

