/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.SelectConverter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComboboxConverter
extends SelectConverter {
    private static final long serialVersionUID = 3257848779318177842L;
    private final boolean useShortText;

    public ComboboxConverter(boolean useShortText) {
        this.useShortText = useShortText;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        try {
            String key = o != null ? o.toString() : null;
            OptionItemDTO option = optionItems.get(key, ctx.getLocalizationHelper().getCurrentLocale());
            return this.getRenderedValue(option, ctx);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRenderedValue(OptionItemDTO option, @NonNull AbstractConverter.ConverterContext ctx) {
        try {
            if (option != null) {
                String text;
                String string = text = this.useShortText ? option.getShortText().toString() : option.getText().toString();
                if (option.isResourceKey()) {
                    return ctx.getLocalizationHelper().translate(text, new Object[0]);
                }
                return text;
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }
}

