/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BooleanConverter
extends AbstractConverter<Boolean> {
    private static final long serialVersionUID = 3690473610909268018L;
    private final boolean printLabel;

    public BooleanConverter() {
        this(false);
    }

    public BooleanConverter(boolean printLabel) {
        super(Boolean.class);
        this.printLabel = printLabel;
    }

    @Override
    public @Nullable Boolean getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        Boolean result = Boolean.FALSE;
        if ("true".equalsIgnoreCase(s)) {
            result = Boolean.TRUE;
        }
        return result;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        return this.renderLabel(o, ctx, "label.ja", "label.nein");
    }

    private @NonNull String renderLabel(@Nullable Object o, @NonNull AbstractConverter.ConverterContext ctx, @NonNull String trueKey, @NonNull String falseKey) {
        if (o == null) {
            return "";
        }
        String result = o.toString();
        try {
            if (o instanceof Boolean) {
                String key = (Boolean)o != false ? trueKey : falseKey;
                result = ctx.getLocalizationHelper().translate(key, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String getRenderedValueToPrint(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        String result = " ";
        if (this.printLabel) {
            result = this.renderLabel(o, ctx, "label.print.ja", "label.print.nein");
        } else if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            result = "X";
        }
        return result;
    }
}

