/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.FileData;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.engine.wizarddisplay.items.FormHeaderTemplateAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.transfer.dto.DisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardDisplayInfoDTO
implements DisplayInfoDTO {
    private static final Logger LOG = LoggerFactory.getLogger(WizardDisplayInfoDTO.class);
    private static final long serialVersionUID = 3763094171963307828L;
    private final FormItemDTO formItemDTO;
    private final NavigationDTO navigationDTO;
    private final BreadcrumbsItemDTO breadcrumbsItemDTO;
    private Collection<MessageItemDTO> deleteWarnings = null;
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_RADIO = 1;
    public static final int TYPE_COMBO = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_TEXTAREA = 4;
    public static final int TYPE_SUGGESTIONBOX = 5;
    public static final int TYPE_FILEDETAILS = 6;
    public static final int TYPE_HIDDEN = 100;

    public WizardDisplayInfoDTO(FormItemDTO formItemDTO, NavigationDTO navigationDTO, BreadcrumbsItemDTO breadcrumbsItemDTO) {
        this.formItemDTO = formItemDTO;
        this.navigationDTO = navigationDTO;
        this.breadcrumbsItemDTO = breadcrumbsItemDTO;
    }

    public FormItemDTO getFormItemDTO() {
        return this.formItemDTO;
    }

    public List<NavigationsItemDTO> getNavigationsItemDTO() {
        return this.getNavigationDTO().getNavigationsItems();
    }

    public NavigationDTO getNavigationDTO() {
        return this.navigationDTO;
    }

    public BreadcrumbsItemDTO getBreadcrumbsDTO() {
        return this.breadcrumbsItemDTO;
    }

    public @Nullable String getThisKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getThisKey();
        }
        return null;
    }

    public @Nullable String getNextKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getNextKey();
        }
        return null;
    }

    public @Nullable String getPrevKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getPrevKey();
        }
        return null;
    }

    public @Nullable String getBackKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getBackKey();
        }
        return null;
    }

    public void setDeleteWarnings(Collection<MessageItemDTO> deleteWarnings) {
        this.deleteWarnings = deleteWarnings;
    }

    public Collection<MessageItemDTO> getDeleteWarnings() {
        return this.deleteWarnings;
    }

    public static void collectMessagesOnWizardDisplayForm(FormItemDTO formDTO) {
        WizardDisplayInfoDTO.collectMessagesOnWizardDisplayForm(formDTO, Collections.emptySet());
    }

    public static void collectMessagesOnWizardDisplayForm(FormItemDTO formDTO, Set<String> dmksToIgnore) {
        if (formDTO != null && formDTO.getChildren() != null) {
            for (AbstractItemDTO o : formDTO.getChildren()) {
                if (!(o instanceof SectionItemDTO)) continue;
                SectionItemDTO siDTO = (SectionItemDTO)o;
                ArrayList<MessageItemDTO> messages = new ArrayList<MessageItemDTO>();
                WizardDisplayInfoDTO.collectItemMessages(siDTO, messages, dmksToIgnore);
                Iterator j = messages.iterator();
                while (j.hasNext()) {
                    MessageItemDTO miDTO = (MessageItemDTO)j.next();
                    if (!"".equals(miDTO.getKey())) continue;
                    j.remove();
                }
                siDTO.setMessages(messages);
            }
        }
    }

    public static void collectItemMessages(Object o, List<MessageItemDTO> messages) {
        WizardDisplayInfoDTO.collectItemMessages(o, messages, Collections.emptySet());
    }

    public static void collectItemMessages(Object o, List<MessageItemDTO> messages, Set<String> dmksToIgnore) {
        if (o instanceof AbstractItemDTO && !((AbstractItemDTO)o).hasStateForVisibleMessages()) {
            return;
        }
        if (o instanceof SectionItemDTO && ((SectionItemDTO)o).getRows() != null) {
            for (RowItemDTO rowItemDTO : ((SectionItemDTO)o).getRows()) {
                WizardDisplayInfoDTO.collectItemMessages(rowItemDTO, messages);
            }
        } else if (o instanceof TableItemDTO && ((TableItemDTO)o).getRows() != null) {
            for (RowItemDTO rowItemDTO : ((TableItemDTO)o).getRows()) {
                WizardDisplayInfoDTO.collectItemMessages(rowItemDTO, messages);
            }
        } else if (o instanceof RowItemDTO && ((RowItemDTO)o).getCols() != null) {
            for (AbstractItemDTO abstractItemDTO : ((RowItemDTO)o).getCols()) {
                WizardDisplayInfoDTO.collectItemMessages(abstractItemDTO, messages);
            }
        } else if (o instanceof ItemItemDTO && ((ItemItemDTO)o).getMessages() != null && !dmksToIgnore.contains(((ItemItemDTO)o).getDataModelKey())) {
            messages.addAll(Objects.requireNonNull(((ItemItemDTO)o).getMessages()));
        }
    }

    public static class FileDetailsItemDTO
    extends AbstractItemDTO
    implements RowContent,
    ReRenderer,
    ItemWithStyle,
    DataModelItem {
        private static final long serialVersionUID = -6342852339493920233L;
        private final String fileName;
        private final DMK dmk;
        private final FileData value;
        private final @Nullable String titleKey;
        private final @Nullable String otherParams;
        private final int colspan;
        private final int width;
        private final String styleClass;
        private final List<LabelAddOnDTO> labelAddOns;
        private final Render reRender;
        private final String renderUniqueId;

        public FileDetailsItemDTO(@NonNull DisplayItemUniqueID uniqueItemIdentifier, @Nullable FileData value, int state, @Nullable String fileName, @NonNull DMK dmk, @Nullable String titleKey, @Nullable String otherParams, int colspan, int width, @Nullable String styleClass, @Nullable List<LabelAddOnDTO> labelAddOns, @Nullable Render reRender) {
            super(uniqueItemIdentifier, state);
            this.fileName = fileName;
            this.value = value;
            this.dmk = dmk;
            this.titleKey = titleKey;
            this.otherParams = otherParams;
            this.colspan = colspan;
            this.width = width;
            this.styleClass = styleClass;
            this.labelAddOns = labelAddOns;
            this.reRender = reRender;
            this.renderUniqueId = "fileDetails_" + dmk.toExternalForm() + "_" + uniqueItemIdentifier.getLocalId();
        }

        public @Nullable String getFileName() {
            return this.fileName;
        }

        public @NonNull DMK getDmk() {
            return this.dmk;
        }

        @Override
        public @NonNull String getDataModelKey() {
            return this.dmk.toExternalForm();
        }

        @Override
        public @Nullable FileData getValue() {
            return this.value;
        }

        public @Nullable String getTitleKey() {
            return this.titleKey;
        }

        public @Nullable String getOtherParams() {
            return this.otherParams;
        }

        @Override
        public int getColspan() {
            return this.colspan;
        }

        @Override
        public int getRowspan() {
            return 1;
        }

        @Override
        public @Nullable String getStyleClass() {
            return this.styleClass;
        }

        public @Nullable List<LabelAddOnDTO> getLabelAddOns() {
            return this.labelAddOns;
        }

        @Override
        public Render getReRender() {
            return this.reRender;
        }

        public String getRenderUniqueId() {
            return this.renderUniqueId;
        }

        public int getWidth() {
            return this.width;
        }

        public void setState(int state) {
            this.state = state;
        }
    }

    public static class BreadcrumbsItemDTO
    implements Serializable {
        private static final long serialVersionUID = -7481855354502076972L;
        private final String title;
        private final String navItemDmk;
        private final BreadcrumbsItemDTO child;

        public BreadcrumbsItemDTO(String title, String navItemDmk, BreadcrumbsItemDTO child) {
            if (title == null || navItemDmk == null) {
                throw new NullPointerException("invalid null argument");
            }
            this.title = title;
            this.navItemDmk = navItemDmk;
            this.child = child;
        }

        public String getTitle() {
            return this.title;
        }

        public String getNavItemDmk() {
            return this.navItemDmk;
        }

        public BreadcrumbsItemDTO getChild() {
            return this.child;
        }
    }

    public static class IncludeItemDTO
    extends AbstractItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String uri;

        public IncludeItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String uri) {
            super(uniqueItemIdentifier, state);
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }
    }

    public static class NavigationsItemDTO
    implements Serializable,
    StateFul {
        private static final long serialVersionUID = 3256442495255982129L;
        private String key;
        private final String title;
        private int state;
        private final boolean selected;
        private final List<NavigationsItemDTO> children;
        private @Nullable NavigationsItemDTO parent;

        public NavigationsItemDTO(String key, String title, int state, boolean selected, List<NavigationsItemDTO> children) {
            this.key = key;
            this.title = title;
            this.state = state;
            this.selected = selected;
            this.children = children;
            this.parent = null;
            if (children != null) {
                for (NavigationsItemDTO element : children) {
                    element.setParent(this);
                }
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof NavigationsItemDTO)) {
                return false;
            }
            NavigationsItemDTO navigationsItemDTO = (NavigationsItemDTO)object;
            if (!this.key.equals(navigationsItemDTO.getKey())) {
                return false;
            }
            if (!this.title.equals(navigationsItemDTO.getTitle())) {
                return false;
            }
            if (this.state != navigationsItemDTO.getState()) {
                return false;
            }
            if (this.selected != navigationsItemDTO.isSelected()) {
                return false;
            }
            if (this.children != null && navigationsItemDTO.getChildren() != null) {
                if (this.children.size() != navigationsItemDTO.getChildren().size()) {
                    return false;
                }
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    if (this.getChildren().get(i).equals(navigationsItemDTO.getChildren().get(i))) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.key).append((Object)this.title).append(this.state).append(this.selected).append(this.children).toHashCode();
        }

        public String toString() {
            return this.key;
        }

        public List<NavigationsItemDTO> getChildren() {
            return this.children;
        }

        public @Nullable NavigationsItemDTO getParent() {
            return this.parent;
        }

        public void setParent(NavigationsItemDTO parent) {
            this.parent = parent;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void printNavigation(String indent) {
            LOG.info(indent + this.key + " " + this.state + " " + this.selected);
            if (this.children == null) {
                return;
            }
            for (NavigationsItemDTO element : this.children) {
                element.printNavigation(indent + "  ");
            }
        }
    }

    public static class ButtonDTO
    extends AbstractItemDTO
    implements RowContent,
    ReRenderer,
    ItemWithStyle {
        private static final long serialVersionUID = 3257569494791434296L;
        private final int colspan;
        private final String uri;
        private final String name;
        private final String dmk;
        private final String icon;
        private final String target;
        private final String dmkValue;
        private final String viewId;
        private final String tooltip;
        private final Integer width;
        private final Integer height;
        private final boolean transparentIfView;
        private Render reRender;
        private final boolean ajax;
        private final String statusId;
        private final String styleClass;
        private final FontDTO fontDTO;
        private final String renderUniqueId;

        public ButtonDTO(DisplayItemUniqueID uniqueItemIdentifier, String uri, String name, String dmk, String dmkValue, String icon, String target, int colspan, boolean transparentIfView, Integer width, Integer height, Render reRender, boolean ajax, String viewId, String statusId, String styleClass, FontDTO fontDTO, String tooltip) {
            this(uniqueItemIdentifier, uri, name, dmk, dmkValue, icon, target, colspan, transparentIfView, width, height, reRender, ajax, viewId, statusId, styleClass, fontDTO, 1, tooltip);
        }

        public ButtonDTO(DisplayItemUniqueID uniqueItemIdentifier, String uri, String name, String dmk, String dmkValue, String icon, String target, int colspan, boolean transparentIfView, Integer width, Integer height, Render reRender, boolean ajax, String viewId, String statusId, String styleClass, FontDTO fontDTO, int state, String tooltip) {
            super(uniqueItemIdentifier, state);
            this.uri = uri;
            this.name = name;
            this.dmk = dmk;
            this.dmkValue = dmkValue;
            this.icon = icon;
            this.target = target;
            this.colspan = colspan;
            this.transparentIfView = transparentIfView;
            this.width = width;
            this.height = height;
            this.reRender = reRender;
            this.ajax = ajax;
            this.viewId = viewId;
            this.statusId = statusId;
            this.styleClass = styleClass;
            this.fontDTO = fontDTO;
            this.renderUniqueId = "button_" + dmk + "_" + uniqueItemIdentifier.getLocalId();
            this.tooltip = tooltip;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String getUri() {
            return this.uri;
        }

        public String getDmk() {
            return this.dmk;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getTarget() {
            return this.target;
        }

        @Override
        public int getColspan() {
            return this.colspan;
        }

        public String getStyle() {
            return "";
        }

        public boolean isTransparentIfView() {
            return this.transparentIfView;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public String getDmkValue() {
            return this.dmkValue;
        }

        @Override
        public int getRowspan() {
            return 1;
        }

        @Override
        public Render getReRender() {
            return this.reRender;
        }

        public void setReRender(Render reRender) {
            this.reRender = reRender;
        }

        public boolean isAjax() {
            return this.ajax;
        }

        public String getViewId() {
            return this.viewId;
        }

        public String getStatusId() {
            return this.statusId;
        }

        @Override
        public String getStyleClass() {
            return this.styleClass;
        }

        public @Nullable FontDTO getFontDTO() {
            return this.fontDTO;
        }

        public String getRenderUniqueId() {
            return this.renderUniqueId;
        }
    }

    public static class LinkItemDTO
    extends AbstractItemDTO
    implements RowContent,
    ItemWithStyle {
        private static final long serialVersionUID = 3257569494791434296L;
        private final int colspan;
        private final String uri;
        private final String name;
        private final String target;
        private final String styleClass;
        private final boolean transparentIfView;
        private final List<LabelAddOnDTO> labelAddOnDTOs;

        public LinkItemDTO(DisplayItemUniqueID uniqueItemIdentifier, String uri, String name, String target, int colspan, boolean transparentIfView, String styleClass, List<LabelAddOnDTO> labelAddOnDTOs) {
            super(uniqueItemIdentifier, 1);
            this.uri = uri;
            this.name = name;
            this.target = target;
            this.colspan = colspan;
            this.transparentIfView = transparentIfView;
            this.styleClass = styleClass;
            this.labelAddOnDTOs = labelAddOnDTOs;
        }

        public String getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isTransparentIfView() {
            return this.transparentIfView;
        }

        @Override
        public String getStyleClass() {
            return this.styleClass;
        }

        @Override
        public int getColspan() {
            return this.colspan;
        }

        @Override
        public int getRowspan() {
            return 1;
        }

        public List<LabelAddOnDTO> getLabelAddOnDTOs() {
            return this.labelAddOnDTOs;
        }

        public String getUriWithAddOns(@NonNull AbstractConverter.ConverterContext ctx) throws FormRendererException {
            try {
                List<LabelAddOnDTO> addons = this.getLabelAddOnDTOs();
                Object[] args = null;
                if (addons != null && !addons.isEmpty()) {
                    args = new Object[addons.size()];
                    for (int i = 0; i < args.length; ++i) {
                        LabelAddOnDTO element = addons.get(i);
                        AbstractConverter<?> conv = element.getRendererAndInputValidator();
                        StringBuilder s = new StringBuilder(Objects.requireNonNull(conv.getRenderedValue(element.getValue(), false, element.getOptionItems(), ctx)));
                        if (element.getLength() != null) {
                            if (s.length() > element.getLength()) {
                                s.setLength(element.getLength());
                            }
                            while (s.length() < element.getLength() && element.getFillpattern() != null) {
                                s.insert(0, element.getFillpattern());
                            }
                        }
                        args[i] = s.toString();
                    }
                }
                return ctx.getLocalizationHelper().translate(this.getUri(), args);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                throw new FormRendererException("translation failed", e);
            }
        }
    }

    public static class BRItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3256442516780692274L;

        public BRItemDTO(DisplayItemUniqueID uniqueItemIdentifier) {
            super(uniqueItemIdentifier, 1);
        }
    }

    public static class StateItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 4121699876493865012L;

        public StateItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state) {
            super(uniqueItemIdentifier, state);
        }
    }

    public static class ColItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3616447899530310195L;
        private final List<ItemItemDTO> itemDTOs;

        public ColItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, List<ItemItemDTO> itemDTOs) {
            super(uniqueItemIdentifier, state);
            this.itemDTOs = itemDTOs;
        }

        public List<ItemItemDTO> getItems() {
            return this.itemDTOs;
        }
    }

    public static class TableItemDTO
    extends AbstractItemDTO
    implements RowContent,
    ReRenderer,
    Alignable,
    ItemWithStyle {
        private static final long serialVersionUID = 3256721796996019254L;
        private final @NonNull String deleteMessage;
        private List<ColDefItemDTO> coldefs;
        private final List<RowItemDTO> rows;
        private final HelpItemDTO help;
        private final String dataModelKey;
        private final String header;
        private final List<LabelAddOnDTO> labelAddOns;
        private final boolean isSubnavigation;
        private final boolean editable;
        private final RowItemDTO emptyRow;
        private final boolean deleteRowEnabled;
        private final boolean addRowEnabled;
        private final String align;
        private final int colspan;
        private final int rowspan;
        private final String logicModelKey;
        private final boolean readOnly;
        private String viewId;
        private final int rowsPerPage;
        private final boolean filter;
        private final boolean statusFilter;
        private final boolean showPrintRow;
        private final String buttonPlusText;
        private final String noEntryText;
        private final Render reRender;
        private final String stateLMK;
        private final String styleClass;
        private final boolean onlyShowVisualizeButton;
        private final @NonNull String deleteStateMissingRowsMessage;

        public TableItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String dataModelKey, String header, @Nullable List<LabelAddOnDTO> labelAddOns, List<ColDefItemDTO> coldefs, List<RowItemDTO> rows, @Nullable HelpItemDTO help, boolean isSubnavigation, boolean editable, @Nullable RowItemDTO emptyRow, boolean deleteRowEnabled, boolean addRowEnabled, String align, int colspan, int rowspan, boolean readOnly, @Nullable String viewId, int rowsPerPage, boolean filter, boolean statusFilter, boolean showPrintRow, String buttonPlusText, String noEntryText, @Nullable Render reRender, @Nullable String stateLMK, @Nullable String styleClass, boolean onlyShowVisualizeButton, @NonNull String deleteMessage, @NonNull String deleteStateMissingRowsMessage) {
            super(uniqueItemIdentifier, state);
            this.coldefs = coldefs;
            this.rows = rows;
            this.dataModelKey = dataModelKey;
            this.header = header;
            this.labelAddOns = labelAddOns;
            this.help = help;
            this.isSubnavigation = isSubnavigation;
            this.editable = editable;
            this.emptyRow = emptyRow;
            this.deleteRowEnabled = deleteRowEnabled;
            this.addRowEnabled = addRowEnabled;
            this.align = align;
            this.rowspan = rowspan;
            this.colspan = colspan;
            this.noEntryText = noEntryText;
            this.logicModelKey = EngineUtil.removeTableIndices(dataModelKey);
            this.readOnly = readOnly;
            this.viewId = viewId;
            this.rowsPerPage = rowsPerPage;
            this.filter = filter;
            this.statusFilter = statusFilter;
            this.showPrintRow = showPrintRow;
            this.buttonPlusText = buttonPlusText;
            this.reRender = reRender;
            this.stateLMK = stateLMK;
            this.styleClass = styleClass;
            this.onlyShowVisualizeButton = onlyShowVisualizeButton;
            this.deleteMessage = deleteMessage;
            this.deleteStateMissingRowsMessage = deleteStateMissingRowsMessage;
        }

        public List<ColDefItemDTO> getColdefs() {
            return this.coldefs;
        }

        public void setColdefs(List<ColDefItemDTO> coldefs) {
            this.coldefs = coldefs;
        }

        public List<RowItemDTO> getRows() {
            return this.rows;
        }

        public String getHeader() {
            return this.header;
        }

        public String getDataModelKey() {
            return this.dataModelKey;
        }

        public String getLogicModelKey() {
            return this.logicModelKey;
        }

        public @Nullable String getStateLMK() {
            return this.stateLMK;
        }

        public HelpItemDTO getHelp() {
            return this.help;
        }

        public int getCntCols() {
            if (this.showPrintRow) {
                return this.getColdefs().size() + 3;
            }
            return this.getColdefs().size() + 2;
        }

        public boolean getIsSubnavigation() {
            return this.isSubnavigation;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public RowItemDTO getEmptyRow() {
            return this.emptyRow;
        }

        public boolean isDeleteRowEnabled() {
            return this.deleteRowEnabled;
        }

        public boolean isAddRowenabled() {
            return this.addRowEnabled;
        }

        @Override
        public String getAlign() {
            return this.align;
        }

        @Override
        public int getColspan() {
            return this.colspan;
        }

        @Override
        public int getRowspan() {
            return this.rowspan;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean getOnlyShowVisualizeButton() {
            return this.onlyShowVisualizeButton;
        }

        public String getViewId() {
            return this.viewId;
        }

        public void setViewId(String viewId) {
            this.viewId = viewId;
        }

        public List<LabelAddOnDTO> getLabelAddOns() {
            return this.labelAddOns;
        }

        public int getRowsPerPage() {
            return this.rowsPerPage;
        }

        public boolean removeRow(RowItemDTO rowItemDTO) {
            return this.rows.remove(rowItemDTO);
        }

        public boolean isFilter() {
            return this.filter;
        }

        public boolean isStatusFilter() {
            return this.statusFilter;
        }

        public boolean isShowPrintRow() {
            return this.showPrintRow;
        }

        public String getButtonPlusText() {
            return this.buttonPlusText;
        }

        public @NonNull String getDeleteStateMissingRowsMessage() {
            return this.deleteStateMissingRowsMessage;
        }

        public String getNoEntryText() {
            return this.noEntryText;
        }

        @Override
        public Render getReRender() {
            return this.reRender;
        }

        @Override
        public @Nullable String getStyleClass() {
            return this.styleClass;
        }

        public @NonNull String getDeleteMessage() {
            return this.deleteMessage;
        }
    }

    public static class HelpItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3906087858295879222L;
        private final String id;
        private final String helpMessageKey;
        private final HelpParent helpParent;

        public HelpItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String id, String helpMessageKey, @NonNull HelpParent helpParent) {
            super(uniqueItemIdentifier, state);
            this.id = id;
            this.helpMessageKey = helpMessageKey;
            this.helpParent = Objects.requireNonNull(helpParent);
        }

        public String getId() {
            return this.id;
        }

        public String getHelpMessageKey() {
            return this.helpMessageKey;
        }

        public @NonNull HelpParent getHelpParent() {
            return this.helpParent;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HelpItemDTO other = (HelpItemDTO)obj;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
        }

        public static enum HelpParent {
            FORM,
            SECTION,
            TABLE,
            LABEL,
            OTHER;

        }
    }

    public static class ItemItemDTO
    extends AbstractItemDTO
    implements RowContent,
    ReRenderer,
    ItemWithStyle,
    StringValue,
    Alignable,
    DataModelItem {
        private static final long serialVersionUID = 3906934486578312753L;
        private final int type;
        private final String dataModelKey;
        private Object value;
        private final int colspan;
        private final int rowspan;
        private final int width;
        private final OptionItemsDTO optionItems;
        private @Nullable Collection<MessageItemDTO> messages;
        private final boolean readonly;
        private final String align;
        private final String style;
        private final String styleClass;
        private final Item.Layout layout;
        private final String id;
        private final boolean negative;
        private final AbstractConverter<?> rendererAndInputValidator;
        private final boolean validateIfEmpty;
        private final String shortHelpKey;
        private final String fgColor;
        private final Render reRender;
        private final String hiddenLabel;
        private final String placeholder;
        private final String renderUniqueId;
        private final @Nullable String titleKey;
        private final boolean emitFocusEvents;

        public ItemItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, int type, String dataModelKey, Object value, int colspan, int rowspan, int width, OptionItemsDTO optionItems, Collection<MessageItemDTO> messages, boolean readonly, String align, String style, String styleClass, Item.Layout layout, String id, boolean negative, AbstractConverter<?> rendererAndInputValidator, boolean validateIfLeftEmpty, String shortHelpKey, String fgColor, Render reRender, String hiddenLabel, String placeholder, @Nullable String titleKey, boolean emitFocusEvents) {
            super(uniqueItemIdentifier, state);
            this.type = type;
            this.dataModelKey = dataModelKey;
            this.value = value;
            this.colspan = colspan;
            this.rowspan = rowspan;
            this.width = width;
            this.optionItems = optionItems;
            this.messages = messages;
            this.readonly = readonly;
            this.align = align;
            this.style = style;
            this.styleClass = styleClass;
            this.layout = layout;
            this.id = id;
            this.negative = negative;
            this.rendererAndInputValidator = rendererAndInputValidator;
            this.validateIfEmpty = validateIfLeftEmpty;
            this.shortHelpKey = shortHelpKey;
            this.fgColor = fgColor;
            this.reRender = reRender;
            this.hiddenLabel = hiddenLabel;
            this.placeholder = placeholder;
            this.renderUniqueId = ItemItemDTO.createIdForInputField(this);
            this.titleKey = titleKey;
            this.emitFocusEvents = emitFocusEvents;
        }

        private static String createIdForInputField(ItemItemDTO item) {
            return "input_" + item.getDataModelKey() + "_" + item.getUniqueItemIdentifier().getLocalId();
        }

        public String getForegroundColor() {
            return this.fgColor;
        }

        public void setState(int state) {
            this.state = state;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public String getDataModelKey() {
            return this.dataModelKey;
        }

        @Override
        public Object getValue() {
            if (this.negative && this.value instanceof Double) {
                return 0.0 - ((Number)this.value).doubleValue();
            }
            if (this.negative && this.value instanceof Long) {
                return 0L - ((Number)this.value).longValue();
            }
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public int getColspan() {
            return this.colspan;
        }

        public int getWidth() {
            return this.width;
        }

        public int getMaxlength() {
            if (this.rendererAndInputValidator != null) {
                return this.rendererAndInputValidator.getMaxLength();
            }
            return 100;
        }

        public OptionItemsDTO getOptionItems() {
            return this.optionItems;
        }

        public @Nullable Collection<MessageItemDTO> getMessages() {
            return this.messages;
        }

        public boolean getReadonly() {
            return this.readonly;
        }

        @Override
        public String getAlign() {
            return this.align;
        }

        @Override
        public String getStyleClass() {
            return this.styleClass;
        }

        public String getStyle() {
            return this.style;
        }

        public Item.Layout getLayout() {
            return this.layout;
        }

        public String getId() {
            return this.id;
        }

        public void addMessage(MessageItemDTO message) {
            if (this.messages == null) {
                this.messages = new ArrayList<MessageItemDTO>();
            }
            this.messages.add(message);
        }

        public void removeMessage(MessageItemDTO message) {
            if (this.messages != null) {
                this.messages.remove(message);
                if (this.messages.isEmpty()) {
                    this.messages = null;
                }
            }
        }

        public AbstractConverter<?> getRendererAndInputValidator() {
            return this.rendererAndInputValidator;
        }

        public boolean isValidateIfLeftEmpty() {
            return this.validateIfEmpty;
        }

        @Override
        public int getRowspan() {
            return this.rowspan;
        }

        public String getShortHelpKey() {
            return this.shortHelpKey;
        }

        @Override
        public Render getReRender() {
            return this.reRender;
        }

        public boolean getEmitFocusEvets() {
            return this.emitFocusEvents;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("item: name=").append(this.getDataModelKey()).append("; value=").append(this.getValue()).append("; state=").append(this.getState());
            return sb.toString();
        }

        public String getHiddenLabel() {
            return this.hiddenLabel;
        }

        @Override
        public String getStringValue() {
            return this.getValue() == null ? "" : this.getValue().toString();
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public String getRenderUniqueId() {
            return this.renderUniqueId;
        }

        public @Nullable String getTitleKey() {
            return this.titleKey;
        }
    }

    public static class FormHeaderTemplateAddOnDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FormHeaderTemplateAddOn.ResolverMethod resolverMethod;
        private final Object value;
        private final AbstractConverter<?> rendererValidator;
        private final OptionItemsDTO optionItems;

        public FormHeaderTemplateAddOnDTO(FormHeaderTemplateAddOn.ResolverMethod resolverMethod, Object value, AbstractConverter<?> rendererValidator, OptionItemsDTO optionItems) {
            this.resolverMethod = resolverMethod;
            this.value = value;
            this.rendererValidator = rendererValidator;
            this.optionItems = optionItems;
        }

        public FormHeaderTemplateAddOn.ResolverMethod getResolverMethod() {
            return this.resolverMethod;
        }

        public Object getValue() {
            return this.value;
        }

        public AbstractConverter<?> getRendererAndInputValidator() {
            return this.rendererValidator;
        }

        public OptionItemsDTO getOptionItems() {
            return this.optionItems;
        }
    }

    public static class LabelAddOnDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object value;
        private final AbstractConverter<?> rendererAndInputValidator;
        private final OptionItemsDTO optionItems;
        private final Integer length;
        private final String fillpattern;

        public LabelAddOnDTO(Object value, AbstractConverter<?> rendererAndInputValidator, OptionItemsDTO optionItems, Integer length, String fillpattern) {
            this.value = value;
            this.rendererAndInputValidator = rendererAndInputValidator;
            this.optionItems = optionItems;
            this.length = length;
            this.fillpattern = fillpattern;
        }

        public Object getValue() {
            return this.value;
        }

        public AbstractConverter<?> getRendererAndInputValidator() {
            return this.rendererAndInputValidator;
        }

        public OptionItemsDTO getOptionItems() {
            return this.optionItems;
        }

        public Integer getLength() {
            return this.length;
        }

        public String getFillpattern() {
            return this.fillpattern;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class StateIndicatorItemDTO
    extends AbstractItemDTO
    implements RowContent,
    ItemWithStyle,
    Alignable {
        private static final long serialVersionUID = 3977012938160747316L;
        private final String key;
        private final int colspan;
        private final @Nullable String align;
        private final @Nullable String style;
        private final @Nullable String styleClass;
        private String toString = null;
        private final int width;
        private final String renderUniqueId;

        public StateIndicatorItemDTO(@NonNull DisplayItemUniqueID uniqueItemIdentifier, int state, @NonNull String name, @NonNull String key, int colspan, @Nullable String align, @Nullable String style, @Nullable String styleClass) {
            this(uniqueItemIdentifier, state, key, colspan, 0, align, style, styleClass);
        }

        public StateIndicatorItemDTO(@NonNull DisplayItemUniqueID uniqueItemIdentifier, int state, @NonNull String key, int colspan, int width, @Nullable String align, @Nullable String style, @Nullable String styleClass) {
            super(uniqueItemIdentifier, state);
            this.key = key;
            this.colspan = colspan;
            this.align = align;
            this.style = style;
            this.styleClass = styleClass;
            this.width = width;
            this.renderUniqueId = "stateIndicator_" + this.key + "_" + uniqueItemIdentifier.getLocalId();
        }

        @Override
        public int getColspan() {
            return this.colspan;
        }

        public int getWidth() {
            return this.width;
        }

        @Override
        public @Nullable String getAlign() {
            return this.align;
        }

        public @Nullable String getStyle() {
            return this.style;
        }

        @Override
        public @Nullable String getStyleClass() {
            return this.styleClass;
        }

        @Override
        public int getRowspan() {
            return 1;
        }

        public String getRenderUniqueId() {
            return this.renderUniqueId;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuilder sb = new StringBuilder();
                if (this.key != null) {
                    sb.append(this.key);
                }
                this.toString = sb.toString();
            }
            return this.toString;
        }
    }

    public static class LabelItemDTO
    extends AbstractItemDTO
    implements RowContent,
    ItemWithStyle,
    Alignable {
        private static final long serialVersionUID = 3977012938160747316L;
        private final Object name;
        private final int colspan;
        private final String align;
        private final String style;
        private final String styleClass;
        private final List<LabelAddOnDTO> labelAddOns;
        private final boolean autoFormatAddOns;
        private String toString = null;
        private final String fgColor;
        private final int width;
        private String labelFor;
        private final @Nullable HelpItemDTO help;

        public LabelItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String name, int colspan, String align, String style, String styleClass, List<LabelAddOnDTO> labelAddOns, boolean autoFormatAddOns, String fgColor, String labelFor, @Nullable HelpItemDTO help) {
            this(uniqueItemIdentifier, state, name, colspan, 0, align, style, styleClass, labelAddOns, autoFormatAddOns, fgColor, labelFor, help);
        }

        public LabelItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String name, int colspan, int width, String align, String style, String styleClass, List<LabelAddOnDTO> labelAddOns, boolean autoFormatAddOns, String fgColor, String labelFor, @Nullable HelpItemDTO help) {
            super(uniqueItemIdentifier, state);
            this.name = name;
            this.colspan = colspan;
            this.align = align;
            this.style = style;
            this.styleClass = styleClass;
            this.labelAddOns = labelAddOns;
            this.autoFormatAddOns = autoFormatAddOns;
            this.fgColor = fgColor;
            this.width = width;
            this.labelFor = labelFor;
            this.help = help;
        }

        public String getForegroundColor() {
            return this.fgColor;
        }

        public Object getName() {
            return this.name;
        }

        @Override
        public int getColspan() {
            return this.colspan;
        }

        public int getWidth() {
            return this.width;
        }

        @Override
        public String getAlign() {
            return this.align;
        }

        public String getStyle() {
            return this.style;
        }

        @Override
        public String getStyleClass() {
            return this.styleClass;
        }

        public List<LabelAddOnDTO> getLabelAddOns() {
            return this.labelAddOns;
        }

        public boolean isAutoFormatAddOns() {
            return this.autoFormatAddOns;
        }

        @Override
        public int getRowspan() {
            return 1;
        }

        public String getLabelFor() {
            return this.labelFor;
        }

        public void setLabelFor(String labelFor) {
            this.labelFor = labelFor;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuilder sb = new StringBuilder();
                if (this.name != null) {
                    sb.append(this.name.toString());
                }
                if (this.labelAddOns != null && !this.labelAddOns.isEmpty()) {
                    sb.append(" {");
                    for (LabelAddOnDTO labelAddOnDTO : this.labelAddOns) {
                        sb.append(labelAddOnDTO.toString());
                        sb.append(",");
                    }
                    sb.append("}");
                }
                this.toString = sb.toString();
            }
            return this.toString;
        }

        public @Nullable HelpItemDTO getHelp() {
            return this.help;
        }
    }

    public static class RowItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3256721779782202676L;
        private final HelpItemDTO help;
        private List<AbstractItemDTO> cols;
        private final String dmkTableEntry;
        private final boolean deletable;
        private final String viewId;
        private final List<String> stateLMKs;

        public RowItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String dmkTableEntry, List<AbstractItemDTO> cols, HelpItemDTO help, boolean deletable, String viewId, List<String> stateLMKs) {
            super(uniqueItemIdentifier, state);
            this.dmkTableEntry = dmkTableEntry;
            this.cols = cols;
            this.help = help;
            this.deletable = deletable;
            this.viewId = viewId;
            this.stateLMKs = stateLMKs;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dmkTableEntry", (Object)this.dmkTableEntry).append("viewId", (Object)this.viewId).append("uniqueItemIdentifier", (Object)this.getUniqueItemIdentifier()).append("state", this.getState()).append("stateLMKs", this.stateLMKs).append("deletable", this.deletable).build();
        }

        public String getDmkTableEntry() {
            return this.dmkTableEntry;
        }

        public List<AbstractItemDTO> getCols() {
            return this.cols;
        }

        public void addChild(AbstractItemDTO child) {
            if (this.cols == null) {
                this.cols = new ArrayList<AbstractItemDTO>();
            }
            this.cols.add(child);
        }

        public HelpItemDTO getHelp() {
            return this.help;
        }

        public boolean isDeletable() {
            return this.deletable;
        }

        public String getViewId() {
            return this.viewId;
        }

        public List<String> getStateLMKs() {
            return this.stateLMKs;
        }
    }

    public static class HeaderItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3834589889839575605L;
        private final String name;
        private final int colspan;
        private final List<LabelAddOnDTO> headerAddOns;

        public HeaderItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String name, int colspan, List<LabelAddOnDTO> headerAddOns) {
            super(uniqueItemIdentifier, state);
            this.name = name;
            this.colspan = colspan;
            this.headerAddOns = headerAddOns;
        }

        public String getName() {
            return this.name;
        }

        public int getColspan() {
            return this.colspan;
        }

        public List<LabelAddOnDTO> getHeaderAddOns() {
            return this.headerAddOns;
        }

        public String getText(@NonNull AbstractConverter.ConverterContext ctx) throws FormRendererException {
            try {
                List<LabelAddOnDTO> addons = this.getHeaderAddOns();
                Object[] args = null;
                if (addons != null && !addons.isEmpty()) {
                    args = new Object[addons.size()];
                    for (int i = 0; i < args.length; ++i) {
                        LabelAddOnDTO element = addons.get(i);
                        AbstractConverter<?> conv = element.getRendererAndInputValidator();
                        StringBuilder s = new StringBuilder(Objects.requireNonNull(conv.getRenderedValue(element.getValue(), false, element.getOptionItems(), ctx)));
                        if (element.getLength() != null) {
                            if (s.length() > element.getLength()) {
                                s.setLength(element.getLength());
                            }
                            while (s.length() < element.getLength() && element.getFillpattern() != null) {
                                s.insert(0, element.getFillpattern());
                            }
                        }
                        args[i] = s.toString();
                    }
                }
                return ctx.getLocalizationHelper().translate(this.getName(), args);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                throw new FormRendererException("translation failed", e);
            }
        }
    }

    public static class ColDefItemDTO
    extends AbstractItemDTO
    implements Alignable,
    ItemWithStyle {
        private static final long serialVersionUID = 3257286941727994681L;
        private final String width;
        private final String header;
        private final List<LabelAddOnDTO> headerAddOns;
        private final String align;
        private final boolean filter;
        private final String filterPlaceholder;
        private final String styleClass;

        public ColDefItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, String width, String header, List<LabelAddOnDTO> headerAddOns, String align, boolean filter, String filterPlaceholder, @Nullable String styleClass) {
            super(uniqueItemIdentifier, state);
            this.width = width;
            this.header = header;
            this.headerAddOns = headerAddOns;
            this.align = align;
            this.filter = filter;
            this.filterPlaceholder = filterPlaceholder;
            this.styleClass = styleClass;
        }

        public String getWidth() {
            return this.width;
        }

        public String getHeader() {
            return this.header;
        }

        @Override
        public String getAlign() {
            return this.align;
        }

        public List<LabelAddOnDTO> getHeaderAddOns() {
            return this.headerAddOns;
        }

        public boolean isFilter() {
            return this.filter;
        }

        public boolean isWidthUndefined() {
            return "*".equals(this.width);
        }

        public String getFilterPlaceholder() {
            return this.filterPlaceholder;
        }

        @Override
        public @Nullable String getStyleClass() {
            return this.styleClass;
        }
    }

    public static class SectionItemDTO
    extends AbstractItemDTO
    implements ItemWithStyle {
        private static final long serialVersionUID = 3257568390867401017L;
        private List<ColDefItemDTO> coldefs;
        private final List<HeaderItemDTO> headers;
        private final HelpItemDTO help;
        private List<RowItemDTO> rows;
        private final boolean readonly;
        private @Nullable List<MessageItemDTO> messages = null;
        private String viewId;
        private final String header;
        private final List<LabelAddOnDTO> headerAddOns;
        private final String styleClass;
        private final String stateLMK;

        public SectionItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, List<ColDefItemDTO> coldefs, List<HeaderItemDTO> headers, HelpItemDTO help, List<RowItemDTO> rows, boolean readonly, String viewId, String header, List<LabelAddOnDTO> headerAddOns, String styleClass, @Nullable String stateLMK) {
            super(uniqueItemIdentifier, state);
            this.coldefs = coldefs;
            this.headers = headers;
            this.help = help;
            this.rows = rows;
            this.readonly = readonly;
            this.viewId = viewId;
            this.header = header;
            this.headerAddOns = headerAddOns;
            this.styleClass = styleClass;
            this.stateLMK = stateLMK;
        }

        public List<ColDefItemDTO> getColdefs() {
            return this.coldefs;
        }

        public List<HeaderItemDTO> getHeaders() {
            return this.headers;
        }

        public List<RowItemDTO> getRows() {
            return this.rows;
        }

        public HelpItemDTO getHelp() {
            return this.help;
        }

        public @Nullable List<MessageItemDTO> getMessages() {
            return this.messages;
        }

        public void setMessages(@Nullable List<MessageItemDTO> messages) {
            this.messages = messages;
        }

        public void setRows(List<RowItemDTO> rows) {
            this.rows = rows;
        }

        public void setColdefs(List<ColDefItemDTO> coldefs) {
            this.coldefs = coldefs;
        }

        public int getCntCols() {
            return this.coldefs.size() + 1;
        }

        public boolean getReadonly() {
            return this.readonly;
        }

        public void addMessage(MessageItemDTO message) {
            if (this.messages == null) {
                this.messages = new ArrayList<MessageItemDTO>();
            }
            this.messages.add(message);
        }

        public void addMessages(Collection<MessageItemDTO> msgs) {
            if (this.messages == null) {
                this.messages = new ArrayList<MessageItemDTO>();
            }
            this.messages.addAll(msgs);
        }

        public void removeMessage(MessageItemDTO message) {
            if (this.messages != null) {
                this.messages.remove(message);
                if (this.messages.isEmpty()) {
                    this.messages = null;
                }
            }
        }

        public boolean hasErrors() {
            if (this.getMessages() == null) {
                return false;
            }
            for (MessageItemDTO element : this.getMessages()) {
                MessageItemDTO miDTO = element;
                if (miDTO.getType() != 4) continue;
                return true;
            }
            return false;
        }

        public boolean hasWarnings() {
            if (this.getMessages() == null) {
                return false;
            }
            for (MessageItemDTO miDTO : this.getMessages()) {
                if (miDTO.getType() != 2) continue;
                return true;
            }
            return false;
        }

        public String getViewId() {
            return this.viewId;
        }

        public void setViewId(String viewId) {
            this.viewId = viewId;
        }

        public String getHeader() {
            return this.header;
        }

        public List<LabelAddOnDTO> getHeaderAddOns() {
            return this.headerAddOns;
        }

        @Override
        public String getStyleClass() {
            return this.styleClass;
        }

        public @Nullable String getStateLMK() {
            return this.stateLMK;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(WizardDisplayInfoDTO.NEWLINE).append(WizardDisplayInfoDTO.TAB).append("section: name=").append(this.getHeader()).append("; state=").append(this.getState());
            Iterator<RowItemDTO> iterator = this.getRows().iterator();
            while (iterator.hasNext()) {
                RowItemDTO element;
                RowItemDTO row = element = iterator.next();
                for (AbstractItemDTO item : row.getCols()) {
                    if (!(item instanceof ItemItemDTO)) continue;
                    sb.append(WizardDisplayInfoDTO.NEWLINE).append(WizardDisplayInfoDTO.TAB).append(WizardDisplayInfoDTO.TAB).append(item.toString());
                }
            }
            return sb.toString();
        }
    }

    public static class FormItemDTO
    extends AbstractItemDTO {
        private static final String TAB = "\t";
        private static final long serialVersionUID = 3257854259579203889L;
        private final String name;
        private final String header;
        private final HelpItemDTO help;
        private final List<LabelAddOnDTO> labelAddOns;
        private final List<AbstractItemDTO> children;
        private boolean isTableEntry;
        private String editOut;
        private boolean allNavigationItemsTouched;
        private final int printState;
        private final String headerTemplate;
        private final List<FormHeaderTemplateAddOnDTO> headerTemplateAddOns;
        private final boolean autoSetFocus;

        public FormItemDTO(DisplayItemUniqueID uniqueItemIdentifier, int state, int printState, String name, String header, HelpItemDTO help, List<LabelAddOnDTO> labelAddOns, List<AbstractItemDTO> children, String editOut, String headerTemplate, List<FormHeaderTemplateAddOnDTO> headerTemplateAddOns, boolean autoSetFocus) {
            super(uniqueItemIdentifier, state);
            this.children = children;
            this.name = name;
            this.header = header;
            this.help = help;
            this.isTableEntry = false;
            this.editOut = editOut;
            this.labelAddOns = labelAddOns;
            this.printState = printState;
            this.headerTemplate = headerTemplate;
            this.headerTemplateAddOns = headerTemplateAddOns;
            this.autoSetFocus = autoSetFocus;
        }

        public List<AbstractItemDTO> getChildren() {
            return this.children;
        }

        public @NonNull Collection<MessageItemDTO> getMessages() {
            LinkedHashSet<MessageItemDTO> messages = new LinkedHashSet<MessageItemDTO>();
            if (this.getChildren() != null) {
                for (AbstractItemDTO childObject : this.getChildren()) {
                    TableItemDTO tableItemDTO;
                    AbstractItemDTO formChild = childObject;
                    if (formChild instanceof SectionItemDTO) {
                        if (((SectionItemDTO)formChild).getMessages() == null) continue;
                        messages.addAll((Collection<MessageItemDTO>)Objects.requireNonNull(((SectionItemDTO)formChild).getMessages()));
                        continue;
                    }
                    if (!(formChild instanceof TableItemDTO) || !((TableItemDTO)formChild).isEditable() || (tableItemDTO = (TableItemDTO)formChild).getRows() == null) continue;
                    for (RowItemDTO rowItemDTO : tableItemDTO.getRows()) {
                        for (AbstractItemDTO item : rowItemDTO.getCols()) {
                            ItemItemDTO itemItemDTO;
                            if (!(item instanceof ItemItemDTO) || (itemItemDTO = (ItemItemDTO)item).getMessages() == null) continue;
                            messages.addAll(itemItemDTO.getMessages());
                        }
                    }
                }
            }
            return messages;
        }

        public String getName() {
            return this.name;
        }

        public String getHeader() {
            return this.header;
        }

        public HelpItemDTO getHelp() {
            return this.help;
        }

        public String getEditOut() {
            return this.editOut;
        }

        public void setEditOut(String editOut) {
            this.editOut = editOut;
        }

        public boolean getIsTableEntry() {
            return this.isTableEntry;
        }

        public void setIsTableEntry(boolean isTableEntry) {
            this.isTableEntry = isTableEntry;
        }

        public boolean getAllNavigationItemsTouched() {
            return this.allNavigationItemsTouched;
        }

        public void setAllNavigationItemsTouched(boolean allNavigationItemsTouched) {
            this.allNavigationItemsTouched = allNavigationItemsTouched;
        }

        public List<LabelAddOnDTO> getLabelAddOns() {
            return this.labelAddOns;
        }

        public int getPrintState() {
            return this.printState;
        }

        public String getHeaderTemplate() {
            return this.headerTemplate;
        }

        public List<FormHeaderTemplateAddOnDTO> getHeaderTemplateAddOns() {
            return this.headerTemplateAddOns;
        }

        public boolean isAutoSetFocus() {
            return this.autoSetFocus;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("form: state=").append(this.getState());
            Iterator<AbstractItemDTO> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                AbstractItemDTO childObject;
                AbstractItemDTO childItem = childObject = iterator.next();
                sb.append("\t").append(childItem.getClass().getName()).append(childItem.toString());
            }
            return sb.toString();
        }
    }

    public static interface Alignable {
        public String getAlign();
    }

    public static interface StringValue {
        public String getStringValue();
    }

    public static interface DataModelItem {
        public @NonNull String getDataModelKey();

        public @Nullable Object getValue();
    }

    public static interface StateFul {
        public int getState();
    }

    public static interface ItemWithStyle {
        public String getStyleClass();
    }

    public static interface ReRenderer {
        public Render getReRender();
    }

    public static interface RowContent {
        public int getColspan();

        public int getRowspan();
    }

    public static class AbstractItemDTO
    implements Serializable,
    StateFul {
        private static final long serialVersionUID = 3688503290383970865L;
        private int state;
        private final @NonNull DisplayItemUniqueID uniqueItemIdentifier;

        public AbstractItemDTO(@NonNull DisplayItemUniqueID uniqueItemIdentifier, int state) {
            this.state = state;
            this.uniqueItemIdentifier = uniqueItemIdentifier;
        }

        @Override
        public int getState() {
            return this.state;
        }

        public @NonNull DisplayItemUniqueID getUniqueItemIdentifier() {
            return this.uniqueItemIdentifier;
        }

        public boolean hasStateForVisibleMessages() {
            return this.state != 11 && this.state != 12;
        }
    }

    public static class NavigationDTO
    implements Serializable {
        private static final long serialVersionUID = 3258131340921747507L;
        private final @NonNull List<NavigationsItemDTO> navigationsItems;
        private final @Nullable String nextKey;
        private final @Nullable String prevKey;
        private final @Nullable String backKey;
        private final @NonNull String thisKey;
        private final int state;

        public NavigationDTO(@NonNull List<NavigationsItemDTO> navigationsItems, @Nullable String nextKey, @Nullable String prevKey, @Nullable String backKey, @NonNull String thisKey, int state) {
            this.navigationsItems = navigationsItems;
            this.nextKey = nextKey;
            this.prevKey = prevKey;
            this.backKey = backKey;
            this.thisKey = thisKey;
            this.state = state;
        }

        public @NonNull List<NavigationsItemDTO> getNavigationsItems() {
            return this.navigationsItems;
        }

        public @Nullable String getNextKey() {
            return this.nextKey;
        }

        public @Nullable String getPrevKey() {
            return this.prevKey;
        }

        public @Nullable String getBackKey() {
            return this.backKey;
        }

        public @NonNull String getThisKey() {
            return this.thisKey;
        }

        public int getState() {
            return this.state;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            NavigationDTO rhs = (NavigationDTO)obj;
            return new EqualsBuilder().append((Object)this.thisKey, (Object)rhs.thisKey).append((Object)this.nextKey, (Object)rhs.nextKey).append((Object)this.prevKey, (Object)rhs.prevKey).append((Object)this.backKey, (Object)rhs.backKey).append(this.state, rhs.state).append(this.navigationsItems, rhs.navigationsItems).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.thisKey).append((Object)this.nextKey).append((Object)this.prevKey).append((Object)this.backKey).append(this.state).append(this.navigationsItems).toHashCode();
        }
    }
}

