/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelItemDTO
implements Serializable {
    private static final long serialVersionUID = -1013017344496997291L;
    private static final Logger LOG = LoggerFactory.getLogger(ModelItemDTO.class);
    public static final int STATE_OK = 1;
    public static final int STATE_WARNING = 2;
    public static final int STATE_MISSINGVALUE = 3;
    public static final int STATE_ERROR = 4;
    private static final int STATE_INIT = 9;
    public static final int STATE_TRANSPARENT = 11;
    public static final int STATE_DISABLED = 12;
    private @Nullable Object value = null;
    private int state;
    private @Nullable Collection<MessageItemDTO> messages = null;
    private boolean touched = false;

    public ModelItemDTO() {
        this.state = 9;
    }

    public ModelItemDTO(@Nullable Object value) {
        this(value, 1, null);
    }

    public ModelItemDTO(@Nullable Object value, int state) {
        this(value, state, null);
    }

    public ModelItemDTO(@Nullable Object value, int state, @Nullable Collection<MessageItemDTO> msg) {
        this.value = value;
        this.state = state;
        this.messages = msg;
    }

    public ModelItemDTO clone(@Nullable Object newValue) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = newValue;
        result.state = this.state;
        result.messages = this.messages;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(int newState) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = newState;
        result.messages = this.messages;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(@Nullable Object newValue, int newState, @Nullable Collection<MessageItemDTO> msg) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = newValue;
        result.state = newState;
        result.messages = msg;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(int newState, @Nullable Collection<MessageItemDTO> msg) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = newState;
        result.messages = msg;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(int newState, @NonNull String messageKey, @Nullable Object messageValue, int messageType) {
        if (messageKey == null) {
            LOG.warn("Invalid API usage: {}/{}/{}/{}", new Object[]{newState, messageKey, messageValue, messageType});
        }
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = newState;
        result.messages = new ArrayList<MessageItemDTO>();
        if (this.messages != null) {
            result.messages.addAll(this.messages);
        }
        result.messages.add(new MessageItemDTO(messageKey, messageValue, messageType));
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(String messageKey, Object messageValue, int messageType) {
        return this.clone(this.value, this.state, messageKey, messageValue, messageType);
    }

    public ModelItemDTO clone(Object newValue, int newState, String messageKey, Object messageValue, int messageType) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = newValue;
        result.state = newState;
        result.messages = new ArrayList<MessageItemDTO>();
        if (this.messages != null) {
            result.messages.addAll(this.messages);
        }
        result.messages.add(new MessageItemDTO(messageKey, messageValue, messageType));
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO cloneUntouched() {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = this.state;
        result.messages = this.messages;
        result.touched = false;
        return result;
    }

    public ModelItemDTO cloneTouched() {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = this.state;
        result.messages = this.messages;
        result.touched = true;
        return result;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public int getState() {
        return this.state;
    }

    public @Nullable Collection<MessageItemDTO> getMessages() {
        return this.messages;
    }

    public boolean isTouched() {
        return this.touched;
    }

    public void setTouched() {
        this.touched = true;
    }

    public boolean hasMoreImportantState(int otherState) {
        return ModelItemDTO.isMoreImportantState(this.state, otherState);
    }

    public static boolean isMoreImportantState(int state1, int state2) {
        return state1 > state2;
    }

    public boolean hasPropagatableState() {
        return ModelItemDTO.isPropagatableState(this.state);
    }

    public static boolean isPropagatableState(int state) {
        return state != 11 && state != 12;
    }

    public boolean equals(@Nullable Object obj) {
        if (!this.valueIsEqual(obj)) {
            return false;
        }
        assert (obj != null) : "obj == null sollte schon durch valueIsEqual abgehandelt sein";
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ModelItemDTO miDTO = (ModelItemDTO)obj;
        if (this.getState() != miDTO.getState()) {
            return false;
        }
        if (this.isTouched() != miDTO.isTouched()) {
            return false;
        }
        if (this.messages == null) {
            return miDTO.getMessages() == null;
        }
        return this.messages.equals(miDTO.getMessages());
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.value).append(this.messages).toHashCode();
    }

    public boolean valueIsEqual(@Nullable Object obj) {
        if (!(obj instanceof ModelItemDTO)) {
            return false;
        }
        if (this.value == null) {
            return ((ModelItemDTO)obj).getValue() == null;
        }
        return this.value.equals(((ModelItemDTO)obj).getValue());
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public String toDebugString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.state).append(this.value).append(this.touched).append(this.messages).build();
    }
}

