/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class DvbTaxSessionWorkStatus
implements Serializable {
    public static final String PERCENTAGE_DONE_PROP = "tmoSessionWorkStatus-workPercentageDone";
    public static final String TOTAL_PERCENTAGE_DONE_PROP = "tmoSessionWorkStatus-totalWorkPercentageDone";
    public static final String TIME_REMAINING_PROP = "tmoSessionWorkStatus-timeRemaining";
    public static final String TOTAL_TIME_EXPECTED_PROP = "tmoSessionWorkStatus-totalTimeExpected";
    public static final String TOTAL_STEPS_PROP = "tmoSessionWorkStatus-totalSteps";
    public static final String JOB_NAME_PROP = "tmoSessionWorkStatus-pendingJob";
    public static final String STEP_PROP = "tmoSessionWorkStatus-actualStep";
    private static final long serialVersionUID = 1L;
    private MutableStateHolder mutex = new MutableStateHolder();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkPercentageDone(int workProgress) throws InterruptedException {
        this.checkForInterrupt();
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            Integer oldValue = this.mutex.workPercentageDone;
            this.mutex.workPercentageDone = workProgress;
            this.propertyChangeSupport.firePropertyChange(PERCENTAGE_DONE_PROP, oldValue, (Object)workProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalWorkPercentageDone(int totalWorkPercentageDone) throws InterruptedException {
        this.checkForInterrupt();
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            Integer oldValue = this.mutex.totalWorkPercentageDone;
            this.mutex.totalWorkPercentageDone = totalWorkPercentageDone;
            this.propertyChangeSupport.firePropertyChange(TOTAL_PERCENTAGE_DONE_PROP, oldValue, (Object)totalWorkPercentageDone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeRemaining(int secondsRemaining) throws InterruptedException {
        this.checkForInterrupt();
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            Integer oldValue = this.mutex.timeRemaining;
            this.mutex.timeRemaining = secondsRemaining;
            this.propertyChangeSupport.firePropertyChange(TIME_REMAINING_PROP, oldValue, (Object)secondsRemaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingJob(String job) throws InterruptedException {
        this.checkForInterrupt();
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            String oldValue = this.mutex.pendingJob;
            this.mutex.pendingJob = job;
            this.propertyChangeSupport.firePropertyChange(JOB_NAME_PROP, oldValue, job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalTimeExpected(int timeExp) throws InterruptedException {
        this.checkForInterrupt();
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            Integer oldValue = this.mutex.totalTimeExpected;
            this.mutex.totalTimeExpected = timeExp;
            this.propertyChangeSupport.firePropertyChange(TOTAL_TIME_EXPECTED_PROP, oldValue, (Object)timeExp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalSteps(int steps) throws InterruptedException {
        this.checkForInterrupt();
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            Integer oldValue = this.mutex.totalSteps;
            this.mutex.totalSteps = steps;
            this.propertyChangeSupport.firePropertyChange(TOTAL_STEPS_PROP, oldValue, (Object)steps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActualStep(int step) throws InterruptedException {
        this.checkForInterrupt();
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            Integer oldValue = this.mutex.actualStep;
            this.mutex.actualStep = step;
            this.propertyChangeSupport.firePropertyChange(STEP_PROP, oldValue, (Object)step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStep(int actualStep, int totalSteps) throws InterruptedException {
        this.checkForInterrupt();
        if (actualStep <= 0 || totalSteps <= 0) {
            throw new ApplicationException("WorkStatus Steps nicht korrekt definiert!");
        }
        if (actualStep > totalSteps) {
            throw new ApplicationException("WorkStatus Steps nicht korrekt definiert! Actual: " + actualStep + "of Total: " + totalSteps);
        }
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            this.setTotalSteps(totalSteps);
            this.setActualStep(actualStep);
        }
    }

    private void checkForInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Current thread has been interupted: abording operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkPercentageDone() {
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            return this.mutex.workPercentageDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeRemaining() {
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            return this.mutex.timeRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPendingJob() {
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            return this.mutex.pendingJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalTimeExpected() {
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            return this.mutex.totalTimeExpected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActualStep() {
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            return this.mutex.actualStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSteps() {
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            return this.mutex.totalSteps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalWorkPercentageDone() {
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            return this.mutex.totalWorkPercentageDone;
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private class MutableStateHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int workPercentageDone = 0;
        private int totalWorkPercentageDone = 0;
        private int totalTimeExpected = -1;
        private int actualStep = 1;
        private int totalSteps = 1;
        private int timeRemaining = 0;
        private String pendingJob = null;
    }
}

