/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.ExpertTableRowComparator;
import ch.dvbern.tax.common.presentation.common.util.TableSort;
import ch.dvbern.tax.common.presentation.common.util.WizardTableRowComparator;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TableSortHelper {
    private TableSortHelper() {
    }

    public static void sortTables(Map<String, TableSort> tableSorts, WizardDisplayInfoDTO diDTO,  @NonNull AbstractConverter.ConverterContext ctx) {
        if (diDTO == null || diDTO.getFormItemDTO().getChildren() == null) {
            return;
        }
        for (WizardDisplayInfoDTO.AbstractItemDTO child : diDTO.getFormItemDTO().getChildren()) {
            if (!(child instanceof WizardDisplayInfoDTO.TableItemDTO)) continue;
            TableSortHelper.sortTable((WizardDisplayInfoDTO.TableItemDTO)child, ctx, tableSorts);
        }
    }

    public static void sortTables(Map<String, TableSort> tableSorts, ExpertDisplayInfoDTO diDTO,  @NonNull AbstractConverter.ConverterContext ctx) {
        if (diDTO == null) {
            return;
        }
        for (ExpertDisplayInfoDTO.ItemDTO child : diDTO.getItems()) {
            if (!(child instanceof ExpertDisplayInfoDTO.TableDTO)) continue;
            TableSortHelper.sortTable((ExpertDisplayInfoDTO.TableDTO)child, ctx, tableSorts);
        }
    }

    public static void sortTable(ExpertDisplayInfoDTO.TableDTO table,  @NonNull AbstractConverter.ConverterContext ctx, Map<String, TableSort> sorts) {
        if (table.getAllRows() == null || table.getAllRows().isEmpty()) {
            return;
        }
        TableSort tableSort = sorts.get(table.getLogicModelKey());
        if (tableSort == null || tableSort.getIndex() < 0 || tableSort.getIndex() >= table.getInputColumns().size()) {
            return;
        }
        ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = table.getInputColumns().get(tableSort.getIndex());
        int allColumnsIndex = 0;
        Iterator<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> it = table.getAllColumns().iterator();
        while (it.hasNext() && !it.next().equals(col)) {
            ++allColumnsIndex;
        }
        ExpertTableRowComparator comp = new ExpertTableRowComparator(allColumnsIndex - 1, tableSort.isAsc(), ctx, table.getAllColumns());
        Collections.sort(table.getAllRows(), comp);
        Collections.sort(table.getInputRows(), comp);
        Collections.sort(table.getPrintRows(), comp);
    }

    public static void sortTable(WizardDisplayInfoDTO.TableItemDTO table,  @NonNull AbstractConverter.ConverterContext ctx, Map<String, TableSort> sorts) {
        if (table.getRows() == null || table.getRows().isEmpty()) {
            return;
        }
        TableSort tableSort = sorts.get(table.getLogicModelKey());
        if (tableSort == null || tableSort.getIndex() < 0 || tableSort.getIndex() >= table.getCntCols()) {
            return;
        }
        WizardTableRowComparator comp = new WizardTableRowComparator(tableSort.getIndex(), tableSort.isAsc(), ctx);
        Collections.sort(table.getRows(), comp);
    }
}

