/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.integration.conf.AbstractOnlineApplicationConfig;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StyleRegistry
extends Enum<StyleRegistry> {
    public static final /* enum */ StyleRegistry ITEM_TYPE_OUTPUT = new StyleRegistry("typeOutput");
    public static final /* enum */ StyleRegistry ITEM_TYPE_INPUT = new StyleRegistry("typeInput");
    public static final /* enum */ StyleRegistry ITEM_TYPE_COMBO = new StyleRegistry("typeCombo");
    public static final /* enum */ StyleRegistry ITEM_TYPE_RADIO = new StyleRegistry("typeRadio");
    public static final /* enum */ StyleRegistry ITEM_TYPE_CHECKBOX = new StyleRegistry("typeCheck");
    public static final /* enum */ StyleRegistry ITEM_TYPE_LABEL = new StyleRegistry("typeLabel");
    public static final /* enum */ StyleRegistry ITEM_TYPE_BUTTON = new StyleRegistry("typeButton");
    public static final /* enum */ StyleRegistry ITEM_TYPE_IMAGE_BUTTON = new StyleRegistry("typeImageButton");
    public static final /* enum */ StyleRegistry ITEM_TYPE_TEXTAREA = new StyleRegistry("typeTextarea", "typeTextarea heightTextarea");
    public static final /* enum */ StyleRegistry ITEM_TYPE_LINK = new StyleRegistry("typeLink");
    public static final /* enum */ StyleRegistry ITEM_TYPE_FILE_DETAILS = new StyleRegistry("typeFileDetails");
    public static final /* enum */ StyleRegistry ITEM_TYPE_STATE_INDICATOR = new StyleRegistry("typeStateIndicator");
    public static final /* enum */ StyleRegistry ITEM_TYPE_INPUT_DATE = new StyleRegistry("inputDate");
    public static final /* enum */ StyleRegistry ITEM_TYPE_INPUT_DAYMONTH = new StyleRegistry("inputDayMonth", "inputDayMonth inputDayMonth");
    public static final /* enum */ StyleRegistry ITEM_STATE_ENABLED = new StyleRegistry("stateEnabled");
    public static final /* enum */ StyleRegistry ITEM_STATE_MISSINGVALUE = new StyleRegistry("stateMissing");
    public static final /* enum */ StyleRegistry ITEM_STATE_WARNING = new StyleRegistry("stateWarning");
    public static final /* enum */ StyleRegistry ITEM_STATE_ERROR = new StyleRegistry("stateError");
    public static final /* enum */ StyleRegistry ITEM_STATE_TRANSPARENT = new StyleRegistry("stateTransparent");
    public static final /* enum */ StyleRegistry ITEM_STATE_READONLY = new StyleRegistry("stateReadonly");
    public static final /* enum */ StyleRegistry ITEM_STATE_DISABLED = new StyleRegistry("stateDisabled");
    public static final /* enum */ StyleRegistry ITEM_WIDTH_UNDEFINED = new StyleRegistry("widthUndefined");
    public static final /* enum */ StyleRegistry ITEM_WIDTH_ALL = new StyleRegistry("widthAll");
    public static final /* enum */ StyleRegistry ITEM_WIDTH_NORMAL = new StyleRegistry("widthNormal");
    public static final /* enum */ StyleRegistry ITEM_WIDTH_MEDIUM = new StyleRegistry("widthMedium");
    public static final /* enum */ StyleRegistry ITEM_WIDTH_SMALL = new StyleRegistry("widthSmall");
    public static final /* enum */ StyleRegistry ITEM_WIDTH_TINY = new StyleRegistry("widthTiny");
    public static final /* enum */ StyleRegistry ITEM_WIDTH_NANO = new StyleRegistry("widthNano");
    public static final /* enum */ StyleRegistry ALIGNMENT_RIGHT = new StyleRegistry("alignRight");
    public static final /* enum */ StyleRegistry ALIGNMENT_LEFT = new StyleRegistry("alignLeft");
    public static final /* enum */ StyleRegistry ALIGNMENT_CENTER = new StyleRegistry("alignCenter");
    public static final /* enum */ StyleRegistry ITEM_HEIGHT_TEXTAREA = new StyleRegistry("heightTextarea");
    public static final /* enum */ StyleRegistry INPUT_TEXT_ENABLED = new StyleRegistry("inputText");
    public static final /* enum */ StyleRegistry INPUT_TEXT_DISABLED = new StyleRegistry("inputDisabled");
    public static final /* enum */ StyleRegistry INPUT_TEXT_ERROR = new StyleRegistry("inputError");
    public static final /* enum */ StyleRegistry INPUT_TEXT_WARNING = new StyleRegistry("inputWarning");
    public static final /* enum */ StyleRegistry INPUT_TEXT_MEDIUM_ENABLED = new StyleRegistry("inputTextMedium");
    public static final /* enum */ StyleRegistry INPUT_TEXT_MEDIUM_DISABLED = new StyleRegistry("inputDisabledMedium");
    public static final /* enum */ StyleRegistry INPUT_TEXT_MEDIUM_ERROR = new StyleRegistry("inputErrorMedium");
    public static final /* enum */ StyleRegistry INPUT_TEXT_MEDIUM_WARNING = new StyleRegistry("inputWarningMedium");
    public static final /* enum */ StyleRegistry INPUT_TEXT_SMALL_ENABLED = new StyleRegistry("inputTextSmall");
    public static final /* enum */ StyleRegistry INPUT_TEXT_SMALL_DISABLED = new StyleRegistry("inputDisabledSmall");
    public static final /* enum */ StyleRegistry INPUT_TEXT_SMALL_ERROR = new StyleRegistry("inputErrorSmall");
    public static final /* enum */ StyleRegistry INPUT_TEXT_SMALL_WARNING = new StyleRegistry("inputWarningSmall");
    public static final /* enum */ StyleRegistry INPUT_TEXT_TINY_ENABLED = new StyleRegistry("inputTextTiny");
    public static final /* enum */ StyleRegistry INPUT_TEXT_TINY_DISABLED = new StyleRegistry("inputDisabledTiny");
    public static final /* enum */ StyleRegistry INPUT_TEXT_TINY_ERROR = new StyleRegistry("inputErrorTiny");
    public static final /* enum */ StyleRegistry INPUT_TEXT_TINY_WARNING = new StyleRegistry("inputWarningTiny");
    public static final /* enum */ StyleRegistry INPUT_COMBO_ENABLED = new StyleRegistry("inputComboText");
    public static final /* enum */ StyleRegistry INPUT_COMBO_DISABLED = new StyleRegistry("inputComboDisabled");
    public static final /* enum */ StyleRegistry INPUT_COMBO_ERROR = new StyleRegistry("inputComboError");
    public static final /* enum */ StyleRegistry INPUT_COMBO_WARNING = new StyleRegistry("inputComboWarning");
    public static final /* enum */ StyleRegistry INPUT_COMBO_MEDIUM_ENABLED = new StyleRegistry("inputComboTextMedium");
    public static final /* enum */ StyleRegistry INPUT_COMBO_MEDIUM_DISABLED = new StyleRegistry("inputComboDisabledMedium");
    public static final /* enum */ StyleRegistry INPUT_COMBO_MEDIUM_ERROR = new StyleRegistry("inputComboErrorMedium");
    public static final /* enum */ StyleRegistry INPUT_COMBO_MEDIUM_WARNING = new StyleRegistry("inputComboWarningMedium");
    public static final /* enum */ StyleRegistry INPUT_COMBO_SMALL_ENABLED = new StyleRegistry("inputComboTextSmall");
    public static final /* enum */ StyleRegistry INPUT_COMBO_SMALL_DISABLED = new StyleRegistry("inputComboDisabledSmall");
    public static final /* enum */ StyleRegistry INPUT_COMBO_SMALL_ERROR = new StyleRegistry("inputComboErrorSmall");
    public static final /* enum */ StyleRegistry INPUT_COMBO_SMALL_WARNING = new StyleRegistry("inputComboWarningSmall");
    public static final /* enum */ StyleRegistry INPUT_COMBO_TINY_ENABLED = new StyleRegistry("inputComboTextTiny");
    public static final /* enum */ StyleRegistry INPUT_COMBO_TINY_DISABLED = new StyleRegistry("inputComboDisabledTiny");
    public static final /* enum */ StyleRegistry INPUT_COMBO_TINY_ERROR = new StyleRegistry("inputComboErrorTiny");
    public static final /* enum */ StyleRegistry INPUT_COMBO_TINY_WARNING = new StyleRegistry("inputComboWarningTiny");
    public static final /* enum */ StyleRegistry OUTPUT_TEXT = new StyleRegistry("tdEnabled");
    public static final /* enum */ StyleRegistry OUTPUT_TEXT_DISABLED = new StyleRegistry("tdOutputTransparent");
    public static final /* enum */ StyleRegistry OUTPUT_TEXT_READONLY = new StyleRegistry("tdOutputReadonly");
    public static final /* enum */ StyleRegistry OUTPUT_TITEL = new StyleRegistry("tdTitel");
    public static final /* enum */ StyleRegistry OUTPUT_TITLE_DISABLED = new StyleRegistry("tdTitelDisabled");
    public static final /* enum */ StyleRegistry COMMAND_LINK = new StyleRegistry("link_enabled");
    public static final /* enum */ StyleRegistry BUTTON = new StyleRegistry("button");
    public static final /* enum */ StyleRegistry BUTTON_DISABLED = new StyleRegistry("buttonDisabled");
    public static final /* enum */ StyleRegistry BUTTON_NEW_TABLE_ENTRY = new StyleRegistry("buttonNewTableEntry");
    public static final /* enum */ StyleRegistry BUTTON_ADD_ROW = new StyleRegistry("addTableRow");
    public static final /* enum */ StyleRegistry BUTTON_STATUS_FILTER = new StyleRegistry("statusFilter");
    public static final /* enum */ StyleRegistry SECTION = new StyleRegistry("section");
    public static final /* enum */ StyleRegistry TMO_TABLE = new StyleRegistry("divTmoTable");
    public static final /* enum */ StyleRegistry TABLE_FILTER_INPUT = new StyleRegistry("tableFilterInput");
    public static final /* enum */ StyleRegistry TABLE_RADIOBUTTONS = new StyleRegistry("tableRadiobuttons");
    public static final /* enum */ StyleRegistry TABLE_SECTIONITEM = new StyleRegistry("tableTmoSection");
    public static final /* enum */ StyleRegistry TABLE_SECTIONITEM_SORTICON = new StyleRegistry("tableTmoSectionSortIcon");
    public static final /* enum */ StyleRegistry TABLE_TABLEITEM = new StyleRegistry("tableTmoTable");
    public static final /* enum */ StyleRegistry TABLE_READONLY = new StyleRegistry("tableTmoReadOnly");
    public static final /* enum */ StyleRegistry TABLE_NAVIGATION = new StyleRegistry("tableTmoNavigation");
    public static final /* enum */ StyleRegistry TABLE_WIZARDPRINT = new StyleRegistry("tableTmoPrint");
    public static final /* enum */ StyleRegistry TABLE_HEADER_ICON = new StyleRegistry("cellHeaderTableShorthelp");
    public static final /* enum */ StyleRegistry TABLE_HEADER_ICON_TRANSPARENT = new StyleRegistry("cellHeaderTableShorthelpTransparent");
    public static final /* enum */ StyleRegistry TABLE_HEADER = new StyleRegistry("cellHeaderTable");
    public static final /* enum */ StyleRegistry TABLE_HEADER_TRANSPARENT = new StyleRegistry("cellHeaderTableTransparent");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_50 = new StyleRegistry("column_50");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_100 = new StyleRegistry("column_100");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_150 = new StyleRegistry("column_150");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_200 = new StyleRegistry("column_200");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_ICON = new StyleRegistry("column_icon");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_ICON_TRANSPARENT = new StyleRegistry("column_icon_transparent");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_STATE = new StyleRegistry("column_status");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_STATE_TRANSPARENT = new StyleRegistry("column_status_transparent");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_STATE_DISABLED = new StyleRegistry("column_status_disabled");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_UNDEFINED = new StyleRegistry("column_undefined");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_SPACER = new StyleRegistry("column_spacer");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_INVISIBLE = new StyleRegistry("column_invisible");
    public static final /* enum */ StyleRegistry TABLE_SCROLLER_ENABLED = new StyleRegistry("table_scroller_enabled");
    public static final /* enum */ StyleRegistry TABLE_SCROLLER_TRANSPARENT = new StyleRegistry("table_scroller_transparent");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_NAV_PFEIL = new StyleRegistry("column_nav_pfeil");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_NAV_STATE = new StyleRegistry("column_nav_state");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_NAV_TEXT = new StyleRegistry("column_nav_text");
    public static final /* enum */ StyleRegistry TABLE_COLUMN_NAV_SPACER = new StyleRegistry("column_nav_spacer");
    public static final /* enum */ StyleRegistry NAVIGATION_SPAVER = new StyleRegistry("navigation_spacer");
    public static final /* enum */ StyleRegistry NAVIGATION_FUNCTION_MENU = new StyleRegistry("navfunction_menu");
    public static final /* enum */ StyleRegistry NAVIGATION_FUNCTION = new StyleRegistry("navigation_function");
    public static final /* enum */ StyleRegistry NAVIGATION_FUNCTION_ACTIVE = new StyleRegistry("navfunction_active");
    public static final /* enum */ StyleRegistry NAVIGATION_FUNCTION_OPEN = new StyleRegistry("navfunction_open");
    public static final /* enum */ StyleRegistry NAVIGATION_FUNCTION_DISABLED = new StyleRegistry("navfunction_disabled");
    public static final /* enum */ StyleRegistry NAVIGATION_FUNCTION_ENABLED = new StyleRegistry("navfunction_enabled");
    public static final /* enum */ StyleRegistry TABLE_ROW_SPACER = new StyleRegistry("row_spacer");
    public static final /* enum */ StyleRegistry TABLE_ROW_STATE_DISABLED = new StyleRegistry("rowDisabled");
    public static final /* enum */ StyleRegistry TABLE_NO_ENTRY_LBL = new StyleRegistry("table_no_entry_lbl");
    public static final /* enum */ StyleRegistry TABLE_CELL_HEADER_SHORTHELP = new StyleRegistry("cellHeaderMinHeight");
    public static final /* enum */ StyleRegistry TABLE_CELL_HEADER_SHORTHELP_TRANSPARENT = new StyleRegistry("cellHeaderMinHeightTransparent");
    public static final /* enum */ StyleRegistry TABLE_CELL_SHORTHELP = new StyleRegistry("cellMinHeight");
    public static final /* enum */ StyleRegistry TABLE_CELL_ENABLED = new StyleRegistry("cellEnabled");
    public static final /* enum */ StyleRegistry TABLE_CELL_DISABLED = new StyleRegistry("cellDisabled");
    public static final /* enum */ StyleRegistry TABLE_CELL_TRANSPARENT = new StyleRegistry("cellTransparent");
    public static final /* enum */ StyleRegistry TABLE_CELL_READONLY = new StyleRegistry("cellReadonly");
    public static final /* enum */ StyleRegistry TABLE_CELL_HEADER = new StyleRegistry("cellHeaderEnabled");
    public static final /* enum */ StyleRegistry TABLE_CELL_HEADER_TRANSPARENT = new StyleRegistry("cellHeaderTransparent");
    public static final /* enum */ StyleRegistry TABLE_CELL_ERROR = new StyleRegistry("cellError");
    public static final /* enum */ StyleRegistry TABLE_CELL_WARNING = new StyleRegistry("cellWarning");
    public static final /* enum */ StyleRegistry TABLE_CELL_SPACER = new StyleRegistry("cellSpacer");
    public static final /* enum */ StyleRegistry TABLE_CELL_EDIT = new StyleRegistry("cellEdit");
    public static final /* enum */ StyleRegistry TABLE_CELL_DELETE = new StyleRegistry("cellDelete");
    public static final /* enum */ StyleRegistry TABLE_CELL_STATUS = new StyleRegistry("cellStatus");
    public static final /* enum */ StyleRegistry TABLE_CELL_PRINT_ROW = new StyleRegistry("cellPrintRow");
    public static final /* enum */ StyleRegistry NAVIGATION_MODEL_NAVIGATION = new StyleRegistry("tmo-model-navigation");
    public static final /* enum */ StyleRegistry NAVIGATION_LINK = new StyleRegistry("tmo-navigation__link");
    public static final /* enum */ StyleRegistry NAVIGATION_LINK_DISABLED = new StyleRegistry("tmo-navigation__link tmo-navigation__link--disabled");
    public static final /* enum */ StyleRegistry NAVIGATION_LINK_TEXT = new StyleRegistry("tmo-navigation__link__text");
    public static final /* enum */ StyleRegistry NAVIGATION_PFEIL_LEVEL_1 = new StyleRegistry("navigation_pfeil_level1");
    public static final /* enum */ StyleRegistry NAVIGATION_PFEIL_LEVEL_2 = new StyleRegistry("navigation_pfeil_level2");
    public static final /* enum */ StyleRegistry NAVIGATION_STATE = new StyleRegistry("navigation_state");
    public static final /* enum */ StyleRegistry NAVIGATION_STATE_LEVEL_1 = new StyleRegistry("navigation_state_level1");
    public static final /* enum */ StyleRegistry NAVIGATION_STATE_LEVEL_2 = new StyleRegistry("navigation_state_level2");
    public static final /* enum */ StyleRegistry NAVIGATION_STATE_ICON = new StyleRegistry("navigation_state_icon");
    public static final /* enum */ StyleRegistry NAVIGATION_TEXT_LEVEL_1 = new StyleRegistry("navigation_text_level1");
    public static final /* enum */ StyleRegistry NAVIGATION_TEXT_LEVEL_2 = new StyleRegistry("navigation_text_level2");
    public static final /* enum */ StyleRegistry NAVIGATION_TEXT_ACTIVE = new StyleRegistry("navigation_text_active");
    public static final /* enum */ StyleRegistry NAVIGATION_TEXT_DISABLED = new StyleRegistry("navigation_text_disabled");
    public static final /* enum */ StyleRegistry NAVIGATION_TEXT_ENABLED = new StyleRegistry("navigation_text_enabled");
    public static final /* enum */ StyleRegistry NAVIGATION_TEXT_SELECTED = new StyleRegistry("navigation_text_selected");
    public static final /* enum */ StyleRegistry NAVIGATION_ITEM_ACTIVE = new StyleRegistry("navitem_active");
    public static final /* enum */ StyleRegistry NAVIGATION_ITEM_OPEN = new StyleRegistry("navitem_open");
    public static final /* enum */ StyleRegistry NAVIGATION_ITEM_DISABLED = new StyleRegistry("navitem_disabled");
    public static final /* enum */ StyleRegistry NAVIGATION_ITEM_ENABLED = new StyleRegistry("navitem_enabled");
    public static final /* enum */ StyleRegistry SPACER_LEFT = new StyleRegistry("spacer_left");
    public static final /* enum */ StyleRegistry SPACER_TOP_LEFT = new StyleRegistry("spacer_top_left");
    public static final /* enum */ StyleRegistry TEXT_NORMAL = new StyleRegistry("tdNormal");
    public static final /* enum */ StyleRegistry TEXT_NORMAL_DISABLED = new StyleRegistry("tdNormalDisabled");
    public static final /* enum */ StyleRegistry LABEL_DEFAULT_ALIGNMENT = new StyleRegistry("label_alignment");
    public static final /* enum */ StyleRegistry LABEL_HELP_TEXT = new StyleRegistry("label_help_text");
    public static final /* enum */ StyleRegistry LABEL_ENABLED = new StyleRegistry("label_enabled");
    public static final /* enum */ StyleRegistry LABEL_ERROR = new StyleRegistry("label_error");
    public static final /* enum */ StyleRegistry LABEL_WARNING = new StyleRegistry("label_warning");
    public static final /* enum */ StyleRegistry LABEL_DISABLED = new StyleRegistry("label_disabled");
    public static final /* enum */ StyleRegistry OPEN_HELP = new StyleRegistry("helpLink");
    public static final /* enum */ StyleRegistry SHORTHELP_LINK = new StyleRegistry("shortHelpLink");
    public static final /* enum */ StyleRegistry BREADCRUMB_ENABLED = new StyleRegistry("breadcrumb_enabled");
    public static final /* enum */ StyleRegistry BREADCRUMB_DISABLED = new StyleRegistry("breadcrumb_disabled");
    public static final /* enum */ StyleRegistry BREADCRUMB_CURRENT = new StyleRegistry("current");
    public static final /* enum */ StyleRegistry BREADCRUMB_DELIMITER = new StyleRegistry("delimiter");
    public static final /* enum */ StyleRegistry HIDDEN = new StyleRegistry("hidden");
    public static final /* enum */ StyleRegistry READONLY = new StyleRegistry("readOnly");
    public static final /* enum */ StyleRegistry LINK_STYLE_EXTERNAL = new StyleRegistry("external");
    public static final /* enum */ StyleRegistry LINK_STYLE_PDF = new StyleRegistry("pdf");
    public static final /* enum */ StyleRegistry LINK_STYLE_XLS = new StyleRegistry("xls");
    public static final /* enum */ StyleRegistry LINK_STYLE_DOC = new StyleRegistry("doc");
    public static final /* enum */ StyleRegistry LINK_STYLE_TXT = new StyleRegistry("txt");
    public static final /* enum */ StyleRegistry LINK_STYLE_TAX = new StyleRegistry("tax");
    public static final /* enum */ StyleRegistry LINK_STYLE_OTHER = new StyleRegistry("other");
    private static final String CONF_PREFIX = "dvbtax.styles.";
    public static final char EMPTY_CHAR = ' ';
    private final String value;
    private static final /* synthetic */ StyleRegistry[] $VALUES;

    public static StyleRegistry[] values() {
        return (StyleRegistry[])$VALUES.clone();
    }

    public static StyleRegistry valueOf(String name) {
        return Enum.valueOf(StyleRegistry.class, name);
    }

    private StyleRegistry(String key) {
        this(key, key);
    }

    private StyleRegistry(String key, String defaultValue) {
        assert (key != null && defaultValue != null);
        AbstractOnlineApplicationConfig appConfig = (AbstractOnlineApplicationConfig)ApplicationConfig.getInstance();
        String styleValue = null;
        String confKey = CONF_PREFIX + key;
        if (appConfig.containsKey(confKey)) {
            styleValue = appConfig.getString(confKey);
        }
        if (styleValue == null) {
            styleValue = defaultValue;
        }
        this.value = styleValue;
    }

    public static String getComboboxStyle(WizardDisplayInfoDTO.ItemItemDTO itemItem, String value, boolean inlineHelp) {
        Object inputStyle = StyleRegistry.getNonTextInputStyle(itemItem.getState(), itemItem.getWidth(), value, inlineHelp);
        if (itemItem.getStyleClass() != null) {
            inputStyle = (String)inputStyle + " " + itemItem.getStyleClass();
        }
        return inputStyle;
    }

    public String getValue() {
        return this.value;
    }

    public String addStyleTo(@Nullable String styles) {
        Object allStyles = this.getValue();
        if (styles != null) {
            allStyles = styles + " " + (String)allStyles;
        }
        return ((String)allStyles).trim();
    }

    public static String getTextStyle(WizardDisplayInfoDTO.ItemItemDTO itemItem, int state, boolean hasHelp) {
        String converterStyle;
        Object inputStyle = StyleRegistry.getStateAndWidthsStylesForText(itemItem.getWidth(), state);
        if (hasHelp) {
            inputStyle = (String)inputStyle + " " + OPEN_HELP.getValue();
        }
        if (itemItem.getStyleClass() != null) {
            inputStyle = (String)inputStyle + " " + itemItem.getStyleClass();
        }
        if (itemItem.getAlign() != null) {
            inputStyle = (String)inputStyle + " " + StyleRegistry.getAlignmentStyle(itemItem.getAlign());
        }
        if (!(converterStyle = itemItem.getRendererAndInputValidator().getStyleClass().trim()).isEmpty()) {
            inputStyle = (String)inputStyle + " " + converterStyle;
        }
        return ITEM_TYPE_INPUT.getValue() + " " + (String)inputStyle;
    }

    private static @NonNull String getStateAndWidthsStylesForText(int width, int state) {
        String inputStyle;
        if (width <= 75) {
            inputStyle = INPUT_TEXT_TINY_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_TEXT_TINY_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_TEXT_TINY_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_TEXT_TINY_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + " " + ITEM_WIDTH_TINY.getValue();
        } else if (width <= 125) {
            inputStyle = INPUT_TEXT_SMALL_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_TEXT_SMALL_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_TEXT_SMALL_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_TEXT_SMALL_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + " " + ITEM_WIDTH_SMALL.getValue();
        } else if (width <= 175) {
            inputStyle = INPUT_TEXT_MEDIUM_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_TEXT_MEDIUM_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_TEXT_MEDIUM_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_TEXT_MEDIUM_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + " " + ITEM_WIDTH_MEDIUM.getValue();
        } else {
            inputStyle = INPUT_TEXT_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_TEXT_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_TEXT_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_TEXT_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + " " + ITEM_WIDTH_NORMAL.getValue();
        }
        return inputStyle;
    }

    public static String getNonTextInputStyle(int state, int width, String type, boolean hasHelp) {
        String inputStyle;
        if (width <= 75) {
            inputStyle = INPUT_COMBO_TINY_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_COMBO_TINY_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_COMBO_TINY_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_COMBO_TINY_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + " " + ITEM_WIDTH_TINY.getValue();
        } else if (width <= 125) {
            inputStyle = INPUT_COMBO_SMALL_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_COMBO_SMALL_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_COMBO_SMALL_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_COMBO_SMALL_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + " " + ITEM_WIDTH_SMALL.getValue();
        } else if (width <= 175) {
            inputStyle = INPUT_COMBO_MEDIUM_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_COMBO_MEDIUM_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_COMBO_MEDIUM_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_COMBO_MEDIUM_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + String.valueOf(' ') + String.valueOf((Object)ITEM_WIDTH_MEDIUM);
        } else {
            inputStyle = INPUT_COMBO_ENABLED.getValue() + " " + ITEM_STATE_ENABLED.getValue();
            if (state == 4) {
                inputStyle = INPUT_COMBO_ERROR.getValue() + " " + ITEM_STATE_ERROR.getValue();
            } else if (state == 2) {
                inputStyle = INPUT_COMBO_WARNING.getValue() + " " + ITEM_STATE_WARNING.getValue();
            } else if (state == 12) {
                inputStyle = INPUT_COMBO_DISABLED.getValue() + " " + ITEM_STATE_DISABLED.getValue();
            }
            inputStyle = inputStyle + " " + ITEM_WIDTH_NORMAL.getValue();
        }
        if (hasHelp) {
            inputStyle = inputStyle + " " + OPEN_HELP.getValue();
        }
        return type + " " + inputStyle;
    }

    public static String getButtonStyle(WizardDisplayInfoDTO.ButtonDTO buttonItem) {
        String buttonStyle = ITEM_TYPE_BUTTON.getValue() + " " + StyleRegistry.getStateStyle(buttonItem.getState());
        if (buttonItem.getWidth() != null) {
            buttonStyle = buttonStyle + " " + StyleRegistry.getWidthStyle(buttonItem.getWidth());
        }
        if (buttonItem.getStyle() != null) {
            buttonStyle = buttonStyle + " " + buttonItem.getStyle();
        }
        if (buttonItem.getStyleClass() != null) {
            buttonStyle = buttonStyle + " " + buttonItem.getStyleClass();
        }
        return buttonStyle;
    }

    public static String getLabelStyle(WizardDisplayInfoDTO.LabelItemDTO labelItem, int state) {
        StringBuilder labelStyle = new StringBuilder(ITEM_TYPE_LABEL.getValue());
        labelStyle.append(' ');
        labelStyle.append(StyleRegistry.getStateStyle(state));
        labelStyle.append(' ');
        labelStyle.append(StyleRegistry.getWidthStyle(labelItem.getWidth()));
        labelStyle.append(' ');
        if (labelItem.getAlign() != null) {
            labelStyle.append(StyleRegistry.getAlignmentStyle(labelItem.getAlign()));
        } else {
            labelStyle.append(LABEL_DEFAULT_ALIGNMENT.getValue());
        }
        if (labelItem.getStyleClass() != null) {
            labelStyle.append(' ');
            labelStyle.append(labelItem.getStyleClass());
        }
        return labelStyle.toString();
    }

    public static String getTextareaStyle(WizardDisplayInfoDTO.ItemItemDTO textarea, int state, boolean hasHelp) {
        StringBuilder textareaStyle = new StringBuilder(ITEM_TYPE_TEXTAREA.getValue());
        textareaStyle.append(' ');
        textareaStyle.append(StyleRegistry.getStateStyle(state));
        if (textarea.getStyleClass() != null && !textarea.getStyleClass().isEmpty()) {
            textareaStyle.append(' ');
            textareaStyle.append(textarea.getStyleClass());
        }
        if (hasHelp) {
            textareaStyle.append(' ');
            textareaStyle.append(OPEN_HELP.getValue());
        }
        return textareaStyle.toString();
    }

    public static String getOutputStyle(WizardDisplayInfoDTO.ItemItemDTO itemItem, boolean hasHelp) {
        StringBuilder outputStyle = new StringBuilder(ITEM_TYPE_OUTPUT.getValue());
        outputStyle.append(' ');
        outputStyle.append(StyleRegistry.getStateStyle(itemItem.getState()));
        outputStyle.append(' ');
        outputStyle.append(StyleRegistry.getWidthStyle(itemItem.getWidth()));
        if (itemItem.getType() == 4) {
            outputStyle.append(' ');
            outputStyle.append(ITEM_HEIGHT_TEXTAREA.getValue());
        }
        if (itemItem.getAlign() != null) {
            outputStyle.append(' ');
            outputStyle.append(StyleRegistry.getAlignmentStyle(itemItem.getAlign()));
        }
        if (hasHelp) {
            outputStyle.append(' ');
            outputStyle.append(OPEN_HELP.getValue());
        }
        if (itemItem.getStyleClass() != null && !itemItem.getStyleClass().trim().isEmpty()) {
            outputStyle.append(' ');
            outputStyle.append(itemItem.getStyleClass());
        }
        return outputStyle.toString();
    }

    public static String getRadioGroupStyle(WizardDisplayInfoDTO.ItemItemDTO itemItem, boolean hasHelp) {
        StringBuilder radioStyle = new StringBuilder();
        radioStyle.append(StyleRegistry.getNonTextInputStyle(itemItem.getState(), itemItem.getWidth(), ITEM_TYPE_RADIO.getValue(), hasHelp));
        if (itemItem.getStyleClass() != null && !itemItem.getStyleClass().isEmpty()) {
            radioStyle.append(' ');
            radioStyle.append(itemItem.getStyleClass());
        }
        return radioStyle.toString();
    }

    public static @NonNull String getStateIndicatorStyle( @NonNull WizardDisplayInfoDTO.StateIndicatorItemDTO stateIndicator) {
        String style = ITEM_TYPE_STATE_INDICATOR.getValue() + " " + StyleRegistry.getStateStyle(stateIndicator.getState()) + " " + StyleRegistry.getWidthStyle(stateIndicator.getWidth());
        return style;
    }

    public static String getTableHeaderStyle(int state) {
        if (11 == state) {
            return TABLE_CELL_HEADER_TRANSPARENT.getValue();
        }
        return TABLE_CELL_HEADER.getValue();
    }

    public static String getTableHeaderShorthelpStyle(int state) {
        if (11 == state) {
            return TABLE_CELL_HEADER_SHORTHELP_TRANSPARENT.getValue();
        }
        return TABLE_CELL_HEADER_SHORTHELP.getValue();
    }

    public static String getTableContentStyle(int state) {
        if (11 == state) {
            return TABLE_CELL_TRANSPARENT.getValue();
        }
        return TABLE_CELL_ENABLED.getValue();
    }

    public static String getTableSpacerStyle(int state) {
        if (11 == state) {
            return TABLE_SCROLLER_TRANSPARENT.getValue();
        }
        return TABLE_SCROLLER_ENABLED.getValue();
    }

    public static String getTextNormalStyle(int state) {
        if (12 == state) {
            return TABLE_CELL_DISABLED.getValue();
        }
        if (11 == state) {
            return TEXT_NORMAL_DISABLED.getValue();
        }
        return TEXT_NORMAL.getValue();
    }

    public static String getRowContentStyle(WizardDisplayInfoDTO.RowContent elem, int rowState) {
        if (elem instanceof WizardDisplayInfoDTO.ItemItemDTO) {
            WizardDisplayInfoDTO.ItemItemDTO itemDTO = (WizardDisplayInfoDTO.ItemItemDTO)elem;
            if (11 == itemDTO.getState()) {
                return TABLE_CELL_TRANSPARENT.getValue();
            }
            if (itemDTO.getReadonly()) {
                return TABLE_CELL_READONLY.getValue();
            }
        } else if (elem instanceof WizardDisplayInfoDTO.LabelItemDTO) {
            if (4 == rowState) {
                return TABLE_CELL_ERROR.getValue();
            }
            if (2 == rowState) {
                return TABLE_CELL_WARNING.getValue();
            }
        }
        return TABLE_CELL_ENABLED.getValue();
    }

    public static String getColDefStyle(WizardDisplayInfoDTO.ColDefItemDTO coldef) {
        if (coldef.isWidthUndefined()) {
            return TABLE_COLUMN_UNDEFINED.getValue();
        }
        int width = Integer.parseInt(coldef.getWidth());
        if (width <= 15) {
            return TABLE_COLUMN_ICON.getValue();
        }
        if (width <= 75) {
            return TABLE_COLUMN_50.getValue();
        }
        if (width <= 125) {
            return TABLE_COLUMN_100.getValue();
        }
        if (width <= 175) {
            return TABLE_COLUMN_150.getValue();
        }
        return TABLE_COLUMN_200.getValue();
    }

    public static String getNavigationPfeilStyle(int level) {
        if (level > 1) {
            return NAVIGATION_PFEIL_LEVEL_2.getValue();
        }
        return NAVIGATION_PFEIL_LEVEL_1.getValue();
    }

    public static String getNavigationStateStyle(int level) {
        if (level > 1) {
            return NAVIGATION_STATE.getValue() + " " + NAVIGATION_STATE_LEVEL_2.getValue();
        }
        return NAVIGATION_STATE.getValue() + " " + NAVIGATION_STATE_LEVEL_1.getValue();
    }

    public static String getNavigationTextStyle(int level, boolean isTableEntry, WizardDisplayInfoDTO.NavigationsItemDTO item) {
        StringBuilder builder = new StringBuilder();
        if (level > 1) {
            builder.append(NAVIGATION_TEXT_LEVEL_2.getValue()).append(' ');
        } else {
            builder.append(NAVIGATION_TEXT_LEVEL_1.getValue()).append(' ');
        }
        if (item.getState() > 10 || isTableEntry && !item.isSelected()) {
            builder.append(NAVIGATION_TEXT_DISABLED.getValue()).append(' ');
        } else if (!item.isSelected()) {
            builder.append(NAVIGATION_TEXT_ENABLED.getValue()).append(' ');
        } else {
            builder.append(NAVIGATION_TEXT_SELECTED.getValue()).append(' ');
        }
        if (item.getChildren() != null && !item.getChildren().isEmpty()) {
            builder.append(NAVIGATION_TEXT_ACTIVE.getValue());
        }
        return builder.toString();
    }

    public static String getTableHeaderStatusStyle(int state) {
        if (state > 10) {
            return TABLE_COLUMN_STATE_TRANSPARENT.getValue();
        }
        return TABLE_COLUMN_STATE.getValue();
    }

    public static String getTableHeaderIconStyle(int state, boolean inlineHelp) {
        Object style = TABLE_COLUMN_ICON.getValue();
        if (state > 10) {
            style = TABLE_COLUMN_ICON_TRANSPARENT.getValue();
        }
        if (inlineHelp) {
            style = (String)style + " " + OPEN_HELP.getValue();
        }
        return style;
    }

    public static String getStateStyle(int state) {
        String stateStyle = ITEM_STATE_ENABLED.getValue();
        if (state == 4) {
            stateStyle = ITEM_STATE_ERROR.getValue();
        } else if (state == 2) {
            stateStyle = ITEM_STATE_WARNING.getValue();
        } else if (state == 11) {
            stateStyle = ITEM_STATE_TRANSPARENT.getValue();
        } else if (state == 12) {
            stateStyle = ITEM_STATE_DISABLED.getValue();
        } else if (state == 3) {
            stateStyle = ITEM_STATE_MISSINGVALUE.getValue();
        }
        return stateStyle;
    }

    public static String getWidthStyle(int width) {
        String widthStyle = ITEM_WIDTH_ALL.getValue();
        if (width == 0) {
            widthStyle = ITEM_WIDTH_UNDEFINED.getValue();
        } else if (width <= 15) {
            widthStyle = ITEM_WIDTH_NANO.getValue();
        } else if (width <= 75) {
            widthStyle = ITEM_WIDTH_TINY.getValue();
        } else if (width <= 125) {
            widthStyle = ITEM_WIDTH_SMALL.getValue();
        } else if (width <= 175) {
            widthStyle = ITEM_WIDTH_MEDIUM.getValue();
        } else if (width <= 225) {
            widthStyle = ITEM_WIDTH_NORMAL.getValue();
        }
        return widthStyle;
    }

    public static String getAlignmentStyle(String align) {
        String alignStyle = "";
        if (align != null) {
            switch (align) {
                case "right": {
                    alignStyle = ALIGNMENT_RIGHT.getValue();
                    break;
                }
                case "left": {
                    alignStyle = ALIGNMENT_LEFT.getValue();
                    break;
                }
                case "center": {
                    alignStyle = ALIGNMENT_CENTER.getValue();
                }
            }
        }
        return alignStyle;
    }

    public static String getLinkStyle(WizardDisplayInfoDTO.LinkItemDTO linkItem) {
        String uri;
        StringBuilder linkStyle = new StringBuilder();
        linkStyle.append(ITEM_TYPE_LINK.getValue());
        linkStyle.append(' ');
        linkStyle.append(StyleRegistry.getStateStyle(linkItem.getState()));
        if (linkItem.getStyleClass() != null && !linkItem.getStyleClass().isEmpty()) {
            linkStyle.append(' ');
            linkStyle.append(linkItem.getStyleClass());
        }
        if ((uri = linkItem.getUri()).contains(".pdf")) {
            linkStyle.append(' ');
            linkStyle.append(LINK_STYLE_PDF.getValue());
        } else if (uri.contains(".xls") || uri.contains(".xlsx") || uri.contains(".ods")) {
            linkStyle.append(' ');
            linkStyle.append(LINK_STYLE_XLS.getValue());
        } else if (uri.contains(".doc") || uri.contains(".docx") || uri.contains(".odt")) {
            linkStyle.append(' ');
            linkStyle.append(LINK_STYLE_DOC.getValue());
        } else if (uri.contains(".txt")) {
            linkStyle.append(' ');
            linkStyle.append(LINK_STYLE_TXT.getValue());
        } else if (uri.contains("http")) {
            linkStyle.append(' ');
            linkStyle.append(LINK_STYLE_EXTERNAL.getValue());
        } else if (uri.contains(".tax")) {
            linkStyle.append(' ');
            linkStyle.append(LINK_STYLE_TAX.getValue());
        } else {
            linkStyle.append(' ');
            linkStyle.append(LINK_STYLE_OTHER.getValue());
        }
        return linkStyle.toString();
    }

    public static String getFileDetailsStyle(WizardDisplayInfoDTO.FileDetailsItemDTO fileDetailsItem) {
        StringBuilder styles = new StringBuilder();
        styles.append(ITEM_TYPE_FILE_DETAILS.getValue());
        styles.append(' ');
        styles.append(StyleRegistry.getStateStyle(fileDetailsItem.getState()));
        styles.append(' ');
        styles.append(StyleRegistry.getWidthStyle(fileDetailsItem.getWidth()));
        if (fileDetailsItem.getStyleClass() != null) {
            styles.append(' ');
            styles.append(fileDetailsItem.getStyleClass());
        }
        return styles.toString().trim();
    }

    static {
        $VALUES = new StyleRegistry[]{ITEM_TYPE_OUTPUT, ITEM_TYPE_INPUT, ITEM_TYPE_COMBO, ITEM_TYPE_RADIO, ITEM_TYPE_CHECKBOX, ITEM_TYPE_LABEL, ITEM_TYPE_BUTTON, ITEM_TYPE_IMAGE_BUTTON, ITEM_TYPE_TEXTAREA, ITEM_TYPE_LINK, ITEM_TYPE_FILE_DETAILS, ITEM_TYPE_STATE_INDICATOR, ITEM_TYPE_INPUT_DATE, ITEM_TYPE_INPUT_DAYMONTH, ITEM_STATE_ENABLED, ITEM_STATE_MISSINGVALUE, ITEM_STATE_WARNING, ITEM_STATE_ERROR, ITEM_STATE_TRANSPARENT, ITEM_STATE_READONLY, ITEM_STATE_DISABLED, ITEM_WIDTH_UNDEFINED, ITEM_WIDTH_ALL, ITEM_WIDTH_NORMAL, ITEM_WIDTH_MEDIUM, ITEM_WIDTH_SMALL, ITEM_WIDTH_TINY, ITEM_WIDTH_NANO, ALIGNMENT_RIGHT, ALIGNMENT_LEFT, ALIGNMENT_CENTER, ITEM_HEIGHT_TEXTAREA, INPUT_TEXT_ENABLED, INPUT_TEXT_DISABLED, INPUT_TEXT_ERROR, INPUT_TEXT_WARNING, INPUT_TEXT_MEDIUM_ENABLED, INPUT_TEXT_MEDIUM_DISABLED, INPUT_TEXT_MEDIUM_ERROR, INPUT_TEXT_MEDIUM_WARNING, INPUT_TEXT_SMALL_ENABLED, INPUT_TEXT_SMALL_DISABLED, INPUT_TEXT_SMALL_ERROR, INPUT_TEXT_SMALL_WARNING, INPUT_TEXT_TINY_ENABLED, INPUT_TEXT_TINY_DISABLED, INPUT_TEXT_TINY_ERROR, INPUT_TEXT_TINY_WARNING, INPUT_COMBO_ENABLED, INPUT_COMBO_DISABLED, INPUT_COMBO_ERROR, INPUT_COMBO_WARNING, INPUT_COMBO_MEDIUM_ENABLED, INPUT_COMBO_MEDIUM_DISABLED, INPUT_COMBO_MEDIUM_ERROR, INPUT_COMBO_MEDIUM_WARNING, INPUT_COMBO_SMALL_ENABLED, INPUT_COMBO_SMALL_DISABLED, INPUT_COMBO_SMALL_ERROR, INPUT_COMBO_SMALL_WARNING, INPUT_COMBO_TINY_ENABLED, INPUT_COMBO_TINY_DISABLED, INPUT_COMBO_TINY_ERROR, INPUT_COMBO_TINY_WARNING, OUTPUT_TEXT, OUTPUT_TEXT_DISABLED, OUTPUT_TEXT_READONLY, OUTPUT_TITEL, OUTPUT_TITLE_DISABLED, COMMAND_LINK, BUTTON, BUTTON_DISABLED, BUTTON_NEW_TABLE_ENTRY, BUTTON_ADD_ROW, BUTTON_STATUS_FILTER, SECTION, TMO_TABLE, TABLE_FILTER_INPUT, TABLE_RADIOBUTTONS, TABLE_SECTIONITEM, TABLE_SECTIONITEM_SORTICON, TABLE_TABLEITEM, TABLE_READONLY, TABLE_NAVIGATION, TABLE_WIZARDPRINT, TABLE_HEADER_ICON, TABLE_HEADER_ICON_TRANSPARENT, TABLE_HEADER, TABLE_HEADER_TRANSPARENT, TABLE_COLUMN_50, TABLE_COLUMN_100, TABLE_COLUMN_150, TABLE_COLUMN_200, TABLE_COLUMN_ICON, TABLE_COLUMN_ICON_TRANSPARENT, TABLE_COLUMN_STATE, TABLE_COLUMN_STATE_TRANSPARENT, TABLE_COLUMN_STATE_DISABLED, TABLE_COLUMN_UNDEFINED, TABLE_COLUMN_SPACER, TABLE_COLUMN_INVISIBLE, TABLE_SCROLLER_ENABLED, TABLE_SCROLLER_TRANSPARENT, TABLE_COLUMN_NAV_PFEIL, TABLE_COLUMN_NAV_STATE, TABLE_COLUMN_NAV_TEXT, TABLE_COLUMN_NAV_SPACER, NAVIGATION_SPAVER, NAVIGATION_FUNCTION_MENU, NAVIGATION_FUNCTION, NAVIGATION_FUNCTION_ACTIVE, NAVIGATION_FUNCTION_OPEN, NAVIGATION_FUNCTION_DISABLED, NAVIGATION_FUNCTION_ENABLED, TABLE_ROW_SPACER, TABLE_ROW_STATE_DISABLED, TABLE_NO_ENTRY_LBL, TABLE_CELL_HEADER_SHORTHELP, TABLE_CELL_HEADER_SHORTHELP_TRANSPARENT, TABLE_CELL_SHORTHELP, TABLE_CELL_ENABLED, TABLE_CELL_DISABLED, TABLE_CELL_TRANSPARENT, TABLE_CELL_READONLY, TABLE_CELL_HEADER, TABLE_CELL_HEADER_TRANSPARENT, TABLE_CELL_ERROR, TABLE_CELL_WARNING, TABLE_CELL_SPACER, TABLE_CELL_EDIT, TABLE_CELL_DELETE, TABLE_CELL_STATUS, TABLE_CELL_PRINT_ROW, NAVIGATION_MODEL_NAVIGATION, NAVIGATION_LINK, NAVIGATION_LINK_DISABLED, NAVIGATION_LINK_TEXT, NAVIGATION_PFEIL_LEVEL_1, NAVIGATION_PFEIL_LEVEL_2, NAVIGATION_STATE, NAVIGATION_STATE_LEVEL_1, NAVIGATION_STATE_LEVEL_2, NAVIGATION_STATE_ICON, NAVIGATION_TEXT_LEVEL_1, NAVIGATION_TEXT_LEVEL_2, NAVIGATION_TEXT_ACTIVE, NAVIGATION_TEXT_DISABLED, NAVIGATION_TEXT_ENABLED, NAVIGATION_TEXT_SELECTED, NAVIGATION_ITEM_ACTIVE, NAVIGATION_ITEM_OPEN, NAVIGATION_ITEM_DISABLED, NAVIGATION_ITEM_ENABLED, SPACER_LEFT, SPACER_TOP_LEFT, TEXT_NORMAL, TEXT_NORMAL_DISABLED, LABEL_DEFAULT_ALIGNMENT, LABEL_HELP_TEXT, LABEL_ENABLED, LABEL_ERROR, LABEL_WARNING, LABEL_DISABLED, OPEN_HELP, SHORTHELP_LINK, BREADCRUMB_ENABLED, BREADCRUMB_DISABLED, BREADCRUMB_CURRENT, BREADCRUMB_DELIMITER, HIDDEN, READONLY, LINK_STYLE_EXTERNAL, LINK_STYLE_PDF, LINK_STYLE_XLS, LINK_STYLE_DOC, LINK_STYLE_TXT, LINK_STYLE_TAX, LINK_STYLE_OTHER};
    }
}

