/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardItemPrinter;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionPrinter
extends WizardItemPrinter<WizardDisplayInfoDTO.SectionItemDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(SectionPrinter.class);
    private WizardDisplayInfoDTO.SectionItemDTO section = null;

    @Override
    protected void initalize(WizardDisplayInfoDTO.SectionItemDTO item) {
        this.section = item;
    }

    @Override
    public void print(float xOffset, float yOffset) throws FormRendererException {
        List<WizardDisplayInfoDTO.RowItemDTO> rows;
        if (12 == this.section.getState()) {
            return;
        }
        int nbrCols = this.section.getColdefs().size();
        PdfPTable table = new PdfPTable(nbrCols);
        table.setWidthPercentage(100.0f);
        table.setHeaderRows(1);
        table.setSpacingAfter(18.0f);
        if (this.section.getHeader() != null) {
            String translatedText;
            String key = this.section.getHeader();
            List<WizardDisplayInfoDTO.LabelAddOnDTO> list = this.section.getHeaderAddOns();
            try {
                translatedText = list != null ? this.getGlobalConverterContext().getLocalizationHelper().translate(key, list.toArray()) : this.getGlobalConverterContext().getLocalizationHelper().translate(key, new Object[0]);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                LOG.warn("could not translate: {}", (Object)key, (Object)e);
                translatedText = key;
            }
            this.addTableHeader(table, translatedText, nbrCols);
        }
        try {
            int[] columns = this.getGridArray(this.section.getColdefs());
            table.setWidths(columns);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
        if (this.section.getHeaders() != null && !this.section.getHeaders().isEmpty()) {
            Iterator<WizardDisplayInfoDTO.HeaderItemDTO> e = this.section.getHeaders().iterator();
            while (e.hasNext()) {
                String translatedText;
                WizardDisplayInfoDTO.HeaderItemDTO headerItemDTO;
                WizardDisplayInfoDTO.HeaderItemDTO header = headerItemDTO = e.next();
                String key = header.getName();
                try {
                    translatedText = header.getText(this.getGlobalConverterContext());
                }
                catch (FormRendererException e2) {
                    LOG.error("could not retrieve header-addons for header {}", (Object)key, (Object)e2);
                    translatedText = key;
                }
                this.addTableHeader(table, translatedText, header.getColspan());
            }
        }
        if ((rows = this.section.getRows()) != null && !rows.isEmpty()) {
            for (WizardDisplayInfoDTO.RowItemDTO rowItemDTO : rows) {
                if (12 == rowItemDTO.getState()) continue;
                this.printRow(table, rowItemDTO);
            }
        }
        try {
            this.getDocument().add((Element)table);
        }
        catch (DocumentException documentException) {
            throw new FormRendererException("can't print section", documentException);
        }
    }

    private void printRow(PdfPTable table, WizardDisplayInfoDTO.RowItemDTO rowItemDTO) throws FormRendererException {
        List<WizardDisplayInfoDTO.AbstractItemDTO> cols = rowItemDTO.getCols();
        if (cols != null && !cols.isEmpty()) {
            for (WizardDisplayInfoDTO.AbstractItemDTO element : cols) {
                if (element instanceof WizardDisplayInfoDTO.LabelItemDTO) {
                    WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)element;
                    this.addTableCell(table, this.getText(labelItemDTO), labelItemDTO.getColspan(), labelItemDTO.getAlign());
                    continue;
                }
                if (element instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                    WizardDisplayInfoDTO.ItemItemDTO itemItemDTO = (WizardDisplayInfoDTO.ItemItemDTO)element;
                    String s = this.getText(itemItemDTO);
                    this.addTableCell(table, s, itemItemDTO.getColspan(), itemItemDTO.getAlign());
                    continue;
                }
                LOG.warn("undefined section child type: {}", element.getClass());
            }
        } else {
            this.addTableCell(table, " ", this.section.getColdefs().size(), "");
        }
    }
}

