/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform;

import ch.dvbern.tax.common.engine.LMK;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PdfTableMerge {
    private final @NonNull LMK baseTable;
    private final @NonNull Map<LMK, Map<LMK, LMK>> columMapping;

    public PdfTableMerge(@NonNull LMK baseTable, @NonNull Map<LMK, Map<LMK, LMK>> columMapping) {
        this.baseTable = Objects.requireNonNull(baseTable);
        this.columMapping = Collections.unmodifiableMap(columMapping);
    }

    private PdfTableMerge(Builder builder) {
        this.baseTable = builder.baseTable;
        Objects.requireNonNull(this.baseTable);
        this.columMapping = Objects.requireNonNull(builder.columMapping);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.baseTable).append(this.columMapping.keySet()).build();
    }

    public @NonNull LMK getBaseTable() {
        return this.baseTable;
    }

    public static @NonNull Builder newBuilder(@NonNull LMK baseTable) {
        return new Builder(baseTable);
    }

    public static @NonNull Builder newBuilder(@NonNull String baseTableLMK) {
        return PdfTableMerge.newBuilder(LMK.parse(baseTableLMK));
    }

    public @NonNull Map<LMK, Map<LMK, LMK>> getColumMapping() {
        return this.columMapping;
    }

    public static final class ColumnMappingBuilder {
        private final @NonNull Builder builder;
        private final @NonNull LMK mappedTable;
        private final @NonNull Map<LMK, LMK> columnMapping = new HashMap<LMK, LMK>();

        public ColumnMappingBuilder(@NonNull Builder builder, @NonNull LMK mappedTable) {
            this.builder = Objects.requireNonNull(builder);
            this.mappedTable = Objects.requireNonNull(mappedTable);
        }

        public ColumnMappingBuilder withMapping(@NonNull LMK baseColumn, @NonNull LMK mappedColumn) {
            Objects.requireNonNull(baseColumn);
            Objects.requireNonNull(mappedColumn);
            if (!this.mappedTable.contains(mappedColumn)) {
                throw new IllegalArgumentException("mapped table does not contain mapped column: " + String.valueOf(this.mappedTable) + " -> " + String.valueOf(mappedColumn));
            }
            if (!this.builder.baseTable.contains(baseColumn)) {
                throw new IllegalArgumentException("base table does not contain base column: " + String.valueOf(this.builder.baseTable) + " -> " + String.valueOf(baseColumn));
            }
            this.columnMapping.put(baseColumn, mappedColumn);
            return this;
        }

        public ColumnMappingBuilder withMapping(@NonNull String baseColumnLMK, @NonNull String mappedColumnLMK) {
            return this.withMapping(LMK.parse(baseColumnLMK), LMK.parse(mappedColumnLMK));
        }

        public Builder endTable() {
            return this.builder.withColumMapping(this.mappedTable, this.columnMapping);
        }
    }

    public static final class Builder {
        private final @NonNull LMK baseTable;
        private final @NonNull Map<LMK, Map<LMK, LMK>> columMapping = new HashMap<LMK, Map<LMK, LMK>>();

        public Builder(@NonNull LMK baseTable) {
            this.baseTable = Objects.requireNonNull(baseTable);
        }

        private @NonNull Builder withColumMapping(@NonNull LMK mappedTable, @NonNull Map<LMK, LMK> columnMapping) {
            this.columMapping.put(mappedTable, Collections.unmodifiableMap(columnMapping));
            return this;
        }

        public @NonNull ColumnMappingBuilder beginTable(@NonNull LMK mappedTable) {
            return new ColumnMappingBuilder(this, mappedTable);
        }

        public @NonNull ColumnMappingBuilder beginTable(@NonNull String mappedTableLMK) {
            return this.beginTable(LMK.parse(mappedTableLMK));
        }

        public @NonNull PdfTableMerge build() {
            return new PdfTableMerge(this);
        }

        public @NonNull List<PdfTableMerge> buildAsList() {
            return Collections.singletonList(this.build());
        }
    }
}

