/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform;

import ch.dvbern.lib.pdfforms.pagenumbering.PageNumberingAlgo;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.Resolver;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PdfPrinterInput {
    private static final String DEFAULT_BOOLEAN_TRUE_REPRESENTATION = "X";
    private static final String DEFAULT_BOOLEAN_FALSE_REPRESENTATION = "";
    private static final String DEFAULT_DATE_SEPARATOR = ".";
    private static final String DEFAULT_TIME_SEPARATOR = ":";
    private static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";
    private static final String DEFAULT_DATETIME_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private final @NonNull Map<String, ModelItemDTO> dataModelMap;
    private final @NonNull Map<String, LogicModelItem> logicModelItems;
    private final @NonNull List<Resolver> resolvers;
    private final @NonNull List<PdfForm> pdfForms;
    private final @NonNull LocalizationHelper localizationHelper;
    private final @NonNull PageNumberingAlgo pageNumberingAlgo;
    private final @NonNull FormRendererConfiguration rendererConfiguration;
    private final @NonNull String booleanTrueText = "X";
    private final @NonNull String booleanFalseText = "";
    private final @NonNull String dateFormat = "dd.MM.yyyy";
    private final @NonNull String dateTimeFormat = "dd.MM.yyyy HH:mm:ss";

    public PdfPrinterInput(@NonNull Map<String, ModelItemDTO> dataModelMap, @NonNull Map<String, LogicModelItem> logicModelItems, @NonNull Collection<PdfForm> pdfForms, @NonNull LocalizationHelper localizationHelper, @NonNull PageNumberingAlgo pageNumberingAlgo, @NonNull List<Resolver> resolvers, @NonNull FormRendererConfiguration rendererConfiguration) {
        this.dataModelMap = Collections.unmodifiableMap(dataModelMap);
        this.logicModelItems = Collections.unmodifiableMap(logicModelItems);
        this.pdfForms = Collections.unmodifiableList(new ArrayList<PdfForm>(pdfForms));
        this.localizationHelper = Objects.requireNonNull(localizationHelper);
        this.pageNumberingAlgo = Objects.requireNonNull(pageNumberingAlgo);
        this.rendererConfiguration = Objects.requireNonNull(rendererConfiguration);
        this.resolvers = Collections.unmodifiableList(new ArrayList<Resolver>(resolvers));
    }

    public @NonNull PdfPrinterInput withPdfForms(@NonNull Collection<PdfForm> forms) {
        return new PdfPrinterInput(this.dataModelMap, this.logicModelItems, forms, this.localizationHelper, this.pageNumberingAlgo, this.resolvers, this.rendererConfiguration);
    }

    public @NonNull Map<String, ModelItemDTO> getDataModelMap() {
        return this.dataModelMap;
    }

    public @NonNull Map<String, LogicModelItem> getLogicModelItems() {
        return this.logicModelItems;
    }

    public @NonNull List<PdfForm> getPdfForms() {
        return this.pdfForms;
    }

    public @NonNull LocalizationHelper getLocalizationHelper() {
        return this.localizationHelper;
    }

    public @NonNull List<Resolver> getResolvers() {
        return this.resolvers;
    }

    public @NonNull String getBooleanTrueText() {
        return DEFAULT_BOOLEAN_TRUE_REPRESENTATION;
    }

    public @NonNull String getBooleanFalseText() {
        return DEFAULT_BOOLEAN_FALSE_REPRESENTATION;
    }

    public @NonNull String getDateFormat() {
        return DEFAULT_DATE_FORMAT;
    }

    public @NonNull String getDateTimeFormat() {
        return DEFAULT_DATETIME_FORMAT;
    }

    public @NonNull PageNumberingAlgo getPageNumberingAlgo() {
        return this.pageNumberingAlgo;
    }

    public @NonNull FormRendererConfiguration getRendererConfiguration() {
        return this.rendererConfiguration;
    }
}

