/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.FormRendererUtil;
import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.io.IOException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ExpertItemPrinter<T extends ExpertDisplayInfoDTO.ItemDTO>
implements ItemPrinter<T> {
    private ExpertDisplayInfoDTO.ItemDTO item = null;
    private DocumentContext documentContext = null;

    @Override
    public final void initalize(@NonNull DocumentContext documentContext, @NonNull T item) {
        this.documentContext = Objects.requireNonNull(documentContext);
        this.item = (ExpertDisplayInfoDTO.ItemDTO)Objects.requireNonNull(item);
        this.initalize(item);
    }

    protected abstract void initalize(@NonNull T var1);

    @Override
    public final void print() throws FormRendererException {
        this.print(0.0f, 0.0f);
    }

    @Override
    public final void print(float xOffset, float yOffset) throws FormRendererException {
        if (this.item.getBgColor() != null) {
            float llx = this.calcLowerLeftX(this.item, xOffset);
            float lly = this.calcLowerLeftY(this.item, yOffset);
            float urx = this.calcUpperRightX(this.item, xOffset);
            float ury = this.calcUpperRightY(this.item, yOffset);
            Rectangle r = new Rectangle(llx, lly, urx, ury);
            r.setBackgroundColor(ExpertItemPrinter.awtColor(this.item.getBgColor()));
            this.getDirectContent().rectangle(r);
        }
        this.printInternal(xOffset, yOffset);
    }

    protected abstract void printInternal(float var1, float var2) throws FormRendererException;

    protected float calcLowerLeftX(ExpertDisplayInfoDTO.ItemDTO item, float xOffset) {
        return Math.max((float)item.getX() + xOffset, 0.0f);
    }

    protected float calcLowerLeftY(ExpertDisplayInfoDTO.ItemDTO item, float yOffset) {
        return Math.max(this.getPageSize().getHeight() - (float)item.getHeight() - ((float)item.getY() + yOffset), 0.0f);
    }

    protected float calcUpperRightX(ExpertDisplayInfoDTO.ItemDTO item, float xOffset) {
        return Math.max((float)item.getX() + xOffset + (float)item.getWidth(), 0.0f);
    }

    protected float calcUpperRightY(ExpertDisplayInfoDTO.ItemDTO item, float yOffset) {
        return Math.max(this.getPageSize().getHeight() - ((float)item.getY() + yOffset), 0.0f);
    }

    protected void printText(String text, float llx, float lly, float urx, float ury, FontDTO font, int align) throws FormRendererException {
        this.printText(this.getDirectContent(), text, llx, lly, urx, ury, font, align);
    }

    protected void printText(PdfContentByte cb, String text, float llx, float lly, float urx, float ury, FontDTO font, int align) throws FormRendererException {
        try {
            Font itextFont = this.itextFont(font);
            float leading = font.getLeading();
            float height = ury - lly;
            if (height < leading) {
                lly -= leading - height;
            }
            Phrase textPhrase = new Phrase(leading, text, itextFont);
            ColumnText ct = new ColumnText(cb);
            cb.setCharacterSpacing(font.getCharSpace());
            ct.setSimpleColumn(textPhrase, llx, lly, urx -= font.getCharSpace() * (float)text.length(), ury, leading, ExpertItemPrinter.itextAlignment(align));
            ct.go();
            cb.setCharacterSpacing(0.0f);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print text", e);
        }
    }

    protected Font itextFont(FontDTO font) throws FormRendererException {
        try {
            String name = this.documentContext.isUseBoldFonts() ? "Helvetica-Bold" : font.getName();
            BaseFont bf = BaseFont.createFont((String)name, (String)"Cp1252", (boolean)true);
            int style = ExpertItemPrinter.itextStyle(font.getStyle());
            float size = font.getSize();
            if (this.documentContext.isUseBoldFonts()) {
                style |= 1;
            }
            Font f = new Font(bf, size, style);
            f.setColor(ExpertItemPrinter.awtColor(font.getColor()));
            return f;
        }
        catch (DocumentException | IOException e) {
            throw new FormRendererException("can't create font", e);
        }
    }

    protected static Color awtColor(ColorDTO color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static int itextStyle(int style) {
        int iTextStyle = 0;
        if ((style & 1) != 0) {
            iTextStyle |= 1;
        }
        if ((style & 2) != 0) {
            iTextStyle |= 2;
        }
        if ((style & 4) != 0) {
            iTextStyle |= 4;
        }
        return iTextStyle;
    }

    protected static int itextAlignment(int align) {
        int iTextAlign;
        switch (align) {
            case 1: {
                iTextAlign = 1;
                break;
            }
            case 2: {
                iTextAlign = 2;
                break;
            }
            default: {
                iTextAlign = 0;
            }
        }
        return iTextAlign;
    }

    protected void printValuePosition(ExpertDisplayInfoDTO.ValueItemDTO item, float xOffset, float yOffset) throws FormRendererException {
        ExpertDisplayInfoDTO.ValuePositionDTO pos;
        Object value;
        Object object = value = item.getModelItem() == null ? null : item.getModelItem().getValue();
        if (value != null && (pos = item.getValuePositions().get(value.toString())) != null) {
            float llx = this.calcLowerLeftX(item, xOffset) + (float)pos.getX() + 2.0f;
            float lly = this.calcLowerLeftY(item, yOffset) + (float)item.getHeight() - (float)pos.getY() - (float)pos.getHeight();
            float urx = llx + (float)pos.getWidth();
            float ury = lly + (float)pos.getHeight();
            this.printText("X", llx, lly, urx, ury, item.getFont(), 0);
        }
    }

    protected @Nullable String getText(ExpertDisplayInfoDTO.TextItemDTO item) {
        return FormRendererUtil.getText(item, this.getGlobalConverterContext());
    }

    protected @Nullable String getText(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, ExpertDisplayInfoDTO.TableDTO.CellDTO cell) {
        return FormRendererUtil.getText(col, cell, this.getGlobalConverterContext());
    }

    protected @Nullable String getText(ExpertDisplayInfoDTO.ListDTO.RowDTO row) {
        return FormRendererUtil.getText(row, this.getGlobalConverterContext());
    }

    protected  @NonNull AbstractConverter.ConverterContext getGlobalConverterContext() {
        return this.documentContext.getGlobalConverterContext();
    }

    protected PdfContentByte getDirectContent() {
        return this.documentContext.getWriter().getDirectContent();
    }

    protected DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    protected void addExtraItem(ExpertDisplayInfoDTO.ItemDTO item) {
        this.documentContext.addExtraItem(item);
    }

    protected Rectangle getPageSize() {
        return this.documentContext.getDocument().getPageSize();
    }
}

