/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FormRendererConfiguration {
    private String watermark = null;
    private boolean copyWatermark = false;
    private boolean printOutline = true;
    private boolean openOutlineByDefault = false;
    private boolean useBoldFonts = false;
    private Map<String, Object> properties = null;
    private ExpertDisplayInfoDTO wizardBackground;
    private Long timestamp;

    public @NonNull FormRendererConfiguration withWatermark(@Nullable String watermark) {
        this.watermark = watermark;
        return this;
    }

    public @NonNull FormRendererConfiguration withCopyWatermark(boolean copyWatermark) {
        this.copyWatermark = copyWatermark;
        return this;
    }

    public @NonNull FormRendererConfiguration withOutline(boolean printOutline) {
        this.printOutline = printOutline;
        return this;
    }

    public @NonNull FormRendererConfiguration withOutlineOpenByDefault(boolean openOutlineByDefault) {
        this.openOutlineByDefault = openOutlineByDefault;
        return this;
    }

    public @NonNull FormRendererConfiguration withBoldFonts(boolean useBoldFonts) {
        this.useBoldFonts = useBoldFonts;
        return this;
    }

    public @NonNull FormRendererConfiguration withProperty(@NonNull String key, @Nullable Object value) {
        if (key == null) {
            throw new NullPointerException("Property key cannot be null.");
        }
        Map<String, Object> properties = this.getProperties();
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
        return this;
    }

    public @NonNull FormRendererConfiguration withWizardBackground(@Nullable ExpertDisplayInfoDTO wizardBackground) {
        this.wizardBackground = wizardBackground;
        return this;
    }

    public @NonNull FormRendererConfiguration withTimestamp(@Nullable Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public @Nullable String getWatermark() {
        return this.watermark;
    }

    public boolean isCopyWatermark() {
        return this.copyWatermark;
    }

    public boolean isPrintOutline() {
        return this.printOutline;
    }

    public boolean isOpenOutlineByDefault() {
        return this.openOutlineByDefault;
    }

    public boolean isUseBoldFonts() {
        return this.useBoldFonts;
    }

    public @NonNull Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public @Nullable ExpertDisplayInfoDTO getWizardBackground() {
        return this.wizardBackground;
    }

    public @Nullable Long getTimestamp() {
        return this.timestamp;
    }
}

