/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.DisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class FormRenderer {
    private  @NonNull AbstractConverter.ConverterContext converterContext;
    private final ImageSource imgSource;
    private final FormRendererConfiguration configuration;
    private final Collection<ProgressListener> progressListeners = new ArrayList<ProgressListener>();

    public FormRenderer(FormRendererConfiguration configuration,  @NonNull AbstractConverter.ConverterContext converterContext, ImageSource imgSource) {
        if (configuration == null) {
            throw new NullPointerException("Configuration cannot be null");
        }
        if (converterContext == null) {
            throw new NullPointerException("ConverterContext cannot be null.");
        }
        if (imgSource == null) {
            throw new NullPointerException("Image source cannot be null");
        }
        this.configuration = configuration;
        this.converterContext = converterContext;
        this.imgSource = imgSource;
    }

    public void render(ExpertDisplayInfoDTO form, OutputStream os) throws FormRendererException, InterruptedException {
        this.render(Collections.singletonList(form), os);
    }

    public abstract void render(List<? extends DisplayInfoDTO> var1, OutputStream var2) throws FormRendererException, InterruptedException;

    public FormRendererConfiguration getConfiguration() {
        return this.configuration;
    }

    protected  @NonNull AbstractConverter.ConverterContext getConverterContext() {
        return this.converterContext;
    }

    protected ImageSource getImageSource() {
        return this.imgSource;
    }

    public void addProgressListener(ProgressListener li) {
        if (li != null) {
            this.progressListeners.add(li);
        }
    }

    public void removeProgressListener(ProgressListener li) {
        if (li != null) {
            this.progressListeners.remove(li);
        }
    }

    protected void notifyProgressListeners(int form) {
        for (ProgressListener listener : this.progressListeners) {
            listener.formRendered(form);
        }
    }
}

