/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.LogicModelItemInfoDTO;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.Importer;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TaxFileImporter
implements Importer {
    private final @NonNull ImportContext ctx;

    public TaxFileImporter(@NonNull ImportContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("Import context cannot be null.");
        }
        this.ctx = ctx;
    }

    @Override
    public void doImport(@Nullable String password) throws ImportException {
        this.importOldModelItems();
    }

    protected void importOldModelItems() throws ImportException {
        this.importOldModelItems(false);
    }

    protected void importOldModelItems(boolean openCurrentYear) throws ImportException {
        for (Map.Entry<String, ModelItemDTO> element : this.getImportContext().getOldDataModel().entrySet()) {
            this.importOldModelItem(element.getKey(), element.getValue(), openCurrentYear);
        }
    }

    protected void importOldModelItem(@NonNull String key, @Nullable ModelItemDTO valueOld) throws ImportException {
        this.importOldModelItem(key, valueOld, false);
    }

    protected void importOldModelItem(@NonNull String key, @Nullable ModelItemDTO valueOld, boolean openCurrentYear) throws ImportException {
        String newKey;
        if (valueOld == null) {
            return;
        }
        ModelItemDTO value = null;
        if (openCurrentYear) {
            newKey = key;
            value = valueOld;
        } else {
            newKey = this.convertKey(key);
            if ((this.isImportable(newKey) || this.isImportable(key)) && valueOld.getValue() != null) {
                value = valueOld.cloneUntouched();
            }
        }
        if (value != null) {
            this.storeInNewModel(newKey, value);
        }
    }

    protected boolean isImportable(@NonNull String dmk) {
        String lmk = EngineUtil.removeTableIndices(dmk);
        LogicModelItemInfoDTO lmiInfo = this.ctx.getLogicModelInfoMap().get(lmk);
        if (lmiInfo == null) {
            return false;
        }
        LogicModelItem.ImportProfile importProfile = lmiInfo.getImportProfile();
        return importProfile == LogicModelItem.ImportProfile.IMPORT_ALL_CASES || importProfile == LogicModelItem.ImportProfile.IMPORT_EMPTY_CASE_ONLY && !this.ctx.isPreInitializedFile();
    }

    protected @NonNull String convertKey(@NonNull String oldKey) {
        String strippedKey = EngineUtil.removeTableIndices(oldKey);
        String newKey = this.getImportContext().getConfig().getImportSettings().getProperty(strippedKey);
        if (newKey == null || newKey.equals(strippedKey)) {
            return oldKey;
        }
        if (strippedKey.equals(oldKey)) {
            return newKey;
        }
        return EngineUtil.mergeModelKey(newKey, oldKey);
    }

    protected void storeInNewModel(@NonNull String key, @Nullable ModelItemDTO value) throws ImportException {
        this.getNewDataModel().put(key, value);
    }

    protected @NonNull Map<String, ModelItemDTO> getNewDataModel() {
        return this.ctx.getNewDataModel();
    }

    protected @NonNull Map<String, ModelItemDTO> getOldDataModel() {
        return this.ctx.getOldDataModel();
    }

    protected @NonNull ImportContext getImportContext() {
        return this.ctx;
    }
}

