/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.engine.LogicModelItemInfoDTO;
import ch.dvbern.tax.common.integration.DvbTaxIdentification;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.common.imports.ImportConfig;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.Importer;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ImportUtil
implements Serializable {
    private static final long serialVersionUID = 8981197371498686727L;
    private final ImportConfig config;

    public ImportUtil(@NonNull ImportConfig config) {
        if (config == null) {
            throw new NullPointerException("Import config cannot be null.");
        }
        this.config = config;
    }

    public ImportConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(@NonNull InputStream in, @NonNull DvbTaxSession session, @Nullable String password, boolean preInitializedFile) throws InvalidAuthenticationException, ImportException, IOException {
        try {
            Map<String, ModelItemDTO> newValues = this.doImport(in, password, session.getLogicModelItemsInfo(), session.getTmoIdentification(), preInitializedFile);
            session.importData(newValues, false);
            session.recalculate();
        }
        finally {
            in.close();
        }
    }

    public @NonNull Map<String, ModelItemDTO> doImport(@NonNull InputStream in, @Nullable String password, @NonNull Map<String, LogicModelItemInfoDTO> logicModelInfoMap, @Nullable DvbTaxIdentification id, boolean preInitializedFile) throws InvalidAuthenticationException, ImportException, IOException {
        Map<String, ModelItemDTO> oldDataModel = TaxFileUtil.read(in, "");
        ImportContext ctx = new ImportContext(new HashMap<String, ModelItemDTO>(), oldDataModel, this.getConfig(), logicModelInfoMap, id, preInitializedFile);
        Importer importer = this.createMainImporter(ctx);
        importer.doImport(password);
        return ctx.getNewDataModel();
    }

    private @NonNull Importer createMainImporter(@NonNull ImportContext ctx) {
        try {
            Class<? extends Importer> clazz = this.getConfig().getMainImporter();
            Constructor<? extends Importer> con = clazz.getConstructor(ctx.getClass());
            Importer importer = con.newInstance(ctx);
            return importer;
        }
        catch (Exception e) {
            throw new RuntimeException("can't instantiate the main importer", e);
        }
    }
}

