/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.conf;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.integration.conf.ApplicationConfigProvider;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticInstanceConfigurationProvider
extends ApplicationConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticInstanceConfigurationProvider.class);
    private static final AtomicReference<ApplicationConfig> INSTANCE_REF = new AtomicReference();

    public static void setInstance(ApplicationConfig instance) {
        ApplicationConfig previousInstance = INSTANCE_REF.getAndSet(instance);
        if (previousInstance != null) {
            LOG.warn("Replaced static configuration instance {} with {}", (Object)previousInstance, (Object)instance);
        }
    }

    @Override
    public ApplicationConfig load() {
        return INSTANCE_REF.get();
    }
}

