/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TableMerge
extends WizardDisplayModelItem {
    private final List<Table> nestedTables;
    private final String name;
    private final String header;
    private final Help help;
    private final int colspan;
    private final int rowspan;
    private final String align;
    private final String buttonPlusText;

    public TableMerge(List<Table> nestedTables, String name, String header, Help help, int colspan, int rowspan, String align, String buttonPlusText) {
        this.nestedTables = nestedTables;
        this.name = name;
        this.header = header;
        this.help = help;
        this.colspan = colspan;
        this.rowspan = rowspan;
        this.align = align;
        this.buttonPlusText = buttonPlusText;
    }

    @Override
    public List<? extends WizardDisplayModelItem> getChildren() {
        return this.nestedTables;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public WizardDisplayInfoDTO.TableItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        WizardDisplayInfoDTO.HelpItemDTO formInfo;
        List<WizardDisplayInfoDTO.ColDefItemDTO> columnDTOs = null;
        ArrayList<WizardDisplayInfoDTO.RowItemDTO> rowDTOs = new ArrayList<WizardDisplayInfoDTO.RowItemDTO>();
        int state = 1;
        String newName = EngineUtil.mergeModelKey(this.getName(), key);
        for (Table table : this.nestedTables) {
            WizardDisplayInfoDTO.TableItemDTO tDTO = table.getFormInfo(dataModel, key);
            if (tDTO == null || tDTO.getRows() == null) continue;
            rowDTOs.addAll(tDTO.getRows());
            if (ModelItemDTO.isMoreImportantState(tDTO.getState(), state)) {
                state = tDTO.getState();
            }
            columnDTOs = tDTO.getColdefs();
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, key)) != null) {
            helpDTO = formInfo;
        }
        return new WizardDisplayInfoDTO.TableItemDTO(this.getUniqueItemIdentifier(), state, newName, this.header, null, columnDTOs, rowDTOs, helpDTO, false, false, null, true, true, this.align, this.colspan, this.rowspan, true, null, 0, false, false, false, this.buttonPlusText, "label.kein.eintrag", null, null, null, false, "", "");
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Table> nestedTables = null;
            Help help = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Help) {
                        help = (Help)ref;
                    }
                    if (ref instanceof Table) {
                        if (nestedTables == null) {
                            nestedTables = new ArrayList<Table>();
                        }
                        nestedTables.add((Table)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            return new ClassObjectPair(TableMerge.class, (Object)new TableMerge(nestedTables, element.getAttributeValue("name"), element.getAttributeValue("header"), help, WizardDisplayUtil.getInt(element.getAttributeValue("colspan"), 1), WizardDisplayUtil.getInt(element.getAttributeValue("rowspan"), 1), WizardDisplayUtil.getString(element.getAttributeValue("align"), "fill"), element.getAttribute("button-plus-text")));
        }
    }
}

