/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.comparators.WizardTableComparatorProvider;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.engine.wizarddisplay.WTableEntryAccessor;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Col;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowIterator;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Table
extends WizardDisplayModelItem
implements WTableEntryAccessor {
    public static final String DEFAULT_NO_ENTRY_TEXT = "label.kein.eintrag";
    private final String name;
    private final @NonNull String deleteMessage;
    private LogicModelItem.TableItem tableItem;
    private final String header;
    private final List<LabelAddOn> headerAddOns;
    private final List<ColDef> coldefs;
    private final List<Col> cols;
    private final Help help;
    private final @Nullable String stateKey;
    private boolean isSubnavigation;
    private Integer sortCol;
    private Comparator<WizardDisplayInfoDTO.RowItemDTO> rowComparator;
    private final String align;
    private final int colspan;
    private final int rowspan;
    private final String viewId;
    private final int rowsPerPage;
    private final boolean readonly;
    private final boolean editable;
    private final boolean addRowEnabled;
    private final boolean deleteRowEnabled;
    private final boolean filter;
    private final boolean statusFilter;
    private final boolean showPrintRow;
    private final String excludeKey;
    private LogicModelItem excludeRef;
    private final String buttonPlusText;
    private final String noEntryText;
    private final WizardTableComparatorProvider comparatorProvider;
    private final String rowState;
    private final String styleClass;
    private final String onlyShowVisualizeButton;
    private final String deleteStateMissingRowsMessage;
    private final boolean allowHideColumns;

    public Table(String name, String header, List<LabelAddOn> headerAddOns, @Nullable String stateKey, List<ColDef> coldefs, Help help, List<Col> cols, String sort, boolean editable, boolean addRowEnabled, boolean deleteRowEnabled, String excludeKey, String align, int colspan, int rowspan, boolean readonly, String viewId, int rowsPerPage, boolean filter, boolean statusFilter, boolean showPrintRow, String buttonPlusText, String noEntryText, WizardTableComparatorProvider comparatorProvider, @Nullable String rowState, @Nullable String styleClass, @NonNull String onlyShowVisualizeButton, @NonNull String deleteMessage, @NonNull String deleteStateMissingRowsMessage, boolean allowHideColumns) {
        this.name = name;
        this.help = help;
        this.cols = cols;
        this.header = header;
        this.stateKey = stateKey;
        this.coldefs = coldefs;
        this.noEntryText = noEntryText;
        if (sort != null) {
            this.sortCol = Integer.parseInt(sort) + 1;
        }
        this.editable = editable;
        this.addRowEnabled = addRowEnabled;
        this.deleteRowEnabled = deleteRowEnabled;
        this.excludeKey = excludeKey;
        this.align = align;
        this.colspan = colspan;
        this.rowspan = rowspan;
        this.readonly = readonly;
        this.viewId = viewId;
        this.headerAddOns = headerAddOns;
        this.rowsPerPage = rowsPerPage;
        this.filter = filter;
        this.statusFilter = statusFilter;
        this.showPrintRow = showPrintRow;
        this.buttonPlusText = buttonPlusText;
        this.comparatorProvider = comparatorProvider;
        this.rowState = rowState;
        this.styleClass = styleClass;
        this.onlyShowVisualizeButton = onlyShowVisualizeButton;
        this.deleteMessage = deleteMessage;
        this.deleteStateMissingRowsMessage = deleteStateMissingRowsMessage;
        this.allowHideColumns = allowHideColumns;
    }

    public Table(String name, String header, List<LabelAddOn> headerAddOns, @Nullable String stateKey, List<ColDef> coldefs, Help help, List<Col> cols, String sort, boolean editable, boolean addRowEnabled, boolean deleteRowEnabled, String excludeKey, String align, int colspan, int rowspan, boolean readonly, String viewId, int rowsPerPage, boolean filter, boolean statusFilter, boolean showPrintRow, String buttonPlusText, String noEntryText, WizardTableComparatorProvider comparatorProvider, @Nullable String rowState, @Nullable String styleClass, @NonNull String onlyShowVisualizeButton, @NonNull String deleteMessage, @NonNull String deleteStateMissingRowsMessage) {
        this(name, header, headerAddOns, stateKey, coldefs, help, cols, sort, editable, addRowEnabled, deleteRowEnabled, excludeKey, align, colspan, rowspan, readonly, viewId, rowsPerPage, filter, statusFilter, showPrintRow, buttonPlusText, noEntryText, comparatorProvider, rowState, styleClass, onlyShowVisualizeButton, deleteMessage, deleteStateMissingRowsMessage, true);
    }

    public List<WizardDisplayModelItem> getChildren() {
        ArrayList<WizardDisplayModelItem> result = new ArrayList<WizardDisplayModelItem>();
        if (this.help != null) {
            result.add(this.help);
        }
        if (this.cols != null) {
            result.addAll(this.cols);
        }
        if (this.coldefs != null) {
            result.addAll(this.coldefs);
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    public List<ColDef> getColdefs() {
        return this.coldefs;
    }

    public List<Col> getCols() {
        return this.cols;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public @Nullable String getStateItem() {
        return this.stateKey;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getHeader() {
        return this.header;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.stateKey != null && logicModelItems.get(this.stateKey) == null) {
            throw new InvalidModelException("invalid state-reference in table: " + this.header);
        }
        if (this.name == null || !(logicModelItems.get(this.name) instanceof LogicModelItem.TableItem)) {
            throw new InvalidModelException("invalid name-reference in table: " + this.name);
        }
        this.tableItem = (LogicModelItem.TableItem)((Object)logicModelItems.get(this.name));
        if (this.tableItem == null) {
            throw new InvalidModelException("invalid table reference (" + this.name + ") in " + this.getClass().getName());
        }
        for (LogicModelItem element : ((LogicModelItem)((Object)this.tableItem)).getChildren()) {
            if (!(element instanceof Module)) continue;
            this.isSubnavigation = true;
        }
        if (this.sortCol != null && (this.cols == null || this.sortCol - 1 >= this.cols.size())) {
            throw new InvalidModelException("invalid sort column index (out of range)");
        }
        this.rowComparator = new RowIterator.RowDTOComparator(this.sortCol);
        if (logicModelItems.get(this.excludeKey) != null) {
            this.excludeRef = logicModelItems.get(this.excludeKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public  @Nullable WizardDisplayInfoDTO.TableItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String itemDMK) {
        boolean show;
        WizardDisplayInfoDTO.HelpItemDTO formInfo;
        DMK dmk = DMK.parse(itemDMK);
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> labelAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.headerAddOns != null) {
            for (LabelAddOn labelAddOn : this.headerAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO formInfo2 = labelAddOn.getFormInfo(dataModel, dmk.toExternalForm());
                if (formInfo2 == null) continue;
                labelAddOnDTOs.add(formInfo2);
            }
        }
        if (labelAddOnDTOs.isEmpty()) {
            labelAddOnDTOs = null;
        }
        ArrayList<WizardDisplayInfoDTO.ColDefItemDTO> coldefDTOs = new ArrayList<WizardDisplayInfoDTO.ColDefItemDTO>();
        for (ColDef colDef : this.coldefs) {
            WizardDisplayInfoDTO.ColDefItemDTO formInfo3;
            boolean colVisible = true;
            if (colDef.getStateKey() != null) {
                colVisible = this.isColVisible(dataModel, dmk.merge(colDef.getStateKey()));
            }
            if (!colVisible && this.allowHideColumns || (formInfo3 = colDef.getFormInfo(dataModel, dmk.toExternalForm())) == null) continue;
            coldefDTOs.add(formInfo3);
        }
        if (coldefDTOs.isEmpty()) {
            coldefDTOs = null;
        }
        Object var6_8 = null;
        if (this.excludeRef != null) {
            ModelItemDTO excludeDTO = dataModel.get(dmk.merge(this.excludeRef.getLMK()).toExternalForm());
            if (excludeDTO == null || excludeDTO.getValue() == null) {
                return null;
            }
            String string = excludeDTO.getValue().toString();
        }
        WizardDisplayInfoDTO.RowItemDTO toRemove = null;
        ArrayList<WizardDisplayInfoDTO.RowItemDTO> rowDTOs = new ArrayList<WizardDisplayInfoDTO.RowItemDTO>();
        RenderBuilder reRender = RenderBuilder.create(this.viewId != null ? this.viewId : "");
        for (Col col : this.cols) {
            WizardDisplayInfoDTO.ColItemDTO colDTO = col.getFormInfo(dataModel, dmk.toExternalForm());
            int currentRow = 0;
            if (colDTO.getItems() == null) continue;
            for (WizardDisplayInfoDTO.ItemItemDTO itemDTO : colDTO.getItems()) {
                ModelItemDTO rowStateItem;
                String tableRowDMK = EngineUtil.removeLastKeyPart(itemDTO.getDataModelKey());
                if (this.rowState != null && ((rowStateItem = dataModel.get(DMK.parse(tableRowDMK).merge(LMK.parse(this.rowState)).toExternalForm())) == null || rowStateItem.getState() == 12)) continue;
                if (rowDTOs.size() <= currentRow) {
                    void var6_10;
                    if (!Render.isRenderSelf(itemDTO.getReRender())) {
                        reRender.append(itemDTO.getReRender());
                    }
                    while (!DMK.parse(tableRowDMK).isRowDMK()) {
                        tableRowDMK = EngineUtil.removeLastKeyPart(tableRowDMK);
                    }
                    ModelItemDTO miDTO = dataModel.get(tableRowDMK);
                    ArrayList<WizardDisplayInfoDTO.AbstractItemDTO> children = new ArrayList<WizardDisplayInfoDTO.AbstractItemDTO>();
                    int state = miDTO == null ? 3 : miDTO.getState();
                    DisplayItemUniqueID tableId = this.getUniqueItemIdentifier();
                    children.add(new WizardDisplayInfoDTO.StateItemDTO(tableId.appendLocal(tableRowDMK + ".row-state"), state));
                    WizardDisplayInfoDTO.RowItemDTO row = new WizardDisplayInfoDTO.RowItemDTO(tableId.appendLocal(tableRowDMK), state, tableRowDMK, children, null, this.deleteRowEnabled, null, null);
                    rowDTOs.add(row);
                    if (var6_10 != null && EngineUtil.getLastKeyPart(tableRowDMK).equals(var6_10)) {
                        toRemove = row;
                    }
                }
                ((WizardDisplayInfoDTO.RowItemDTO)rowDTOs.get(currentRow)).addChild(itemDTO);
                ++currentRow;
            }
        }
        if (toRemove != null) {
            rowDTOs.remove(toRemove);
        }
        if (this.comparatorProvider != null) {
            rowDTOs.sort(this.comparatorProvider.newComparator(dataModel));
        } else {
            rowDTOs.sort(this.rowComparator);
        }
        if (rowDTOs.isEmpty()) {
            rowDTOs = null;
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, itemDMK)) != null) {
            helpDTO = formInfo;
        }
        WizardDisplayInfoDTO.RowItemDTO emptyRow = this.getEmptyRow(dataModel, itemDMK);
        String newName = EngineUtil.mergeModelKey(this.getName(), itemDMK);
        int state = dataModel.getTable(newName).getState();
        if (this.stateKey != null) {
            state = dataModel.getWithoutTouch(EngineUtil.mergeModelKey(this.stateKey, itemDMK)).getState();
        }
        if (!(show = this.onlyShowVisualizeButton.equals("true"))) {
            ModelItemDTO onlyShowVisDTO = dataModel.getWithoutTouch(EngineUtil.mergeModelKey(this.onlyShowVisualizeButton, itemDMK));
            show = onlyShowVisDTO != null && onlyShowVisDTO.getValue() instanceof Boolean && (Boolean)onlyShowVisDTO.getValue() != false;
        }
        return new WizardDisplayInfoDTO.TableItemDTO(this.getUniqueItemIdentifier(), state, newName, this.header, labelAddOnDTOs, coldefDTOs, rowDTOs, helpDTO, this.isSubnavigation, this.editable, emptyRow, this.deleteRowEnabled, this.addRowEnabled, this.align, this.colspan, this.rowspan, this.readonly, this.viewId, this.rowsPerPage, this.filter, this.statusFilter, this.showPrintRow, this.buttonPlusText, this.noEntryText, reRender.build(), this.stateKey, this.styleClass, show, this.deleteMessage, this.deleteStateMissingRowsMessage);
    }

    private boolean isColVisible(WizardDisplayModelItem.ProtectedMap dataModel, @NonNull DMK dmk) {
        ModelItemDTO modelItem = dataModel.getModelItem(dmk);
        return modelItem.getState() != 12;
    }

    private WizardDisplayInfoDTO.RowItemDTO getEmptyRow(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        int nextKey = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)dataModel, this.tableItem, key);
        String mergedName = DMK.parse(key).merge(LMK.parse(this.getName())).toExternalForm();
        String newRowDmk = mergedName + "." + nextKey;
        ArrayList<WizardDisplayInfoDTO.AbstractItemDTO> emptyCols = new ArrayList<WizardDisplayInfoDTO.AbstractItemDTO>();
        emptyCols.add(new WizardDisplayInfoDTO.StateItemDTO(this.getUniqueItemIdentifier().appendLocal(newRowDmk + ".row-state"), 3));
        for (Col col : this.cols) {
            String newDmk = DMK.parse(newRowDmk).merge(LMK.parse(col.getDataModelKey())).toExternalForm();
            ModelItemDTO miDTO = new ModelItemDTO(null, 3);
            OptionItemsDTO optionItems = null;
            if (col.getValueModelItem() instanceof LogicModelItem.SelectItem) {
                optionItems = ((LogicModelItem.SelectItem)((Object)col.getValueModelItem())).getOptionItems(dataModel, newDmk);
            }
            emptyCols.add(new WizardDisplayInfoDTO.ItemItemDTO(col.getUniqueItemIdentifier().appendLocal(newDmk), miDTO.getState(), col.getType(), newDmk, null, 1, 1, 0, optionItems, new ArrayList<MessageItemDTO>(), col.isReadonly(), col.getAlign(), col.getStyle(), col.getStyleClass(), null, null, col.isNegative(), col.getRendererAndValidator(), false, col.getValueKey(), null, null, null, null, null, false));
        }
        return new WizardDisplayInfoDTO.RowItemDTO(this.getUniqueItemIdentifier().appendLocal(newRowDmk), 3, newRowDmk, emptyCols, null, false, null, null);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String noEntryText;
            List elements = element.getChildren();
            ArrayList<ColDef> coldefs = new ArrayList<ColDef>();
            ArrayList<Col> cols = new ArrayList<Col>();
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            Help help = null;
            WizardTableComparatorProvider comparator = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Help) {
                        help = (Help)ref;
                        continue;
                    }
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof ColDef) {
                        coldefs.add((ColDef)ref);
                        continue;
                    }
                    if (ref instanceof Col) {
                        cols.add((Col)ref);
                        continue;
                    }
                    if (ref instanceof WizardTableComparatorProvider) {
                        comparator = (WizardTableComparatorProvider)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (labelAddOns.isEmpty() && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.isEmpty()) {
                labelAddOns = null;
            }
            for (int i = 0; i < cols.size(); ++i) {
                if (coldefs.size() <= i) continue;
                ((ColDef)coldefs.get(i)).setAlign(((Col)cols.get(i)).getAlign());
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            int rowsPerPage = 0;
            if (element.getAttribute("rows-per-page") != null) {
                rowsPerPage = Integer.parseInt(element.getAttribute("rows-per-page"));
            }
            if ((noEntryText = element.getAttributeValue("no-entry-text")) == null) {
                noEntryText = Table.DEFAULT_NO_ENTRY_TEXT;
            }
            return new ClassObjectPair(Table.class, (Object)new Table(element.getAttributeValue("name"), element.getAttributeValue("header"), labelAddOns, element.getAttributeValue("state"), coldefs.isEmpty() ? null : coldefs, help, cols.isEmpty() ? null : cols, element.getAttributeValue("sort"), WizardDisplayUtil.getBoolean(element.getAttributeValue("editable"), false), WizardDisplayUtil.getBoolean(element.getAttributeValue("add-rows"), true), WizardDisplayUtil.getBoolean(element.getAttributeValue("delete-rows"), true), element.getAttributeValue("exclude-ref"), WizardDisplayUtil.getString(element.getAttributeValue("align"), "fill"), WizardDisplayUtil.getInt(element.getAttributeValue("colspan"), 1), WizardDisplayUtil.getInt(element.getAttributeValue("rowspan"), 1), WizardDisplayUtil.getBoolean(element.getAttributeValue("readonly"), false), element.getAttributeValue("viewId"), rowsPerPage, WizardDisplayUtil.getBoolean(element.getAttributeValue("filter"), false), WizardDisplayUtil.getBoolean(element.getAttributeValue("statusFilter"), false), WizardDisplayUtil.getBoolean(element.getAttributeValue("showPrintRow"), false), element.getAttributeValue("button-plus-text"), noEntryText, comparator, element.getAttribute("rowState"), element.getAttributeValue("styleClass"), WizardDisplayUtil.getString(element.getAttributeValue("onlyShowVisualizeButton"), "false"), WizardDisplayUtil.getString(element.getAttributeValue("custom-delete-msg-key"), "label.question.delete.table"), WizardDisplayUtil.getString(element.getAttributeValue("delete-state-missing-rows-msg-key"), "")));
        }
    }
}

