/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WTableEntryAccessor;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowItemBase;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RowIterator
extends RowItemBase
implements WTableEntryAccessor {
    private final String tableName;
    private LogicModelItem table;
    private final List<RowItemBase> children;
    private Integer sortCol;
    private final String emptyLabelKey;
    private Comparator<WizardDisplayInfoDTO.RowItemDTO> rowComparator;

    public RowIterator(List<RowItemBase> rows, String tableName, String sort, String emptyLabelKey) {
        this.children = rows;
        this.tableName = tableName;
        if (sort != null) {
            this.sortCol = Integer.valueOf(sort);
        }
        this.emptyLabelKey = emptyLabelKey;
    }

    public List<RowItemBase> getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return null;
        }
        return this.children;
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.children == null || this.children.isEmpty()) {
            throw new InvalidModelException("missing nested Row instances in RowIterator instance");
        }
        for (RowItemBase child : this.children) {
            if (child instanceof Row || child instanceof RowIterator) continue;
            throw new InvalidModelException("invalid nested element in RowIterator instance (not instance of Row or RowIterator)");
        }
        if (this.sortCol != null && this.children.get(0) instanceof Row && this.sortCol >= ((Row)this.children.get(0)).getCols().size()) {
            throw new InvalidModelException("invalid sort column index (out of range)");
        }
        this.rowComparator = new RowDTOComparator(this.sortCol);
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new InvalidModelException("missing table reference in RowIterator instance");
        }
        LogicModelItem o = logicModelItems.get(this.tableName);
        if (!(o instanceof LogicModelItem.TableItem)) {
            throw new InvalidModelException("invalid table reference(" + this.tableName + ") in RowIterator instance");
        }
        this.table = o;
        if (this.getChildren() != null) {
            for (WizardDisplayModelItem wizardDisplayModelItem : this.getChildren()) {
                wizardDisplayModelItem.setParent(this.getParent());
                if (!(wizardDisplayModelItem instanceof RowIterator)) continue;
                RowIterator it = (RowIterator)wizardDisplayModelItem;
                it.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    @Override
    public List<WizardDisplayInfoDTO.RowItemDTO> getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ArrayList<WizardDisplayInfoDTO.RowItemDTO> result = new ArrayList<WizardDisplayInfoDTO.RowItemDTO>();
        String tableKey = EngineUtil.mergeModelKey(this.table.getName(), key);
        ModelItemDTO miDTO = dataModel.get(tableKey);
        int state = 1;
        if (miDTO == null || miDTO.getValue() == null) {
            return null;
        }
        if (miDTO.getValue() instanceof Set) {
            Set keySet = (Set)miDTO.getValue();
            for (String string : keySet) {
                String rowKey = tableKey + "." + string;
                for (RowItemBase child : this.children) {
                    RowIterator rowIterator;
                    Object rows;
                    if (child instanceof Row) {
                        Row row = (Row)child;
                        WizardDisplayInfoDTO.RowItemDTO formInfo = row.getFormInfo(dataModel, rowKey);
                        if (formInfo == null) continue;
                        result.add(formInfo);
                        if (!ModelItemDTO.isPropagatableState(formInfo.getState()) || !miDTO.hasMoreImportantState(state)) continue;
                        state = formInfo.getState();
                        continue;
                    }
                    if (!(child instanceof RowIterator) || (rows = (rowIterator = (RowIterator)child).getFormInfo(dataModel, rowKey)) == null) continue;
                    result.addAll((Collection<WizardDisplayInfoDTO.RowItemDTO>)rows);
                }
            }
        } else if (this.emptyLabelKey != null && this.getParent() instanceof Section) {
            Section p = (Section)this.getParent();
            int colspan = p.getColdefs().size();
            ArrayList<WizardDisplayInfoDTO.AbstractItemDTO> colDTOs = new ArrayList<WizardDisplayInfoDTO.AbstractItemDTO>();
            colDTOs.add(new WizardDisplayInfoDTO.LabelItemDTO(this.getUniqueItemIdentifier(), state, this.emptyLabelKey, colspan, 0, "left", null, null, null, true, null, null, null));
            result.add(new WizardDisplayInfoDTO.RowItemDTO(this.getUniqueItemIdentifier(), state, null, colDTOs, null, false, null, null));
        }
        if (this.rowComparator != null) {
            Collections.sort(result, this.rowComparator);
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<RowItemBase> children = new ArrayList<RowItemBase>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Row) {
                        children.add((Row)ref);
                        continue;
                    }
                    if (ref instanceof RowIterator) {
                        children.add((RowIterator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            return new ClassObjectPair(RowIterator.class, (Object)new RowIterator(children, element.getAttributeValue("table"), element.getAttributeValue("sort"), element.getAttributeValue("empty")));
        }
    }

    static class RowDTOComparator
    implements Comparator<WizardDisplayInfoDTO.RowItemDTO>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Integer sortCol = null;

        public RowDTOComparator(Integer sortCol) {
            this.sortCol = sortCol;
        }

        @Override
        public int compare(WizardDisplayInfoDTO.RowItemDTO riDTO0, WizardDisplayInfoDTO.RowItemDTO riDTO1) {
            int result = 0;
            if (this.sortCol != null) {
                WizardDisplayInfoDTO.AbstractItemDTO o1;
                WizardDisplayInfoDTO.AbstractItemDTO o0 = riDTO0.getCols().size() > this.sortCol ? riDTO0.getCols().get(this.sortCol) : null;
                WizardDisplayInfoDTO.AbstractItemDTO abstractItemDTO = o1 = riDTO0.getCols().size() > this.sortCol ? riDTO1.getCols().get(this.sortCol) : null;
                if (o0 instanceof WizardDisplayInfoDTO.ItemItemDTO && o1 instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                    Object v0 = ((WizardDisplayInfoDTO.ItemItemDTO)o0).getValue();
                    Object v1 = ((WizardDisplayInfoDTO.ItemItemDTO)o1).getValue();
                    if (v0 == null && v1 == null) {
                        result = 0;
                    } else if (v0 == null && v1 != null) {
                        result = -1;
                    } else if (v0 != null && v1 == null) {
                        result = 1;
                    } else if (v0 instanceof String && v1 instanceof String) {
                        result = ((String)v0).toUpperCase().compareTo(((String)v1).toUpperCase());
                    } else if (v0 instanceof Comparable && v1 instanceof Comparable) {
                        result = ((Comparable)v0).compareTo(v1);
                    }
                }
                return result;
            }
            if (EngineUtil.endsWithTableIndex(riDTO0.getDmkTableEntry()) && EngineUtil.endsWithTableIndex(riDTO1.getDmkTableEntry())) {
                Integer index0 = Integer.valueOf(EngineUtil.getLastKeyPart(riDTO0.getDmkTableEntry()));
                Integer index1 = Integer.valueOf(EngineUtil.getLastKeyPart(riDTO1.getDmkTableEntry()));
                return index0.compareTo(index1);
            }
            return 0;
        }
    }
}

