/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TranslatedLabelConverter;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LabelAddOn
extends WizardDisplayModelItem {
    private final String logicModelItemName;
    private LogicModelItem refModelItem;
    private AbstractConverter<?> rendererAndInputValidator;
    private Integer length;
    private String fillpattern;

    public LabelAddOn(String logicModelItemName) {
        this.logicModelItemName = logicModelItemName;
        this.rendererAndInputValidator = new TranslatedLabelConverter();
    }

    public LabelAddOn(String logicModelItemName, AbstractConverter<?> rendererAndInputValidator, Integer length, String fillpattern, boolean toBeTranslated) {
        this.logicModelItemName = logicModelItemName;
        this.rendererAndInputValidator = rendererAndInputValidator == null || rendererAndInputValidator instanceof TextConverter ? new TranslatedLabelConverter(toBeTranslated) : rendererAndInputValidator;
        this.length = length;
        this.fillpattern = fillpattern;
    }

    public List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.logicModelItemName == null || logicModelItems.get(this.logicModelItemName) == null) {
            throw new InvalidModelException("invalid value-reference in item: " + this.logicModelItemName);
        }
        this.refModelItem = logicModelItems.get(this.logicModelItemName);
    }

    @Override
    public WizardDisplayInfoDTO.LabelAddOnDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ModelItemDTO dto = dataModel.get(EngineUtil.mergeModelKey(this.logicModelItemName, key));
        OptionItemsDTO optionItems = null;
        if (dto != null && this.refModelItem instanceof LogicModelItem.SelectItem) {
            optionItems = ((LogicModelItem.SelectItem)((Object)this.refModelItem)).getOptionItems(dataModel, EngineUtil.mergeModelKey(this.logicModelItemName, key));
        }
        if (dto != null) {
            if (dto.getValue() == null) {
                return new WizardDisplayInfoDTO.LabelAddOnDTO("", this.rendererAndInputValidator, optionItems, this.length, this.fillpattern);
            }
            return new WizardDisplayInfoDTO.LabelAddOnDTO(dto.getValue(), this.rendererAndInputValidator, optionItems, this.length, this.fillpattern);
        }
        return null;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            AbstractConverter rendererAndValidator = null;
            if (elements.size() > 1) {
                throw new ElementParserException("invalid child element in: " + String.valueOf(element));
            }
            if (elements.size() == 1) {
                Element subElement = (Element)elements.get(0);
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (!(ref instanceof AbstractConverter)) {
                        throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                    }
                    rendererAndValidator = (AbstractConverter)ref;
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            WizardDisplayUtil.TypeAndConverter typeAndConverter = WizardDisplayUtil.parseInputType(element, rendererAndValidator);
            Integer length = null;
            if (element.getAttributeValue("length") != null) {
                length = Integer.valueOf(element.getAttributeValue("length"));
            }
            String fillpattern = null;
            if (element.getAttributeValue("fillpattern") != null) {
                fillpattern = element.getAttributeValue("fillpattern");
            }
            boolean toBeTranslated = Boolean.valueOf(element.getAttributeValue("toBeTranslated"));
            return new ClassObjectPair(LabelAddOn.class, (Object)new LabelAddOn(element.getAttributeValue("ref"), typeAndConverter.converter, length, fillpattern, toBeTranslated));
        }
    }
}

