/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NoInput
implements Validator {
    private final List<CalcItem> calcItems;
    private final boolean autoCorrect;
    private final boolean warning;
    private final String messageKey;
    private static final String DEFAULT_ERROR_KEY = "error.value.no.input.default";
    private static final String DEFAULT_WARNING_KEY = "warning.value.no.input.default";
    private static final String DEFAULT_INFO_KEY = "info.value.no.input.default";

    public NoInput(List<CalcItem> calcItems, boolean autoCorrect, boolean warning, String messageKey) {
        this.calcItems = calcItems;
        this.autoCorrect = autoCorrect;
        this.warning = warning;
        this.messageKey = messageKey;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Object value;
        ModelItemDTO result = modelItemDTO;
        FastStack stack = new FastStack();
        for (CalcItem calcItem : this.calcItems) {
            try {
                calcItem.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object object = value = !stack.isEmpty() ? stack.pop() : null;
        if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) {
            return result;
        }
        boolean noInput = false;
        if (result != null && result.getValue() instanceof Boolean) {
            if (((Boolean)result.getValue()).booleanValue()) {
                noInput = true;
            }
        } else if (result != null && result.getValue() instanceof Number) {
            if (((Number)result.getValue()).doubleValue() > 0.0) {
                noInput = true;
            }
        } else if (result != null && result.getValue() instanceof String) {
            if (!((String)result.getValue()).isEmpty()) {
                noInput = true;
            }
        } else if (result != null && result.getValue() != null) {
            noInput = true;
        }
        if (result != null && noInput) {
            if (this.autoCorrect) {
                String msg = this.messageKey == null ? DEFAULT_INFO_KEY : this.messageKey;
                result = result.clone(null, 1, msg, value, 2);
            } else if (this.warning) {
                String msg = this.messageKey == null ? DEFAULT_WARNING_KEY : this.messageKey;
                result = result.clone(2, msg, value, 2);
            } else {
                String msg = this.messageKey == null ? DEFAULT_ERROR_KEY : this.messageKey;
                result = result.clone(4, msg, value, 4);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            boolean tmpCorrect = element.getAttribute("autocorrect") != null && element.getAttributeValue("autocorrect").equalsIgnoreCase("true");
            boolean tmpWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            String tmpMessageKey = element.getAttributeValue("message");
            NoInput result = new NoInput(calcItems, tmpCorrect, tmpWarning, tmpMessageKey);
            return new ClassObjectPair(NoInput.class, (Object)result);
        }
    }
}

