/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.optionitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.calcitems.RelRef;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleOptionItem
implements Select.OptionItemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleOptionItem.class);
    private LinkedHashMap<Object, OptionItemDTO> optionMap;
    private RelRef ref;
    private Class<?> clazz;
    private String shortText;
    private String text;
    private boolean toBeTranslated;
    private boolean useRefForText;
    private final List<CalcItem> calcItems;

    public SimpleOptionItem(OptionItemDTO option, List<CalcItem> calcItems) {
        this.optionMap = new LinkedHashMap();
        this.optionMap.put(option.getValue().toString(), option);
        this.calcItems = calcItems;
    }

    public SimpleOptionItem(RelRef ref, Class<?> clazz, String shortText, String text, boolean toBeTranslated, boolean useRefForText, List<CalcItem> calcItems) {
        this.ref = ref;
        this.clazz = clazz;
        this.shortText = shortText;
        this.text = text;
        this.toBeTranslated = toBeTranslated;
        this.calcItems = calcItems;
        this.useRefForText = useRefForText;
    }

    @Override
    public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        if (this.calcItems != null && !this.calcItems.isEmpty()) {
            Object bValue;
            FastStack stack = new FastStack();
            for (CalcItem element : this.calcItems) {
                try {
                    element.evaluate(dataModel, stack, dataModelKey);
                }
                catch (RuntimeException rte) {
                    throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
                }
            }
            Object object = bValue = !stack.isEmpty() ? stack.pop() : null;
            if (bValue instanceof Boolean && !((Boolean)bValue).booleanValue()) {
                return null;
            }
        }
        if (this.optionMap != null) {
            return OptionItemsDTO.createPlain(this.optionMap);
        }
        if (this.ref != null) {
            LinkedHashMap<Object, OptionItemDTO> result = new LinkedHashMap<Object, OptionItemDTO>();
            try {
                Constructor<?> constructor = this.clazz.getConstructor(String.class);
                ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(this.ref.getName(), dataModelKey));
                if (miDTO != null && miDTO.getValue() != null) {
                    Object value = constructor.newInstance(miDTO.getValue().toString());
                    OptionItemDTO optionItemDTO = this.useRefForText ? new OptionItemDTO(value, this.shortText, value.toString(), this.toBeTranslated) : new OptionItemDTO(value, this.shortText, this.text, this.toBeTranslated);
                    result.put(optionItemDTO.getValue().toString(), optionItemDTO);
                }
            }
            catch (SecurityException e) {
                LOG.error("Error on dmk: " + dataModelKey, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Error on dmk: " + dataModelKey, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error("Error on dmk: " + dataModelKey, (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error("Error on dmk: " + dataModelKey, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Error on dmk: " + dataModelKey, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("Error on dmk: " + dataModelKey, (Throwable)e);
            }
            return OptionItemsDTO.createPlain(result);
        }
        return null;
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.ref != null) {
            this.ref.registerListenerOnReference(logicModel, logicModelItem, false);
        }
        for (CalcItem object : this.calcItems) {
            CalcItem ci = object;
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    @Override
    public boolean hasLocalizedOptions() {
        return false;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            SimpleOptionItem result;
            String text;
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Class clazz = Long.class;
            if (element.getAttributeValue("class") != null) {
                try {
                    clazz = Class.forName(element.getAttributeValue("class"));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ElementParserException((Throwable)cnfe);
                }
            }
            Object value = null;
            if (element.getAttribute("value") != null) {
                String sValue = element.getAttributeValue("value");
                try {
                    Constructor constructor = clazz.getConstructor(String.class);
                    value = constructor.newInstance(sValue);
                }
                catch (Exception t) {
                    throw new ElementParserException((Throwable)t);
                }
            }
            RelRef ref = null;
            if (element.getAttribute("ref") != null) {
                ref = new RelRef(element.getAttributeValue("ref"));
            }
            boolean useRefForText = false;
            if (element.getAttributeValue("useRefForText") != null) {
                useRefForText = Boolean.valueOf(element.getAttributeValue("useRefForText"));
            }
            if ((text = element.getAttributeValue("text")) == null) {
                text = element.getAttributeValue("id");
            }
            String shortText = element.getAttributeValue("shortText");
            boolean toBeTranslated = true;
            if (element.getAttribute("toBeTranslated") != null) {
                toBeTranslated = Boolean.valueOf(element.getAttributeValue("toBeTranslated"));
            }
            if (ref == null) {
                OptionItemDTO optionItemDTO = new OptionItemDTO(value, shortText, text, toBeTranslated);
                result = new SimpleOptionItem(optionItemDTO, calcItems);
            } else {
                result = new SimpleOptionItem(ref, clazz, shortText, text, toBeTranslated, useRefForText, calcItems);
            }
            return new ClassObjectPair(SimpleOptionItem.class, (Object)result);
        }
    }
}

